/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.html.layout;

import java.util.Map;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.html.StaticHtmlMetawidget;
import org.metawidget.statically.html.layout.HtmlLayout;
import org.metawidget.statically.html.layout.HtmlTableLayoutConfig;
import org.metawidget.statically.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.html.widgetbuilder.HtmlTableCell;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.html.widgetbuilder.HtmlTableRow;
import org.metawidget.statically.html.widgetbuilder.HtmlTag;
import org.metawidget.util.WidgetBuilderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableLayout
extends HtmlLayout
implements AdvancedLayout<StaticXmlWidget, StaticXmlWidget, StaticHtmlMetawidget> {
    private String mTableStyle;
    private String mTableStyleClass;

    public HtmlTableLayout() {
        this(new HtmlTableLayoutConfig());
    }

    public HtmlTableLayout(HtmlTableLayoutConfig config) {
        this.mTableStyle = config.getTableStyle();
        this.mTableStyleClass = config.getTableStyleClass();
    }

    @Override
    public void onStartBuild(StaticHtmlMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(StaticXmlWidget container, StaticHtmlMetawidget metawidget) {
        try {
            HtmlTable table = new HtmlTable();
            table.setId(metawidget.getId());
            if (this.mTableStyle != null) {
                table.putAttribute("style", this.mTableStyle);
            }
            if (this.mTableStyleClass != null) {
                table.putAttribute("class", this.mTableStyleClass);
            }
            table.getChildren().add(new HtmlTableBody());
            container.getChildren().add(table);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void layoutWidget(StaticXmlWidget widget, String elementName, Map<String, String> attributes, StaticXmlWidget container, StaticHtmlMetawidget metawidget) {
        try {
            if (widget instanceof StaticXmlStub && widget.getChildren().isEmpty()) {
                return;
            }
            HtmlTableBody body = (HtmlTableBody)container.getChildren().get(0).getChildren().get(0);
            HtmlTableRow row = new HtmlTableRow();
            this.layoutLabel(row, widget, elementName, attributes, metawidget);
            HtmlTableCell cell = new HtmlTableCell();
            cell.getChildren().add(widget);
            row.getChildren().add(cell);
            HtmlTableCell requiredCell = new HtmlTableCell();
            if ("true".equals(attributes.get("required")) && !WidgetBuilderUtils.isReadOnly(attributes) && !"true".equals(attributes.get("hidden"))) {
                requiredCell.setTextContent("*");
            }
            row.getChildren().add(requiredCell);
            body.getChildren().add(row);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void endContainerLayout(StaticXmlWidget container, StaticHtmlMetawidget metawidget) {
    }

    @Override
    public void onEndBuild(StaticHtmlMetawidget metawidget) {
    }

    @Override
    protected boolean layoutLabel(HtmlTag row, StaticXmlWidget widgetNeedingLabel, String elementName, Map<String, String> attributes, StaticHtmlMetawidget metawidget) {
        HtmlTableHeader labelCell = new HtmlTableHeader();
        row.getChildren().add(labelCell);
        return super.layoutLabel(labelCell, widgetNeedingLabel, elementName, attributes, metawidget);
    }
}

