/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    static String LAST_TRACE_MESSAGE;
    static Object[] LAST_TRACE_ARGUMENTS;
    static String LAST_DEBUG_MESSAGE;
    static Object[] LAST_DEBUG_ARGUMENTS;
    static String LAST_INFO_MESSAGE;
    static String LAST_WARN_MESSAGE;
    static String LAST_ERROR_MESSAGE;

    public static Log getLog(Class<?> clazz) {
        try {
            return new CommonsLog(clazz);
        }
        catch (NoClassDefFoundError e) {
            return new UtilLog(clazz.getName());
        }
    }

    private LogUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonsLog
    implements Log {
        private org.apache.commons.logging.Log mLog;

        public CommonsLog(Class<?> clazz) {
            this.mLog = LogFactory.getLog(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.mLog.isTraceEnabled();
        }

        @Override
        public void trace(String trace, Object ... arguments) {
            String logged = trace;
            if (this.isTraceEnabled()) {
                int lastArgument = arguments.length - 1;
                if (lastArgument == -1) {
                    this.mLog.trace((Object)logged);
                } else {
                    if (arguments[lastArgument] instanceof Throwable && trace.indexOf("{" + lastArgument + "}") == -1) {
                        if (lastArgument > 0) {
                            logged = MessageFormat.format(logged, arguments);
                        }
                        this.mLog.trace((Object)logged, (Throwable)arguments[lastArgument]);
                        --lastArgument;
                    } else {
                        logged = MessageFormat.format(logged, arguments);
                        this.mLog.trace((Object)logged);
                    }
                    if (lastArgument != -1 && trace.indexOf("{" + lastArgument + "}") == -1) {
                        throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + trace + "'");
                    }
                }
            }
            LAST_TRACE_MESSAGE = logged;
            LAST_TRACE_ARGUMENTS = arguments;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.mLog.isDebugEnabled();
        }

        @Override
        public void debug(String debug, Object ... arguments) {
            String logged = debug;
            if (this.isDebugEnabled()) {
                int lastArgument = arguments.length - 1;
                if (lastArgument == -1) {
                    this.mLog.debug((Object)logged);
                } else {
                    if (arguments[lastArgument] instanceof Throwable && debug.indexOf("{" + lastArgument + "}") == -1) {
                        if (lastArgument > 0) {
                            logged = MessageFormat.format(logged, arguments);
                        }
                        this.mLog.debug((Object)logged, (Throwable)arguments[lastArgument]);
                        --lastArgument;
                    } else {
                        logged = MessageFormat.format(logged, arguments);
                        this.mLog.debug((Object)logged);
                    }
                    if (lastArgument != -1 && debug.indexOf("{" + lastArgument + "}") == -1) {
                        throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + debug + "'");
                    }
                }
            }
            LAST_DEBUG_MESSAGE = logged;
            LAST_DEBUG_ARGUMENTS = arguments;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.mLog.isInfoEnabled();
        }

        @Override
        public void info(String info, Object ... arguments) {
            String logged = info;
            if (this.isInfoEnabled()) {
                int lastArgument = arguments.length - 1;
                if (lastArgument == -1) {
                    this.mLog.info((Object)logged);
                } else {
                    if (arguments[lastArgument] instanceof Throwable && info.indexOf("{" + lastArgument + "}") == -1) {
                        if (lastArgument > 0) {
                            logged = MessageFormat.format(logged, arguments);
                        }
                        this.mLog.info((Object)logged, (Throwable)arguments[lastArgument]);
                        --lastArgument;
                    } else {
                        logged = MessageFormat.format(logged, arguments);
                        this.mLog.info((Object)logged);
                    }
                    if (lastArgument != -1 && info.indexOf("{" + lastArgument + "}") == -1) {
                        throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + info + "'");
                    }
                }
            }
            LAST_INFO_MESSAGE = logged;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.mLog.isWarnEnabled();
        }

        @Override
        public void warn(String warning, Object ... arguments) {
            String logged = warning;
            if (this.isWarnEnabled()) {
                int lastArgument = arguments.length - 1;
                if (lastArgument == -1) {
                    this.mLog.warn((Object)logged);
                } else {
                    if (arguments[lastArgument] instanceof Throwable && warning.indexOf("{" + lastArgument + "}") == -1) {
                        if (lastArgument > 0) {
                            logged = MessageFormat.format(logged, arguments);
                        }
                        this.mLog.warn((Object)logged, (Throwable)arguments[lastArgument]);
                        --lastArgument;
                    } else {
                        logged = MessageFormat.format(logged, arguments);
                        this.mLog.warn((Object)logged);
                    }
                    if (lastArgument != -1 && warning.indexOf("{" + lastArgument + "}") == -1) {
                        throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + warning + "'");
                    }
                }
            }
            LAST_WARN_MESSAGE = logged;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.mLog.isErrorEnabled();
        }

        @Override
        public void error(String error, Object ... arguments) {
            if (!this.isErrorEnabled()) {
                return;
            }
            String logged = error;
            int lastArgument = arguments.length - 1;
            if (lastArgument == -1) {
                this.mLog.error((Object)logged);
            } else {
                if (arguments[lastArgument] instanceof Throwable && error.indexOf("{" + lastArgument + "}") == -1) {
                    if (lastArgument > 0) {
                        logged = MessageFormat.format(logged, arguments);
                    }
                    this.mLog.error((Object)logged, (Throwable)arguments[lastArgument]);
                    --lastArgument;
                } else {
                    logged = MessageFormat.format(logged, arguments);
                    this.mLog.error((Object)logged);
                }
                if (lastArgument != -1 && error.indexOf("{" + lastArgument + "}") == -1) {
                    throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + error + "'");
                }
            }
            LAST_ERROR_MESSAGE = logged;
        }
    }

    private static class UtilLog
    implements Log {
        private Logger mLogger;

        public UtilLog(String logger) {
            this.mLogger = Logger.getLogger(logger);
        }

        public boolean isTraceEnabled() {
            return this.mLogger.isLoggable(Level.FINER);
        }

        public void trace(String trace, Object ... arguments) {
            LAST_TRACE_MESSAGE = this.log(Level.FINER, trace, arguments);
        }

        public boolean isDebugEnabled() {
            return this.mLogger.isLoggable(Level.FINE);
        }

        public void debug(String debug, Object ... arguments) {
            LAST_DEBUG_MESSAGE = this.log(Level.FINE, debug, arguments);
        }

        public boolean isInfoEnabled() {
            return this.mLogger.isLoggable(Level.INFO);
        }

        public void info(String info, Object ... arguments) {
            LAST_INFO_MESSAGE = this.log(Level.INFO, info, arguments);
        }

        public boolean isWarnEnabled() {
            return this.mLogger.isLoggable(Level.WARNING);
        }

        public void warn(String warning, Object ... arguments) {
            LAST_WARN_MESSAGE = this.log(Level.WARNING, warning, arguments);
        }

        public boolean isErrorEnabled() {
            return this.mLogger.isLoggable(Level.SEVERE);
        }

        public void error(String error, Object ... arguments) {
            LAST_ERROR_MESSAGE = this.log(Level.SEVERE, error, arguments);
        }

        private String log(Level level, String message, Object ... arguments) {
            String logged = message;
            if (this.mLogger.isLoggable(level)) {
                int lastArgument = arguments.length - 1;
                if (lastArgument == -1) {
                    this.mLogger.log(level, logged);
                } else {
                    if (arguments[lastArgument] instanceof Throwable && message.indexOf("{" + lastArgument + "}") == -1) {
                        if (lastArgument > 0) {
                            logged = MessageFormat.format(logged, arguments);
                        }
                        this.mLogger.log(level, logged, (Throwable)arguments[lastArgument]);
                        --lastArgument;
                    } else {
                        logged = MessageFormat.format(logged, arguments);
                        this.mLogger.log(level, logged);
                    }
                    if (lastArgument != -1 && message.indexOf("{" + lastArgument + "}") == -1) {
                        throw new RuntimeException("Given " + (lastArgument + 1) + " arguments to log, but no {" + lastArgument + "} in message '" + message + "'");
                    }
                }
            }
            return logged;
        }
    }

    public static interface Log {
        public boolean isTraceEnabled();

        public void trace(String var1, Object ... var2);

        public boolean isDebugEnabled();

        public void debug(String var1, Object ... var2);

        public boolean isInfoEnabled();

        public void info(String var1, Object ... var2);

        public boolean isWarnEnabled();

        public void warn(String var1, Object ... var2);

        public boolean isErrorEnabled();

        public void error(String var1, Object ... var2);
    }
}

