/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.commons.jexl;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.metawidget.inspectionresultprocessor.commons.jexl.JexlInspectionResultProcessorConfig;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private static final String THIS_ATTRIBUTE = "this";
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = new ThreadLocal();
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private PropertyStyle mInjectThis;
    private Object[] mInject;
    private JexlEngine mJexlEngine;

    public JexlInspectionResultProcessor() {
        this(new JexlInspectionResultProcessorConfig());
    }

    public JexlInspectionResultProcessor(JexlInspectionResultProcessorConfig config) {
        this.mInjectThis = config.getInjectThis();
        this.mInject = config.getInject();
        this.mJexlEngine = this.createEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element processInspectionResultAsDom(Element inspectionResult, M metawidget, Object toInspect, String type, String ... names) {
        try {
            LOCAL_CONTEXT.set(this.createContext(metawidget));
            Element element = super.processInspectionResultAsDom(inspectionResult, metawidget, toInspect, type, names);
            return element;
        }
        finally {
            LOCAL_CONTEXT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEntity(Map<String, String> attributes, M metawidget, Object toInspect, String type, String ... names) {
        JexlContext context = LOCAL_CONTEXT.get();
        try {
            context.set(THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, true, names).getValue());
            super.processEntity(attributes, metawidget, toInspect, type, names);
        }
        finally {
            context.set(THIS_ATTRIBUTE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTraits(Element entity, M metawidget, Object toInspect, String type, String ... names) {
        JexlContext context = LOCAL_CONTEXT.get();
        try {
            context.set(THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, false, names).getValue());
            super.processTraits(entity, metawidget, toInspect, type, names);
        }
        finally {
            context.set(THIS_ATTRIBUTE, null);
        }
    }

    @Override
    protected void processAttributes(Map<String, String> attributes, M metawidget) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Matcher matcher = PATTERN_EXPRESSION.matcher(value);
            int matchOffset = 0;
            while (matcher.find()) {
                String expression = matcher.group(1);
                try {
                    String valueObjectAsString;
                    Object valueObject = this.mJexlEngine.createExpression(expression).evaluate(LOCAL_CONTEXT.get());
                    if (valueObject == null) {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = null;
                            break;
                        }
                        valueObjectAsString = "";
                    } else {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            if (valueObject instanceof Collection) {
                                value = CollectionUtils.toString((Collection)valueObject);
                                break;
                            }
                            if (valueObject.getClass().isArray()) {
                                value = ArrayUtils.toString(valueObject);
                                break;
                            }
                            value = String.valueOf(valueObject);
                            break;
                        }
                        valueObjectAsString = String.valueOf(valueObject);
                    }
                    value = new StringBuilder(value).replace(matcher.start() + matchOffset, matcher.end() + matchOffset, valueObjectAsString).toString();
                    matchOffset += valueObjectAsString.length() - (matcher.end() - matcher.start());
                }
                catch (Exception e) {
                    throw InspectionResultProcessorException.newException("Unable to evaluate " + value, e);
                }
            }
            attributes.put(key, value);
        }
    }

    protected JexlEngine createEngine() {
        return new JexlEngine();
    }

    protected JexlContext createContext(M metawidget) {
        MapContext context = new MapContext();
        if (this.mInject != null) {
            for (Object inject : this.mInject) {
                context.set(StringUtils.decapitalize(inject.getClass().getSimpleName()), inject);
            }
        }
        return context;
    }
}

