/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.oval;

import java.util.HashMap;
import java.util.Map;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.Max;
import net.sf.oval.constraint.MaxLength;
import net.sf.oval.constraint.Min;
import net.sf.oval.constraint.MinLength;
import net.sf.oval.constraint.NotBlank;
import net.sf.oval.constraint.NotEmpty;
import net.sf.oval.constraint.NotNull;
import net.sf.oval.constraint.Range;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OvalInspector
extends BaseObjectInspector {
    public OvalInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public OvalInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        MaxLength maxLength;
        MinLength minLength;
        Length length;
        Max max;
        Min min;
        Range range;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(NotNull.class)) {
            attributes.put("required", "true");
        }
        if (property.isAnnotationPresent(NotEmpty.class)) {
            attributes.put("required", "true");
        }
        if (property.isAnnotationPresent(NotBlank.class)) {
            attributes.put("required", "true");
        }
        if ((range = property.getAnnotation(Range.class)) != null) {
            attributes.put("maximum-value", this.niceValueOf(range.max()));
            attributes.put("minimum-value", this.niceValueOf(range.min()));
        }
        if ((min = property.getAnnotation(Min.class)) != null) {
            attributes.put("minimum-value", this.niceValueOf(min.value()));
        }
        if ((max = property.getAnnotation(Max.class)) != null) {
            attributes.put("maximum-value", this.niceValueOf(max.value()));
        }
        if ((length = property.getAnnotation(Length.class)) != null) {
            if (length.min() > 0) {
                attributes.put("minimum-length", String.valueOf(length.min()));
            }
            if (length.max() > 0) {
                attributes.put("maximum-length", String.valueOf(length.max()));
            }
        }
        if ((minLength = property.getAnnotation(MinLength.class)) != null) {
            attributes.put("minimum-length", String.valueOf(minLength.value()));
        }
        if ((maxLength = property.getAnnotation(MaxLength.class)) != null) {
            attributes.put("maximum-length", String.valueOf(maxLength.value()));
        }
        return attributes;
    }

    private String niceValueOf(double value) {
        if (value % 1.0 == 0.0) {
            return String.valueOf(Double.valueOf(value).intValue());
        }
        return String.valueOf(value);
    }
}

