/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.layout;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.FacetTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.StubTag;
import org.metawidget.jsp.tagext.html.layout.HtmlTableLayoutConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableLayout
implements AdvancedLayout<Tag, BodyTag, MetawidgetTag> {
    private static final String TABLE_PREFIX = "table-";
    private static final String ROW_SUFFIX = "-row";
    private static final String CELL_SUFFIX = "-cell";
    private static final int JUST_COMPONENT_AND_REQUIRED = 2;
    private static final int LABEL_AND_COMPONENT_AND_REQUIRED = 3;
    private final int mNumberOfColumns;
    private final String mTableStyle;
    private final String mTableStyleClass;
    private final String[] mColumnStyleClasses;
    private final String mFooterStyle;
    private final String mFooterStyleClass;

    public HtmlTableLayout() {
        this(new HtmlTableLayoutConfig());
    }

    public HtmlTableLayout(HtmlTableLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
        this.mTableStyle = config.getTableStyle();
        this.mTableStyleClass = config.getTableStyleClass();
        this.mColumnStyleClasses = config.getColumnStyleClasses();
        this.mFooterStyle = config.getFooterStyle();
        this.mFooterStyleClass = config.getFooterStyleClass();
    }

    @Override
    public void onStartBuild(MetawidgetTag metawidgetTag) {
        metawidgetTag.putClientProperty(HtmlTableLayout.class, null);
    }

    @Override
    public void startContainerLayout(BodyTag container, MetawidgetTag metawidgetTag) {
        State state = this.getState(metawidgetTag);
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            writer.write("<table");
            writer.write(" id=\"");
            writer.write(TABLE_PREFIX);
            state.tableType = StringUtils.camelCase(metawidgetTag.getPath(), '.');
            writer.write(state.tableType);
            writer.write("\"");
            if (this.mTableStyle != null) {
                writer.write(" style=\"");
                writer.write(this.mTableStyle);
                writer.write("\"");
            }
            if (this.mTableStyleClass != null) {
                writer.write(" class=\"");
                writer.write(this.mTableStyleClass);
                writer.write("\"");
            }
            writer.write(">");
            FacetTag facetFooter = metawidgetTag.getFacet("footer");
            if (facetFooter != null) {
                writer.write("\r\n<tfoot>");
                writer.write("<tr>");
                writer.write("<td colspan=\"");
                int colspan = Math.max(2, this.mNumberOfColumns * 3);
                writer.write(String.valueOf(colspan));
                writer.write("\"");
                if (this.mFooterStyle != null) {
                    writer.write(" style=\"");
                    writer.write(this.mFooterStyle);
                    writer.write("\"");
                }
                if (this.mFooterStyleClass != null) {
                    writer.write(" class=\"");
                    writer.write(this.mFooterStyleClass);
                    writer.write("\"");
                }
                writer.write(">");
                writer.write(facetFooter.getSavedBodyContent());
                writer.write("</td>");
                writer.write("</tr>");
                writer.write("</tfoot>");
            }
            writer.write("<tbody>");
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void layoutWidget(Tag tag, String elementName, Map<String, String> attributes, BodyTag containerTag, MetawidgetTag metawidgetTag) {
        try {
            String literal = null;
            if (tag instanceof StubTag) {
                literal = ((StubTag)tag).getSavedBodyContent();
                if (literal == null || literal.length() == 0) {
                    return;
                }
            } else {
                literal = JspUtils.writeTag(metawidgetTag.getPageContext(), tag, (Tag)containerTag);
            }
            if (JspUtils.isJustHiddenFields(literal)) {
                State state = this.getState(metawidgetTag);
                if (state.hiddenFields == null) {
                    state.hiddenFields = CollectionUtils.newArrayList();
                }
                state.hiddenFields.add(literal);
                return;
            }
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            this.layoutBeforeChild(tag, elementName, attributes, metawidgetTag);
            writer.write(literal);
            this.layoutAfterChild(attributes, metawidgetTag);
        }
        catch (Exception e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void endContainerLayout(BodyTag container, MetawidgetTag metawidgetTag) {
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            writer.write("</tbody>");
            writer.write("</table>");
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    @Override
    public void onEndBuild(MetawidgetTag metawidgetTag) {
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            State state = this.getState(metawidgetTag);
            if (state.hiddenFields != null) {
                for (String hiddenField : state.hiddenFields) {
                    writer.write("\r\n");
                    writer.write(hiddenField);
                }
            }
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    protected void layoutBeforeChild(Tag tag, String elementName, Map<String, String> attributes, MetawidgetTag metawidgetTag) {
        State state = this.getState(metawidgetTag);
        ++state.currentColumn;
        try {
            int colspan;
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            String id = null;
            if (attributes != null) {
                id = attributes.get("name");
                if (id != null) {
                    id = StringUtils.capitalize(StringUtils.camelCase(id));
                }
                if (SimpleLayoutUtils.isSpanAllColumns(attributes) && state.currentColumn != 1) {
                    writer.write("</tr>");
                    state.currentColumn = 1;
                }
            }
            if (state.currentColumn == 1 || state.currentColumn > this.mNumberOfColumns) {
                state.currentColumn = 1;
                writer.write("\r\n<tr");
                if (id != null) {
                    writer.write(" id=\"");
                    writer.write(TABLE_PREFIX);
                    writer.write(state.tableType);
                    writer.write(id);
                    writer.write(ROW_SUFFIX);
                    writer.write("\"");
                }
                writer.write(">");
            }
            boolean labelWritten = this.layoutLabel(elementName, attributes, metawidgetTag);
            if (this.mNumberOfColumns == 0) {
                writer.write("</tr>\r\n<tr");
                if (id != null) {
                    writer.write(" id=\"");
                    writer.write(TABLE_PREFIX);
                    writer.write(state.tableType);
                    writer.write(id);
                    writer.write(ROW_SUFFIX);
                    writer.write("2\"");
                }
                writer.write(">");
            }
            writer.write("<td");
            if (id != null) {
                writer.write(" id=\"");
                writer.write(TABLE_PREFIX);
                writer.write(state.tableType);
                writer.write(id);
                writer.write(CELL_SUFFIX);
                writer.write("\"");
            }
            this.writeStyleClass(1, metawidgetTag);
            if (tag instanceof MetawidgetTag || SimpleLayoutUtils.isSpanAllColumns(attributes)) {
                colspan = this.mNumberOfColumns * 3 - 2;
                state.currentColumn = this.mNumberOfColumns;
                if (!labelWritten) {
                    ++colspan;
                }
                if (tag instanceof MetawidgetTag) {
                    ++colspan;
                }
            } else {
                colspan = !labelWritten ? 2 : 1;
            }
            if (colspan > 1) {
                writer.write(" colspan=\"");
                writer.write(String.valueOf(colspan));
                writer.write("\"");
            }
            writer.write(">");
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    protected void layoutAfterChild(Map<String, String> attributes, MetawidgetTag metawidgetTag) {
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            writer.write("</td>");
            writer.write("<td");
            State state = this.getState(metawidgetTag);
            this.writeStyleClass(2, metawidgetTag);
            writer.write(">");
            writer.write(this.layoutRequired(attributes, metawidgetTag));
            writer.write("</td>");
            if (state.currentColumn >= this.mNumberOfColumns) {
                state.currentColumn = 0;
                writer.write("</tr>");
            }
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    protected boolean layoutLabel(String elementName, Map<String, String> attributes, MetawidgetTag metawidgetTag) {
        String labelText = metawidgetTag.getLabelString(attributes);
        if (labelText == null) {
            return false;
        }
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            writer.write("<th");
            this.writeStyleClass(0, metawidgetTag);
            writer.write(">");
            if (SimpleLayoutUtils.needsLabel(labelText, elementName)) {
                writer.write("<label>");
                writer.write(labelText);
                writer.write(":</label>");
            }
            writer.write("</th>");
            return true;
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    protected String layoutRequired(Map<String, String> attributes, MetawidgetTag metawidgetTag) {
        if (attributes != null && "true".equals(attributes.get("required")) && !WidgetBuilderUtils.isReadOnly(attributes) && !metawidgetTag.isReadOnly()) {
            return "*";
        }
        return "<div></div>";
    }

    protected void writeStyleClass(int styleClass, MetawidgetTag metawidgetTag) {
        if (this.mColumnStyleClasses == null || this.mColumnStyleClasses.length <= styleClass) {
            return;
        }
        String columnClass = this.mColumnStyleClasses[styleClass];
        if (columnClass.length() == 0) {
            return;
        }
        try {
            JspWriter writer = metawidgetTag.getPageContext().getOut();
            writer.write(" class=\"");
            writer.write(columnClass.trim());
            writer.write("\"");
        }
        catch (IOException e) {
            throw LayoutException.newException(e);
        }
    }

    private State getState(MetawidgetTag metawidget) {
        State state = (State)metawidget.getClientProperty(HtmlTableLayout.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(HtmlTableLayout.class, state);
        }
        return state;
    }

    static class State {
        public int currentColumn;
        public List<String> hiddenFields;
        public String tableType;

        State() {
        }
    }
}

