/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.widgetprocessor.binding.databinding;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.widgetprocessor.binding.databinding.DataBindingProcessorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingProcessor
implements AdvancedWidgetProcessor<Control, SwtMetawidget> {
    private List<DisplayRealm> mRealms = CollectionUtils.newArrayList();
    private final Map<ConvertFromTo, IConverter> mConverters = CollectionUtils.newHashMap();

    public DataBindingProcessor() {
        this(new DataBindingProcessorConfig());
    }

    public DataBindingProcessor(DataBindingProcessorConfig config) {
        IConverter[] converters = config.getConverters();
        if (converters != null) {
            for (IConverter converter : converters) {
                this.mConverters.put(new ConvertFromTo((Class)converter.getFromType(), (Class)converter.getToType()), converter);
            }
        }
    }

    @Override
    public void onStartBuild(SwtMetawidget metawidget) {
        metawidget.setData(DataBindingProcessor.class.getName(), null);
    }

    @Override
    public Control processWidget(Control control, String elementName, Map<String, String> attributes, SwtMetawidget metawidget) {
        if ("action".equals(elementName)) {
            return control;
        }
        if (control instanceof SwtMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwtMetawidget)control);
            return control;
        }
        String controlProperty = metawidget.getValueProperty(control);
        if (controlProperty == null) {
            return control;
        }
        State state = this.getState(metawidget);
        Realm realm = state.bindingContext.getValidationRealm();
        IObservableValue observeTarget = BeanProperties.value((String)controlProperty).observe(realm, (Object)control);
        UpdateValueStrategy targetToModel = "true".equals(attributes.get("no-setter")) ? new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER) : new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        Object toInspect = metawidget.getToInspect();
        String propertyName = PathUtils.parsePath(metawidget.getInspectionPath()).getNames().replace('/', '.');
        if ("property".equals(elementName)) {
            if (propertyName.length() > 0) {
                propertyName = propertyName + '.';
            }
            propertyName = propertyName + attributes.get("name");
        }
        IObservableValue observeModel = PojoObservables.observeValue((Realm)realm, toInspect, (String)propertyName);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        targetToModel.setConverter(this.getConverter((Class)observeTarget.getValueType(), (Class)observeModel.getValueType()));
        modelToTarget.setConverter(this.getConverter((Class)observeModel.getValueType(), (Class)observeTarget.getValueType()));
        state.bindingContext.bindValue(observeTarget, observeModel, targetToModel, modelToTarget);
        return control;
    }

    public Object convertFromString(String value, Class<?> expectedType) {
        IConverter converterFromString = this.getConverter(String.class, expectedType);
        if (converterFromString != null) {
            return converterFromString.convert((Object)value);
        }
        return value;
    }

    @Override
    public void onEndBuild(SwtMetawidget metawidget) {
        State state = this.getState(metawidget);
        state.bindingContext.updateTargets();
    }

    public void save(SwtMetawidget metawidget) {
        State state = this.getState(metawidget);
        state.bindingContext.updateModels();
        for (Object validationStatusProvider : state.bindingContext.getValidationStatusProviders()) {
            Binding binding = (Binding)validationStatusProvider;
            BindingStatus bindingStatus = (BindingStatus)binding.getValidationStatus().getValue();
            if (bindingStatus.isOK()) continue;
            throw WidgetProcessorException.newException(bindingStatus.getException());
        }
        if (state.nestedMetawidgets != null) {
            for (SwtMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.save(nestedMetawidget);
            }
        }
    }

    private State getState(SwtMetawidget metawidget) {
        State state = (State)metawidget.getData(DataBindingProcessor.class.getName());
        if (state == null) {
            state = new State();
            state.bindingContext = new DataBindingContext(this.getRealm(metawidget.getDisplay()));
            metawidget.setData(DataBindingProcessor.class.getName(), state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm getRealm(Display display) {
        List<DisplayRealm> list = this.mRealms;
        synchronized (list) {
            for (DisplayRealm realm : this.mRealms) {
                if (realm.mDisplay != display) continue;
                return realm;
            }
            DisplayRealm realm = new DisplayRealm(display);
            this.mRealms.add(realm);
            return realm;
        }
    }

    private IConverter getConverter(Class<?> sourceClass, Class<?> targetClass) {
        for (Class<?> sourceClassTraversal = sourceClass; sourceClassTraversal != null; sourceClassTraversal = sourceClassTraversal.getSuperclass()) {
            IConverter converter = this.mConverters.get(new ConvertFromTo(sourceClassTraversal, targetClass));
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo {
        private Class<?> mSource;
        private Class<?> mTarget;

        public ConvertFromTo(Class<?> source, Class<?> target) {
            this.mSource = source;
            this.mTarget = target;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!ObjectUtils.nullSafeClassEquals(this, that)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)that).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)that).mTarget);
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mSource.hashCode());
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mTarget.hashCode());
            return hashCode;
        }
    }

    static class DisplayRealm
    extends Realm {
        Display mDisplay;

        DisplayRealm(Display display) {
            this.mDisplay = display;
        }

        public boolean isCurrent() {
            return Display.getCurrent() == this.mDisplay;
        }
    }

    static class State {
        DataBindingContext bindingContext;
        Set<SwtMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

