/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.util.simple.SimpleLayoutUtils;

public abstract class HtmlLayoutRenderer
extends Renderer {
    private static final String LABEL_ID_SUFFIX = "-label";

    public void encodeBegin(FacesContext context, UIComponent metawidgetComponent) throws IOException {
        UIMetawidget metawidget = (UIMetawidget)metawidgetComponent;
        metawidget.putClientProperty(HtmlLayoutRenderer.class, null);
        super.encodeBegin(context, (UIComponent)metawidget);
        State state = this.getState((UIComponent)metawidget);
        state.labelSuffix = metawidget.getParameter("labelSuffix");
        String inlineMessagesParameter = metawidget.getParameter("inlineMessages");
        if (inlineMessagesParameter != null) {
            state.inlineMessages = Boolean.valueOf(inlineMessagesParameter);
        }
        state.messageStyle = metawidget.getParameter("messageStyle");
        state.messageStyleClass = metawidget.getParameter("messageStyleClass");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getLabelText(UIComponent componentNeedingLabel) {
        Map metadataAttributes = (Map)componentNeedingLabel.getAttributes().get("metawidget-metadata");
        return ((UIMetawidget)componentNeedingLabel.getParent()).getLabelString(metadataAttributes);
    }

    protected boolean layoutLabel(FacesContext context, UIComponent metawidget, UIComponent componentNeedingLabel) throws IOException {
        if (componentNeedingLabel instanceof UICommand) {
            return false;
        }
        String labelText = this.getLabelText(componentNeedingLabel);
        if (!SimpleLayoutUtils.needsLabel(labelText, null)) {
            return false;
        }
        UIOutput componentLabel = this.createLabel(context, componentNeedingLabel);
        State state = this.getState(metawidget);
        if (state.labelSuffix == null) {
            state.labelSuffix = ":";
        }
        componentLabel.setValue((Object)(labelText + state.labelSuffix));
        FacesUtils.render(context, (UIComponent)componentLabel);
        return true;
    }

    protected UIOutput createLabel(FacesContext context, UIComponent componentNeedingLabel) {
        HtmlOutputLabel componentLabel = (HtmlOutputLabel)context.getApplication().createComponent("javax.faces.HtmlOutputLabel");
        if (componentNeedingLabel instanceof UIStub) {
            if (componentNeedingLabel.getChildren().size() == 1) {
                componentLabel.setFor(((UIComponent)componentNeedingLabel.getChildren().get(0)).getId());
            }
        } else if (componentNeedingLabel.getId() != null) {
            componentLabel.setFor(componentNeedingLabel.getId());
        }
        if (componentLabel.getFor() != null) {
            componentLabel.setParent(componentNeedingLabel.getParent());
            componentLabel.setId(componentLabel.getFor() + LABEL_ID_SUFFIX);
        }
        return componentLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChild(FacesContext context, UIComponent metawidget, UIComponent childComponent) throws IOException {
        FacesUtils.render(context, childComponent);
        if (childComponent instanceof HtmlInputHidden) {
            return;
        }
        String messageFor = childComponent.getId();
        if (childComponent instanceof UIMetawidget) {
            UIComponent childOfChild = null;
            for (UIComponent child : childComponent.getChildren()) {
                if (child instanceof UIParameter) continue;
                if (childOfChild != null) {
                    return;
                }
                childOfChild = child;
            }
            if (childOfChild == null) {
                return;
            }
            messageFor = childOfChild.getId();
        } else if (!(childComponent instanceof UIInput)) {
            return;
        }
        Map metadataAttributes = (Map)childComponent.getAttributes().get("metawidget-metadata");
        if (metadataAttributes != null && ("true".equals(metadataAttributes.get("read-only")) || ((UIMetawidget)metawidget).isReadOnly())) {
            return;
        }
        State state = this.getState(metawidget);
        if (!state.inlineMessages) {
            return;
        }
        List children = metawidget.getChildren();
        UIComponent inlineMessage = this.createInlineMessage(context, metawidget, messageFor);
        try {
            children.add(inlineMessage);
            FacesUtils.render(context, inlineMessage);
        }
        finally {
            children.remove(inlineMessage);
        }
    }

    protected UIComponent createInlineMessage(FacesContext context, UIComponent metawidget, String messageFor) {
        HtmlMessage message = (HtmlMessage)context.getApplication().createComponent("javax.faces.HtmlMessage");
        message.setId(FacesUtils.createUniqueId());
        message.setFor(messageFor);
        State state = this.getState(metawidget);
        FacesUtils.setStyleAndStyleClass((UIComponent)message, state.messageStyle, state.messageStyleClass);
        return message;
    }

    protected void writeStyleAndClass(UIMetawidget metawidget, ResponseWriter writer, String style) throws IOException {
        String styleClassParameter;
        String styleParameter = metawidget.getParameter(style + "Style");
        if (styleParameter != null) {
            writer.writeAttribute("style", (Object)styleParameter, "style");
        }
        if ((styleClassParameter = metawidget.getParameter(style + "StyleClass")) != null) {
            writer.writeAttribute("class", (Object)styleClassParameter, "class");
        }
    }

    private State getState(UIComponent metawidget) {
        State state = (State)((UIMetawidget)metawidget).getClientProperty(HtmlLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)metawidget).putClientProperty(HtmlLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        boolean inlineMessages = true;
        String messageStyle;
        String messageStyleClass;
        String labelSuffix;

        State() {
        }
    }
}

