/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.tagext.LiteralTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.jsp.tagext.html.widgetbuilder.HtmlWidgetBuilderUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    @Override
    public Tag buildWidget(String elementName, Map<String, String> attributes, MetawidgetTag metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            attributes.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(elementName)) {
            return this.createSubmitTag(attributes, metawidget);
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return this.createCheckboxTag(attributes, metawidget);
        }
        String jspLookup = attributes.get("jsp-lookup");
        if (jspLookup != null && !"".equals(jspLookup)) {
            return this.createSelectTag(jspLookup, attributes, metawidget);
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return this.createSelectTag(CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes, metawidget);
        }
        if (clazz != null) {
            if (Boolean.TYPE.equals(clazz)) {
                return this.createCheckboxTag(attributes, metawidget);
            }
            if (clazz.isPrimitive()) {
                return this.createTextTag(attributes, metawidget);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("<textarea");
                    builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
                    builder.append(">");
                    builder.append(HtmlWidgetBuilderUtils.evaluateAsText(attributes, metawidget));
                    builder.append("</textarea>");
                    return new LiteralTag(builder.toString());
                }
                if ("true".equals(attributes.get("masked"))) {
                    return this.createTextTag("password", attributes, metawidget);
                }
                return this.createTextTag(attributes, metawidget);
            }
            if (Character.class.equals(clazz)) {
                return this.createTextTag(attributes, metawidget);
            }
            if (Date.class.equals(clazz)) {
                return this.createTextTag(attributes, metawidget);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createTextTag(attributes, metawidget);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createTextTag(attributes, metawidget);
        }
        return null;
    }

    private Tag createCheckboxTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"checkbox\"");
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        builder.append(this.writeCheckedAttribute(attributes, metawidget));
        builder.append("/>");
        return new LiteralTag(builder.toString());
    }

    private Tag createTextTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        return this.createTextTag("text", attributes, metawidget);
    }

    private Tag createTextTag(String textTag, Map<String, String> attributes, MetawidgetTag metawidget) {
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"");
        builder.append(textTag);
        builder.append("\"");
        builder.append(HtmlWidgetBuilderUtils.writeValueAttribute(attributes, metawidget));
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, null);
        if (Character.TYPE.equals(clazz) || Character.class.equals(clazz)) {
            builder.append(" maxlength=\"1\"");
        } else {
            String maximumLength = attributes.get("maximum-length");
            if (maximumLength != null && !"".equals(maximumLength)) {
                builder.append(" maxlength=\"");
                builder.append(maximumLength);
                builder.append("\"");
            }
        }
        builder.append("/>");
        return new LiteralTag(builder.toString());
    }

    private Tag createSubmitTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"submit\" value=\"");
        builder.append(metawidget.getLabelString(attributes));
        builder.append("\"");
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        builder.append("/>");
        return new LiteralTag(builder.toString());
    }

    private String writeCheckedAttribute(Map<String, String> attributes, MetawidgetTag metawidget) {
        Object result = HtmlWidgetBuilderUtils.evaluate(attributes, metawidget);
        if (result != null && ((Boolean)result).booleanValue()) {
            return " checked";
        }
        return "";
    }

    private Tag createSelectTag(String expression, Map<String, String> attributes, MetawidgetTag metawidget) {
        ArrayList<Object> collection = HtmlWidgetBuilderUtils.evaluate(expression, metawidget);
        if (collection == null) {
            return null;
        }
        if (collection instanceof Collection && !(collection instanceof List)) {
            collection = CollectionUtils.newArrayList((Collection)collection);
        } else if (collection.getClass().isArray()) {
            collection = CollectionUtils.newArrayList((Object[])collection);
        }
        return this.createSelectTag((List)collection, null, attributes, metawidget);
    }

    private Tag createSelectTag(List<?> values, List<String> labels, Map<String, String> attributes, MetawidgetTag metawidget) {
        if (labels != null && !labels.isEmpty() && labels.size() != values.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<select");
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        builder.append(">");
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            builder.append("<option value=\"\"></option>");
        }
        String selected = HtmlWidgetBuilderUtils.evaluateAsText(attributes, metawidget);
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            Object value = values.get(loop);
            if (value == null) continue;
            String stringValue = StringUtils.quietValueOf(value);
            builder.append("<option value=\"");
            builder.append(stringValue);
            builder.append("\"");
            if (stringValue.equals(selected)) {
                builder.append(" selected");
            }
            builder.append(">");
            if (labels == null || labels.isEmpty()) {
                builder.append(stringValue);
            } else {
                builder.append(labels.get(loop));
            }
            builder.append("</option>");
        }
        builder.append("</select>");
        return new LiteralTag(builder.toString());
    }
}

