/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.metawidget.util.CollectionUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Pattern PATTERN_AMP;
    private static final Pattern PATTERN_LT;
    private static final Pattern PATTERN_GT;
    private static final Pattern PATTERN_QUOT;
    private static final Pattern PATTERN_APOS;

    public static Map<String, String> getAttributesAsMap(Node node) {
        NamedNodeMap nodes = node.getAttributes();
        int length = nodes.getLength();
        if (length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = CollectionUtils.newHashMap(length);
        for (int loop = 0; loop < length; ++loop) {
            Node attributeNode = nodes.item(loop);
            attributes.put(attributeNode.getNodeName(), attributeNode.getNodeValue());
        }
        return attributes;
    }

    public static void setMapAsAttributes(Element element, Map<String, String> attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                element.removeAttribute(entry.getKey());
                continue;
            }
            element.setAttribute(entry.getKey(), value);
        }
    }

    public static Element getChildNamed(Element element, String ... names) {
        if (element == null) {
            return null;
        }
        Element child = null;
        NodeList children = element.getChildNodes();
        for (String name : names) {
            block4: {
                int length = children.getLength();
                for (int loop = 0; loop < length; ++loop) {
                    Node node = children.item(loop);
                    if (!(node instanceof Element) || !name.equals((child = (Element)node).getLocalName())) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            children = child.getChildNodes();
        }
        return child;
    }

    public static Element getChildWithAttribute(Element element, String attributeName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Element child;
            Node node = children.item(loop);
            if (!(node instanceof Element) || !(child = (Element)node).hasAttribute(attributeName)) continue;
            return child;
        }
        return null;
    }

    public static Element getChildWithAttributeValue(Element element, String attributeName, String attributeValue) {
        int length;
        NodeList children;
        if (element == null) {
            return null;
        }
        try {
            children = element.getChildNodes();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            length = children.getLength();
        }
        catch (NullPointerException e) {
            return null;
        }
        for (int loop = 0; loop < length; ++loop) {
            Node node;
            try {
                node = children.item(loop);
            }
            catch (NullPointerException e) {
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            try {
                if (!attributeValue.equals(child.getAttribute(attributeName))) continue;
                return child;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element getSiblingNamed(Element element, String name) {
        if (element == null) {
            return null;
        }
        Node node = element;
        do {
            if ((node = node.getNextSibling()) != null) continue;
            return null;
        } while (!(node instanceof Element) || !name.equals(node.getNodeName()));
        return (Element)node;
    }

    public static Element getSiblingWithAttribute(Element element, String attributeName) {
        Node nextSibling;
        if (element == null) {
            return null;
        }
        Node node = element;
        do {
            if ((node = node.getNextSibling()) != null) continue;
            return null;
        } while (!(node instanceof Element) || !(nextSibling = node).hasAttribute(attributeName));
        return nextSibling;
    }

    public static Element importElement(Document document, Element element) {
        try {
            return (Element)document.importNode(element, true);
        }
        catch (DOMException e) {
            Element imported = document.createElementNS(element.getNamespaceURI(), element.getNodeName());
            XmlUtils.setMapAsAttributes(imported, XmlUtils.getAttributesAsMap(element));
            NodeList nodeList = imported.getChildNodes();
            for (int loop = 0; loop < nodeList.getLength(); ++loop) {
                Node node = nodeList.item(loop);
                if (!(node instanceof Element)) continue;
                imported.appendChild(XmlUtils.importElement(document, (Element)node));
            }
            return imported;
        }
    }

    public static String documentToString(Document document, boolean pretty) {
        if (document == null) {
            return "";
        }
        return XmlUtils.nodeToString(document.getFirstChild(), pretty);
    }

    public static String nodeToString(Node node, boolean pretty) {
        return XmlUtils.nodeToString(node, pretty ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document documentFromString(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
            synchronized (documentBuilder) {
                return DOCUMENT_BUILDER.parse(new InputSource(new StringReader(xml)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() {
        DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
        synchronized (documentBuilder) {
            return DOCUMENT_BUILDER.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream stream) throws IOException, SAXException {
        DocumentBuilder documentBuilder = DOCUMENT_BUILDER;
        synchronized (documentBuilder) {
            return DOCUMENT_BUILDER.parse(stream);
        }
    }

    public static Element getFirstChildElement(Element parent) {
        Node node;
        for (node = parent.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextSiblingElement(Element element) {
        try {
            Node node;
            for (node = element.getNextSibling(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
            }
            return (Element)node;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void combineElements(Element master, Element toAdd, String topLevelAttributeToCombineOn, String childAttributeToCombineOn) {
        NamedNodeMap attributesToAdd = toAdd.getAttributes();
        int length = attributesToAdd.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node nodeToAdd = attributesToAdd.item(loop);
            String attributeToAddName = nodeToAdd.getNodeName();
            String attributeToAddValue = nodeToAdd.getNodeValue();
            if (attributeToAddValue == null || attributeToAddValue.length() == 0) {
                master.removeAttribute(attributeToAddName);
            }
            master.setAttribute(attributeToAddName, attributeToAddValue);
        }
        NodeList childrenToAdd = toAdd.getChildNodes();
        NodeList masterChildren = master.getChildNodes();
        HashSet childNamesAdded = CollectionUtils.newHashSet();
        Node nodeLastMasterCombinePoint = null;
        int addLength = childrenToAdd.getLength();
        block1: for (int addLoop = 0; addLoop < addLength; ++addLoop) {
            Node nodeChildToAdd = childrenToAdd.item(addLoop);
            if (!(nodeChildToAdd instanceof Element)) continue;
            Element childToAdd = (Element)nodeChildToAdd;
            String childToAddName = childToAdd.getAttribute(topLevelAttributeToCombineOn);
            if (childToAddName == null || "".equals(childToAddName)) {
                throw new RuntimeException("Child node #" + (addLoop + 1) + " has no @" + topLevelAttributeToCombineOn + ": " + XmlUtils.nodeToString((Node)childToAdd, false));
            }
            if (!childNamesAdded.add(childToAddName)) {
                throw new RuntimeException("Element has more than one child with @" + topLevelAttributeToCombineOn + " '" + childToAddName + "'");
            }
            int masterLength = masterChildren.getLength();
            for (int masterLoop = 0; masterLoop < masterLength; ++masterLoop) {
                String nodeNameInAdd;
                Element masterChild;
                String masterChildName;
                Node nodeMasterChild = masterChildren.item(masterLoop);
                if (!(nodeMasterChild instanceof Element) || !childToAddName.equals(masterChildName = (masterChild = (Element)nodeMasterChild).getAttribute(topLevelAttributeToCombineOn))) continue;
                String nodeNameInMaster = masterChild.getNodeName();
                if (!nodeNameInMaster.equals(nodeNameInAdd = childToAdd.getNodeName())) {
                    throw new RuntimeException("Matching elements named '" + masterChildName + "', but existing one is a '" + nodeNameInMaster + "' whilst new one is a '" + nodeNameInAdd + "'");
                }
                nodeLastMasterCombinePoint = masterLoop == masterLength - 1 ? null : masterChild;
                XmlUtils.combineElements(masterChild, childToAdd, childAttributeToCombineOn, childAttributeToCombineOn);
                continue block1;
            }
            if (nodeLastMasterCombinePoint != null) {
                Element imported = XmlUtils.importElement(master.getOwnerDocument(), childToAdd);
                master.insertBefore(imported, nodeLastMasterCombinePoint.getNextSibling());
                nodeLastMasterCombinePoint = imported;
                continue;
            }
            master.appendChild(XmlUtils.importElement(master.getOwnerDocument(), childToAdd));
        }
    }

    private static String nodeToString(Node node, int indent) {
        NamedNodeMap attributes;
        Node name;
        if (node == null) {
            return null;
        }
        if (!(node instanceof Element)) {
            String value = node.getNodeValue();
            if (value == null) {
                return null;
            }
            return XmlUtils.escapeForXml(value.trim());
        }
        StringBuilder builder = new StringBuilder();
        XmlUtils.indent(builder, indent);
        String nodeName = XmlUtils.escapeForXml(node.getNodeName());
        builder.append("<");
        builder.append(nodeName);
        String namespace = node.getNamespaceURI();
        Node parentNode = node.getParentNode();
        if (!(namespace == null || parentNode != null && namespace.equals(parentNode.getNamespaceURI()))) {
            builder.append(" xmlns=\"");
            builder.append(namespace);
            builder.append("\"");
        }
        if ((name = (attributes = node.getAttributes()).getNamedItem("name")) != null) {
            builder.append(" name=\"");
            builder.append(XmlUtils.escapeForXml(name.getNodeValue()));
            builder.append("\"");
        }
        for (int loop = 0; loop < attributes.getLength(); ++loop) {
            Node attribute = attributes.item(loop);
            String attributeName = attribute.getNodeName();
            if ("xmlns".equals(attributeName) || "name".equals(attributeName)) continue;
            builder.append(" ");
            builder.append(XmlUtils.escapeForXml(attributeName));
            builder.append("=\"");
            builder.append(XmlUtils.escapeForXml(attribute.getNodeValue()));
            builder.append("\"");
        }
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        if (length == 0) {
            builder.append("/>");
        } else {
            builder.append(">");
            int nextIndent = indent;
            if (indent != -1) {
                ++nextIndent;
            }
            for (int loop = 0; loop < length; ++loop) {
                Node childNode = children.item(loop);
                if (indent != -1 && childNode instanceof Element) {
                    builder.append("\n");
                }
                builder.append(XmlUtils.nodeToString(childNode, nextIndent));
            }
            if (indent != -1 && builder.charAt(builder.length() - 1) == '>') {
                builder.append("\n");
                XmlUtils.indent(builder, indent);
            }
            builder.append("</");
            builder.append(nodeName);
            builder.append(">");
        }
        return builder.toString();
    }

    private static void indent(StringBuilder builder, int indent) {
        for (int loop = 0; loop < indent; ++loop) {
            builder.append("   ");
        }
    }

    private static String escapeForXml(String in) {
        if (in == null) {
            return "";
        }
        String out = in;
        out = PATTERN_AMP.matcher(out).replaceAll("&amp;");
        out = PATTERN_LT.matcher(out).replaceAll("&lt;");
        out = PATTERN_GT.matcher(out).replaceAll("&gt;");
        out = PATTERN_QUOT.matcher(out).replaceAll("&quot;");
        out = PATTERN_APOS.matcher(out).replaceAll("&apos;");
        return out;
    }

    private XmlUtils() {
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DOCUMENT_BUILDER = factory.newDocumentBuilder();
            DOCUMENT_BUILDER.setEntityResolver(new NopEntityResolver());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        PATTERN_AMP = Pattern.compile("&", 16);
        PATTERN_LT = Pattern.compile("<", 16);
        PATTERN_GT = Pattern.compile(">", 16);
        PATTERN_QUOT = Pattern.compile("\"", 16);
        PATTERN_APOS = Pattern.compile("'", 16);
    }

    static class NopEntityResolver
    implements EntityResolver {
        private static final byte[] BYTES = "<?xml version='1.0' encoding='UTF-8'?>".getBytes();

        NopEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new ByteArrayInputStream(BYTES));
        }
    }

    public static class CachingContentHandler
    extends DefaultHandler {
        private ContentHandler mDelegate;
        private CachedCommand mLastCommand;
        private ArrayList<CachedCommand> mCache = CollectionUtils.newArrayList();
        private boolean mCachingPaused;

        public CachingContentHandler(ContentHandler delegate) {
            this.mDelegate = delegate;
        }

        public boolean isPaused() {
            return this.mCachingPaused;
        }

        public void pause(boolean includeLastEvent) {
            if (this.isPaused()) {
                throw new RuntimeException("CachingContentHandler already paused");
            }
            this.mCachingPaused = true;
            if (!includeLastEvent) {
                this.mCache.remove(this.mCache.size() - 1);
            }
        }

        public void unpause(boolean includeLastEvent) {
            if (!this.isPaused()) {
                throw new RuntimeException("CachingContentHandler not paused");
            }
            this.mCachingPaused = false;
            if (includeLastEvent) {
                this.mCache.add(this.mLastCommand);
            }
        }

        public void replay(ContentHandler replayTo) throws SAXException {
            if (this.mCache.isEmpty()) {
                throw new SAXException("Nothing to replay. Not cached any SAX events");
            }
            if (this.mDelegate != null) {
                throw new SAXException("Not ready to replay - ContentHandler delegate is non-null. Either endDocument must be triggered, or releaseDelegate must be called explicitly");
            }
            for (CachedCommand cachedCommand : this.mCache) {
                cachedCommand.replay(replayTo);
            }
        }

        public void releaseDelegate() {
            this.mDelegate = null;
            this.mLastCommand = null;
            this.mCache.trimToSize();
        }

        public void startDocument() throws SAXException {
            this.mLastCommand = new StartDocumentCommand();
            if (!this.mCachingPaused) {
                if (!this.mCache.isEmpty()) {
                    throw new SAXException("Already cached SAX events. CachingContentHandler can only cache SAX events once");
                }
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.mLastCommand = new ProcessingInstructionCommand(target, data);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void setDocumentLocator(Locator locator) {
            this.mDelegate.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.mLastCommand = new SkippedEntityCommand(name);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mLastCommand = new StartPrefixMappingCommand(prefix, uri);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.mLastCommand = new EndPrefixMappingCommand(prefix);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.mLastCommand = new StartElementCommand(uri, localName, name, attributes);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void characters(char[] characters, int start, int length) throws SAXException {
            this.mLastCommand = new CharactersCommand(characters, start, length);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void ignorableWhitespace(char[] characters, int start, int length) throws SAXException {
            this.mLastCommand = new IgnorableWhitespaceCommand(characters, start, length);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.mLastCommand = new EndElementCommand(uri, localName, name);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endDocument() throws SAXException {
            this.mLastCommand = new EndDocumentCommand();
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
            this.releaseDelegate();
        }

        private static class EndDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.endDocument();
            }

            public String toString() {
                return "endDocument";
            }
        }

        private static class EndElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;

            public EndElementCommand(String uri, String localName, String qName) {
                this.mUri = uri;
                this.mLocalName = localName;
                this.mQName = qName;
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.endElement(this.mUri, this.mLocalName, this.mQName);
            }

            public String toString() {
                return "endElement " + this.mUri + " " + this.mLocalName + " " + this.mQName;
            }
        }

        private static class IgnorableWhitespaceCommand
        implements CachedCommand {
            private char[] mCharacters;

            public IgnorableWhitespaceCommand(char[] characters, int start, int length) {
                this.mCharacters = new char[length];
                System.arraycopy(characters, start, this.mCharacters, 0, length);
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.ignorableWhitespace(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "ignorableWhitespace " + String.valueOf(this.mCharacters);
            }
        }

        private static class CharactersCommand
        implements CachedCommand {
            private char[] mCharacters;

            public CharactersCommand(char[] characters, int start, int length) {
                this.mCharacters = new char[length];
                System.arraycopy(characters, start, this.mCharacters, 0, length);
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.characters(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "characters " + String.valueOf(this.mCharacters);
            }
        }

        private static class StartElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;
            private Attributes mAttributes;

            public StartElementCommand(String uri, String localName, String qName, Attributes attributes) {
                this.mUri = uri;
                this.mLocalName = localName;
                this.mQName = qName;
                this.mAttributes = new AttributesImpl(attributes);
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.startElement(this.mUri, this.mLocalName, this.mQName, this.mAttributes);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("startElement ");
                builder.append(this.mUri);
                builder.append(' ');
                builder.append(this.mLocalName);
                builder.append(' ');
                builder.append(this.mQName);
                int length = this.mAttributes.getLength();
                for (int loop = 0; loop < length; ++loop) {
                    builder.append(" ");
                    builder.append(this.mAttributes.getLocalName(loop));
                    builder.append("=\"");
                    builder.append(this.mAttributes.getValue(loop));
                    builder.append("\"");
                }
                return builder.toString();
            }
        }

        private static class EndPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;

            public EndPrefixMappingCommand(String prefix) {
                this.mPrefix = prefix;
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.endPrefixMapping(this.mPrefix);
            }

            public String toString() {
                return "endPrefixMapping " + this.mPrefix;
            }
        }

        private static class StartPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;
            private String mUri;

            public StartPrefixMappingCommand(String prefix, String uri) {
                this.mPrefix = prefix;
                this.mUri = uri;
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.startPrefixMapping(this.mPrefix, this.mUri);
            }

            public String toString() {
                return "startPrefixMapping " + this.mPrefix + " " + this.mUri;
            }
        }

        private static class SkippedEntityCommand
        implements CachedCommand {
            private String mName;

            public SkippedEntityCommand(String name) {
                this.mName = name;
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.skippedEntity(this.mName);
            }

            public String toString() {
                return "skippedEntity " + this.mName;
            }
        }

        private static class ProcessingInstructionCommand
        implements CachedCommand {
            private String mTarget;
            private String mData;

            public ProcessingInstructionCommand(String target, String data) {
                this.mTarget = target;
                this.mData = data;
            }

            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.processingInstruction(this.mTarget, this.mData);
            }

            public String toString() {
                return "processInstruction " + this.mTarget + " " + this.mData;
            }
        }

        private static class StartDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler replayTo) throws SAXException {
                replayTo.startDocument();
            }

            public String toString() {
                return "startDocument";
            }
        }

        private static interface CachedCommand {
            public void replay(ContentHandler var1) throws SAXException;
        }
    }
}

