/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.xsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.xsd.XmlSchemaInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSchemaInspector
extends BaseXmlInspector {
    private static final String COMPLEX_TYPE = "complexType";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String SIMPLE_CONTENT = "simpleContent";
    private static final String REF = "ref";
    private static final String BASE = "base";
    private static final String ALL = "all";
    private static final String SEQUENCE = "sequence";
    private static final String EXTENSION = "extension";
    private static final String RESTRICTION = "restriction";
    private static final String ENUMERATION = "enumeration";
    private static final String VALUE = "value";

    public XmlSchemaInspector(XmlSchemaInspectorConfig config) {
        super(config);
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getReferenceAttribute() {
        return REF;
    }

    @Override
    protected Element traverseFromTopLevelTypeToNamedChildren(Element topLevel) {
        Element complexType;
        if (SIMPLE_TYPE.equals(topLevel.getLocalName())) {
            return topLevel;
        }
        if (COMPLEX_TYPE.equals(topLevel.getLocalName())) {
            complexType = topLevel;
        } else {
            complexType = XmlUtils.getFirstChildElement(topLevel);
            if (complexType == null) {
                if (!topLevel.hasAttribute("type")) {
                    return null;
                }
                complexType = XmlUtils.getChildWithAttributeValue(topLevel.getOwnerDocument().getDocumentElement(), "name", topLevel.getAttribute("type"));
                if (complexType == null) {
                    return null;
                }
            }
            if (SIMPLE_TYPE.equals(complexType.getLocalName())) {
                return topLevel;
            }
            if (!COMPLEX_TYPE.equals(complexType.getLocalName())) {
                throw InspectorException.newException("Unexpected child node '" + complexType.getLocalName() + "'");
            }
        }
        Element sequence = XmlUtils.getFirstChildElement(complexType);
        if (sequence == null) {
            return null;
        }
        String sequenceLocalName = sequence.getLocalName();
        if ("annotation".equals(sequenceLocalName)) {
            sequence = XmlUtils.getNextSiblingElement(sequence);
            sequenceLocalName = sequence.getLocalName();
        }
        if (!(SEQUENCE.equals(sequenceLocalName) || ALL.equals(sequenceLocalName) || SIMPLE_CONTENT.equals(sequenceLocalName) || COMPLEX_CONTENT.equals(sequenceLocalName) || "attributeGroup".equals(sequenceLocalName))) {
            throw InspectorException.newException("Unexpected child node '" + sequenceLocalName + "'");
        }
        Element choice = XmlUtils.getChildNamed(sequence, "choice");
        if (choice != null) {
            return choice;
        }
        return sequence;
    }

    @Override
    protected void inspectTraits(Element toInspect, Element toAddTo) {
        Element toInspectToUse = toInspect;
        if (SIMPLE_TYPE.equals(toInspectToUse.getLocalName())) {
            HashMap<String, String> attributes = CollectionUtils.newHashMap();
            this.inspectRestriction(toInspectToUse, attributes);
            XmlUtils.setMapAsAttributes(toAddTo, attributes);
            return;
        }
        if (SIMPLE_CONTENT.equals(toInspectToUse.getLocalName())) {
            HashMap<String, String> attributes = CollectionUtils.newHashMap();
            this.inspectExtension(toInspectToUse, attributes);
            this.inspectRestriction(toInspectToUse, attributes);
            XmlUtils.setMapAsAttributes(toAddTo, attributes);
            return;
        }
        if (COMPLEX_CONTENT.equals(toInspectToUse.getLocalName())) {
            if ((toInspectToUse = XmlUtils.getChildNamed(toInspectToUse, EXTENSION)) == null) {
                throw InspectorException.newException("Expected complexContent to have an extension");
            }
            String base = toInspectToUse.getAttribute(BASE);
            if (base == null) {
                throw InspectorException.newException("Expected extension to have a base");
            }
            Element baseElement = XmlUtils.getChildWithAttributeValue(toInspectToUse.getOwnerDocument().getDocumentElement(), this.getTopLevelTypeAttribute(), base);
            Element baseSequence = XmlUtils.getFirstChildElement(baseElement);
            if (!SEQUENCE.equals(baseSequence.getLocalName())) {
                throw InspectorException.newException("Unexpected child node '" + baseSequence.getLocalName() + "'");
            }
            this.inspectTraits(baseSequence, toAddTo);
            toInspectToUse = XmlUtils.getFirstChildElement(toInspectToUse);
            if (!SEQUENCE.equals(toInspectToUse.getLocalName())) {
                throw InspectorException.newException("Unexpected child node '" + toInspectToUse.getLocalName() + "'");
            }
        }
        super.inspectTraits(toInspectToUse, toAddTo);
    }

    @Override
    protected Map<String, String> inspectProperty(Element toInspect) {
        Element toInspectToUse;
        HashMap<String, String> attributes;
        block10: {
            attributes = CollectionUtils.newHashMap();
            toInspectToUse = toInspect;
            while (true) {
                Element typeToUse;
                if (toInspectToUse == null) {
                    return null;
                }
                if ("any".equals(toInspectToUse.getLocalName())) {
                    return null;
                }
                if (toInspectToUse.hasAttribute(REF)) {
                    String name = toInspectToUse.getAttribute(REF);
                    if (!attributes.containsKey("name")) {
                        attributes.put("name", name);
                    }
                    toInspectToUse = XmlUtils.getChildWithAttributeValue(toInspectToUse.getOwnerDocument().getDocumentElement(), this.getTopLevelTypeAttribute(), name);
                    continue;
                }
                if (toInspectToUse.hasChildNodes() || !toInspectToUse.hasAttribute("type")) break;
                this.inspectElement(toInspectToUse, attributes);
                if (!attributes.containsKey("name")) {
                    attributes.put("name", toInspectToUse.getAttribute("name"));
                }
                if ((typeToUse = XmlUtils.getChildWithAttributeValue(toInspectToUse.getOwnerDocument().getDocumentElement(), this.getTopLevelTypeAttribute(), toInspectToUse.getAttribute("type"))) != null) {
                    toInspectToUse = typeToUse;
                    continue;
                }
                break block10;
                break;
            }
            if (COMPLEX_TYPE.equals(toInspectToUse.getLocalName())) {
                Element simpleContent = XmlUtils.getChildNamed(toInspectToUse, SIMPLE_CONTENT);
                if (simpleContent != null) {
                    this.inspectExtension(simpleContent, attributes);
                    this.inspectRestriction(simpleContent, attributes);
                }
                return attributes;
            }
            if (!attributes.containsKey("name") && toInspectToUse.hasAttribute("name")) {
                attributes.put("name", toInspectToUse.getAttribute("name"));
            }
        }
        this.inspectElement(toInspectToUse, attributes);
        return attributes;
    }

    private void inspectElement(Element element, Map<String, String> attributes) {
        if (element.hasAttribute("type")) {
            attributes.put("type", element.getAttribute("type"));
        } else {
            Element complexType = XmlUtils.getChildNamed(element, COMPLEX_TYPE);
            if (complexType != null) {
                Element simpleContent = XmlUtils.getChildNamed(complexType, SIMPLE_CONTENT);
                if (simpleContent != null) {
                    this.inspectExtension(simpleContent, attributes);
                    this.inspectRestriction(simpleContent, attributes);
                }
            } else if (SIMPLE_TYPE.equals(element.getLocalName())) {
                this.inspectRestriction(element, attributes);
            } else {
                Element simpleType = XmlUtils.getChildNamed(element, SIMPLE_TYPE);
                if (simpleType != null) {
                    this.inspectRestriction(simpleType, attributes);
                }
            }
        }
        String notNull = element.getAttribute("minOccurs");
        if (!"".equals(notNull) && Integer.parseInt(notNull) > 0) {
            attributes.put("required", "true");
        }
    }

    private void inspectExtension(Element parent, Map<String, String> attributes) {
        Element extension = XmlUtils.getChildNamed(parent, EXTENSION);
        if (extension == null) {
            return;
        }
        if (extension.hasAttribute(BASE)) {
            attributes.put("type", extension.getAttribute(BASE));
        }
    }

    private void inspectRestriction(Element parent, Map<String, String> attributes) {
        Element enumeration;
        Element fractionDigits;
        Element maxInclusive;
        Element minInclusive;
        Element maxLength;
        Element minLength;
        Element restriction = XmlUtils.getChildNamed(parent, RESTRICTION);
        if (restriction == null) {
            return;
        }
        if (restriction.hasAttribute(BASE)) {
            attributes.put("type", restriction.getAttribute(BASE));
        }
        if ((minLength = XmlUtils.getChildNamed(restriction, "minLength")) != null) {
            attributes.put("minimum-length", minLength.getAttribute(VALUE));
        }
        if ((maxLength = XmlUtils.getChildNamed(restriction, "maxLength")) != null) {
            attributes.put("maximum-length", maxLength.getAttribute(VALUE));
        }
        if ((minInclusive = XmlUtils.getChildNamed(restriction, "minInclusive")) != null) {
            attributes.put("minimum-value", minInclusive.getAttribute(VALUE));
        }
        if ((maxInclusive = XmlUtils.getChildNamed(restriction, "maxInclusive")) != null) {
            attributes.put("maximum-value", maxInclusive.getAttribute(VALUE));
        }
        if ((fractionDigits = XmlUtils.getChildNamed(restriction, "fractionDigits")) != null) {
            attributes.put("maximum-fractional-digits", fractionDigits.getAttribute(VALUE));
        }
        if ((enumeration = XmlUtils.getChildNamed(restriction, ENUMERATION)) != null) {
            ArrayList lookup = CollectionUtils.newArrayList();
            while (enumeration != null) {
                lookup.add(enumeration.getAttribute(VALUE));
                enumeration = XmlUtils.getSiblingNamed(enumeration, ENUMERATION);
            }
            attributes.put("lookup", CollectionUtils.toString(lookup));
        }
    }
}

