// Metawidget
//
// This library is dual licensed under both LGPL and a commercial
// license.
//
// LGPL: this library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// Commercial License: See http://metawidget.org for details

package org.metawidget.statically.faces.component.widgetprocessor;

import static org.metawidget.inspector.InspectionResultConstants.*;

import java.util.Map;

import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.statically.faces.component.StaticUIMetawidget;
import org.metawidget.statically.faces.component.ValueHolder;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;

/**
 * @author <a href="http://kennardconsulting.com">Richard Kennard</a>
 */

public class StandardBindingProcessor
	implements WidgetProcessor<StaticXmlWidget, StaticUIMetawidget> {

	//
	// Public methods
	//

	public StaticXmlWidget processWidget( StaticXmlWidget widget, String elementName, Map<String, String> attributes, StaticUIMetawidget metawidget ) {

		if ( widget instanceof ValueHolder ) {

			ValueHolder valueHolder = (ValueHolder) widget;

			// (do not overwrite existing, if any)

			if ( valueHolder.getValue() == null ) {
				String valueExpression = metawidget.getValue();

				if ( valueExpression != null ) {

					// If we are not at the top level, construct the binding

					if ( !ENTITY.equals( elementName ) ) {
						valueExpression = StaticFacesUtils.unwrapExpression( valueExpression );
						valueExpression += StringUtils.SEPARATOR_DOT_CHAR;

						// attribute names *must* be decapitalized for EL to work, even if the
						// actual attribute name starts with an uppercase

						valueExpression += StringUtils.decapitalize( attributes.get( NAME ) );
						valueExpression = StaticFacesUtils.wrapExpression( valueExpression );
					}

					valueHolder.setValue( valueExpression );
				}
			}
		}

		return widget;
	}
}
