/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.impl;

import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.DomInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInspectionResultProcessor<M>
implements DomInspectionResultProcessor<Element, M> {
    @Override
    public final String processInspectionResult(String inspectionResult, M metawidget, Object toInspect, String type, String ... names) {
        Document document = XmlUtils.documentFromString(inspectionResult);
        Element inspectionResultRoot = document.getDocumentElement();
        Element newInspectionResultRoot = this.processInspectionResultAsDom(inspectionResultRoot, metawidget, toInspect, type, names);
        return XmlUtils.documentToString(newInspectionResultRoot.getOwnerDocument(), false);
    }

    @Override
    public Element processInspectionResultAsDom(Element inspectionResult, M metawidget, Object toInspect, String type, String ... names) {
        Element entity = XmlUtils.getFirstChildElement(inspectionResult);
        String elementName = entity.getNodeName();
        if (!"entity".equals(elementName)) {
            throw InspectionResultProcessorException.newException("Top-level element name should be entity, not " + elementName);
        }
        Map<String, String> attributes = XmlUtils.getAttributesAsMap(entity);
        this.processEntity(attributes, metawidget, toInspect, type, names);
        XmlUtils.setMapAsAttributes(entity, attributes);
        this.processTraits(entity, metawidget, toInspect, type, names);
        return inspectionResult;
    }

    protected void processTraits(Element entity, M metawidget, Object toInspect, String type, String ... names) {
        Element trait = XmlUtils.getFirstChildElement(entity);
        while (trait != null) {
            Map<String, String> attributes = XmlUtils.getAttributesAsMap(trait);
            this.processTrait(attributes, metawidget);
            XmlUtils.setMapAsAttributes(trait, attributes);
            if (trait.getChildNodes().getLength() > 0 && attributes.containsKey("name")) {
                this.processTraits(trait, metawidget, toInspect, type, ArrayUtils.add(names, attributes.get("name")));
            }
            trait = XmlUtils.getNextSiblingElement(trait);
        }
    }

    protected void processEntity(Map<String, String> attributes, M metawidget, Object toInspect, String type, String ... names) {
        this.processAttributes(attributes, metawidget);
    }

    protected void processTrait(Map<String, String> attributes, M metawidget) {
        this.processAttributes(attributes, metawidget);
    }

    protected void processAttributes(Map<String, String> attributes, M metawidget) {
    }
}

