/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComesAfterInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private static final int PERMANENT_MARK = -1;

    @Override
    public Element processInspectionResultAsDom(Element inspectionResult, M metawidget, Object toInspect, String type, String ... names) {
        try {
            LinkedHashMap<String, TopologicalElement> topologicalElements = CollectionUtils.newLinkedHashMap();
            Element entity = XmlUtils.getFirstChildElement(inspectionResult);
            Element trait = XmlUtils.getFirstChildElement(entity);
            while (trait != null) {
                topologicalElements.put(trait.getAttribute("name"), new TopologicalElement(trait));
                trait = XmlUtils.getNextSiblingElement(trait);
            }
            ArrayList<TopologicalElement> unmarkedNodes = CollectionUtils.newArrayList();
            for (TopologicalElement topologicalElement : topologicalElements.values()) {
                unmarkedNodes.add(topologicalElement);
                trait = topologicalElement.getElement();
                if (!this.hasComesAfter(trait, metawidget)) continue;
                String comesAfters = this.getComesAfter(trait, metawidget);
                if ("".equals(comesAfters)) {
                    for (TopologicalElement comesAfter : topologicalElements.values()) {
                        if (comesAfter.equals(topologicalElement)) continue;
                        topologicalElement.addComesAfter(comesAfter);
                    }
                    continue;
                }
                String[] comesAftersArray = ArrayUtils.fromString(comesAfters);
                String traitName = trait.getAttribute("name");
                for (String comesAfter : comesAftersArray) {
                    if (comesAfter.equals(traitName)) {
                        throw InspectionResultProcessorException.newException('\'' + traitName + "' " + "comes-after" + " itself");
                    }
                    TopologicalElement comesAfterElement = (TopologicalElement)topologicalElements.get(comesAfter);
                    if (comesAfterElement == null) continue;
                    topologicalElement.addComesAfter(comesAfterElement);
                }
            }
            ArrayList<Element> sortedTraits = CollectionUtils.newArrayList();
            this.topologicalSort(unmarkedNodes, sortedTraits);
            Document newDocument = XmlUtils.newDocument();
            Element newInspectionResult = newDocument.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            XmlUtils.setMapAsAttributes(newInspectionResult, XmlUtils.getAttributesAsMap(inspectionResult));
            newDocument.appendChild(newInspectionResult);
            Element newEntity = newDocument.createElementNS("http://metawidget.org/inspection-result", "entity");
            XmlUtils.setMapAsAttributes(newEntity, XmlUtils.getAttributesAsMap(entity));
            newInspectionResult.appendChild(newEntity);
            for (Element sortedTrait : sortedTraits) {
                newEntity.appendChild(XmlUtils.importElement(newDocument, sortedTrait));
            }
            return newInspectionResult;
        }
        catch (Exception e) {
            throw InspectionResultProcessorException.newException(e);
        }
    }

    protected boolean hasComesAfter(Element element, M metawidget) {
        return element.hasAttribute("comes-after");
    }

    protected String getComesAfter(Element element, M metawidget) {
        return element.getAttribute("comes-after");
    }

    private void topologicalSort(Collection<TopologicalElement> unmarkedNodes, List<Element> sorted) {
        while (!unmarkedNodes.isEmpty()) {
            TopologicalElement node = unmarkedNodes.iterator().next();
            this.topologicalVisit(node, unmarkedNodes, sorted, unmarkedNodes.size());
        }
    }

    private void topologicalVisit(TopologicalElement node, Collection<TopologicalElement> unmarkedNodes, List<Element> sorted, int temporaryMark) {
        if (node.getMark() == -1) {
            return;
        }
        if (node.getMark() == temporaryMark) {
            ArrayList infiniteLoopNames = CollectionUtils.newArrayList();
            for (TopologicalElement infiniteLoopNode : unmarkedNodes) {
                Element trait = infiniteLoopNode.getElement();
                String comesAfter = this.getComesAfter(trait, null);
                if (comesAfter == null) continue;
                String value = comesAfter.length() == 0 ? "at the end" : "after " + comesAfter.replace(",", " and ");
                infiniteLoopNames.add(trait.getAttribute("name") + " comes " + value);
            }
            Collections.sort(infiniteLoopNames);
            throw InspectionResultProcessorException.newException("Infinite loop detected when sorting comes-after: " + CollectionUtils.toString(infiniteLoopNames, ", but "));
        }
        node.setMark(temporaryMark);
        for (TopologicalElement comesAfter : node.getComesAfter()) {
            this.topologicalVisit(comesAfter, unmarkedNodes, sorted, temporaryMark);
        }
        node.setMark(-1);
        unmarkedNodes.remove(node);
        sorted.add(node.getElement());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopologicalElement {
        private Element mElement;
        private int mMark;
        private Collection<TopologicalElement> mComesAfter = CollectionUtils.newArrayList();

        public TopologicalElement(Element element) {
            this.mElement = element;
        }

        public Element getElement() {
            return this.mElement;
        }

        public Collection<TopologicalElement> getComesAfter() {
            return this.mComesAfter;
        }

        public void addComesAfter(TopologicalElement comesAfter) {
            this.mComesAfter.add(comesAfter);
        }

        public void setMark(int mark) {
            this.mMark = mark;
        }

        public int getMark() {
            return this.mMark;
        }
    }
}

