/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.BaseHtmlMetawidgetTag;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlWidgetBuilderUtils {
    public static String writeValueAttribute(Map<String, String> attributes, MetawidgetTag metawidget) {
        String result = HtmlWidgetBuilderUtils.evaluateAsText(attributes, metawidget);
        if (result == null || "".equals(result)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" value=\"");
        builder.append(result);
        builder.append("\"");
        return builder.toString();
    }

    public static String writeAttributes(Map<String, String> attributes, MetawidgetTag metawidget) {
        BaseHtmlMetawidgetTag htmlMetawidgetTag;
        StringBuilder builder = new StringBuilder();
        String name = attributes.get("name");
        if (name != null) {
            builder.append(" name=\"");
            if (metawidget.getPathPrefix() != null) {
                name = metawidget.getPathPrefix() + name;
            }
            builder.append(name);
            builder.append("\"");
        }
        if ((htmlMetawidgetTag = (BaseHtmlMetawidgetTag)metawidget).getStyle() != null) {
            builder.append(" style=\"");
            builder.append(htmlMetawidgetTag.getStyle());
            builder.append("\"");
        }
        if (htmlMetawidgetTag.getStyleClass() != null) {
            builder.append(" class=\"");
            builder.append(htmlMetawidgetTag.getStyleClass());
            builder.append("\"");
        }
        return builder.toString();
    }

    public static String evaluateAsText(Map<String, String> attributes, MetawidgetTag metawidget) {
        Object evaluated = HtmlWidgetBuilderUtils.evaluate(attributes, metawidget);
        if (evaluated == null) {
            return "";
        }
        if (Boolean.class.isAssignableFrom(evaluated.getClass()) || Boolean.TYPE.isAssignableFrom(evaluated.getClass())) {
            return String.valueOf(evaluated);
        }
        for (Class<?> clazz = evaluated.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
            if (editor == null) continue;
            editor.setValue(evaluated);
            return editor.getAsText();
        }
        return StringUtils.quietValueOf(evaluated);
    }

    public static Object evaluate(Map<String, String> attributes, MetawidgetTag metawidget) {
        if (metawidget.getPathPrefix() == null) {
            return null;
        }
        return HtmlWidgetBuilderUtils.evaluate("${" + metawidget.getPathPrefix() + attributes.get("name") + "}", metawidget);
    }

    public static Object evaluate(String expression, MetawidgetTag metawidget) {
        try {
            PageContext context = metawidget.getPageContext();
            return context.getExpressionEvaluator().evaluate(expression, Object.class, context.getVariableResolver(), null);
        }
        catch (NoSuchMethodError e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private HtmlWidgetBuilderUtils() {
    }
}

