/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.swing.widgetbuilder.CollectionTableModel;
import org.metawidget.swing.widgetbuilder.SwingWidgetBuilderConfig;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingWidgetBuilder
implements WidgetBuilder<JComponent, SwingMetawidget>,
SwingValuePropertyProvider {
    private PropertyStyle mPropertyStyle;

    public SwingWidgetBuilder() {
        this(new SwingWidgetBuilderConfig());
    }

    public SwingWidgetBuilder(SwingWidgetBuilderConfig config) {
        this.mPropertyStyle = config.getPropertyStyle();
    }

    @Override
    public String getValueProperty(Component component) {
        if (component instanceof JComboBox) {
            return "selectedItem";
        }
        if (component instanceof JTextComponent) {
            return "text";
        }
        if (component instanceof JSpinner) {
            return "value";
        }
        if (component instanceof JSlider) {
            return "value";
        }
        if (component instanceof JCheckBox) {
            return "selected";
        }
        return null;
    }

    @Override
    public JComponent buildWidget(String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(elementName)) {
            return new JButton(metawidget.getLabelString(attributes));
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return new JCheckBox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
                comboBox.addItem(null);
            }
            List<String> values = CollectionUtils.fromString(lookup);
            ArrayList convertedValues = CollectionUtils.newArrayList();
            BindingConverter converter = metawidget.getWidgetProcessor(BindingConverter.class);
            for (String value : values) {
                Object convertedValue = converter == null ? value : converter.convertFromString(value, clazz);
                comboBox.addItem(convertedValue);
                convertedValues.add(convertedValue);
            }
            String lookupLabels = attributes.get("lookup-labels");
            if (lookupLabels != null && !"".equals(lookupLabels)) {
                Map<Object, String> labelsMap = CollectionUtils.newHashMap(convertedValues, CollectionUtils.fromString(attributes.get("lookup-labels")));
                comboBox.setEditor(new LookupComboBoxEditor(labelsMap));
                comboBox.setRenderer(new LookupComboBoxRenderer(labelsMap));
            }
            return comboBox;
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                Comparable comparable;
                if (Boolean.TYPE.equals(clazz)) {
                    return new JCheckBox();
                }
                if (Character.TYPE.equals(clazz)) {
                    return new JTextField();
                }
                String minimumValue = attributes.get("minimum-value");
                String maximumValue = attributes.get("maximum-value");
                if (minimumValue != null && !"".equals(minimumValue) && maximumValue != null && !"".equals(maximumValue)) {
                    JSlider slider = new JSlider();
                    slider.setMinimum(Integer.parseInt(minimumValue));
                    slider.setValue(slider.getMinimum());
                    slider.setMaximum(Integer.parseInt(maximumValue));
                    return slider;
                }
                Comparable minimum = minimumValue != null && !"".equals(minimumValue) ? (comparable = (Comparable)ClassUtils.parseNumber(clazz, minimumValue)) : (comparable = (Comparable)ClassUtils.getNumberMinValue(clazz));
                Comparable maximum = maximumValue != null && !"".equals(maximumValue) ? (comparable = (Comparable)ClassUtils.parseNumber(clazz, maximumValue)) : (comparable = (Comparable)ClassUtils.getNumberMaxValue(clazz));
                Number stepSize = attributes.containsKey("maximum-fractional-digits") ? (Number)Math.pow(10.0, -Integer.parseInt(attributes.get("maximum-fractional-digits"))) : (Number)(Float.TYPE.equals(clazz) || Float.class.equals(clazz) ? (Number)Float.valueOf(0.1f) : (Number)(Double.TYPE.equals(clazz) || Double.class.equals(clazz) ? (Number)Float.valueOf(0.1f) : (Number)1));
                Number value = (Number)ClassUtils.parseNumber(clazz, "0");
                if (minimum.compareTo(value) > 0) {
                    value = (Number)((Object)minimum);
                } else if (maximum.compareTo(value) < 0) {
                    value = (Number)((Object)maximum);
                }
                JSpinner spinner = new JSpinner(new SpinnerNumberModel(value, minimum, maximum, stepSize));
                JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
                editor.getTextField().setColumns(0);
                DecimalFormat format = editor.getFormat();
                if (attributes.containsKey("minimum-fractional-digits")) {
                    format.setMinimumFractionDigits(Integer.parseInt(attributes.get("minimum-fractional-digits")));
                }
                if (attributes.containsKey("maximum-fractional-digits")) {
                    format.setMaximumFractionDigits(Integer.parseInt(attributes.get("maximum-fractional-digits")));
                }
                if (attributes.containsKey("minimum-integer-digits")) {
                    format.setMinimumIntegerDigits(Integer.parseInt(attributes.get("minimum-integer-digits")));
                }
                if (attributes.containsKey("maximum-integer-digits")) {
                    format.setMaximumIntegerDigits(Integer.parseInt(attributes.get("maximum-integer-digits")));
                }
                return spinner;
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("masked"))) {
                    return new JPasswordField();
                }
                if ("true".equals(attributes.get("large"))) {
                    JTextArea textarea = new JTextArea();
                    textarea.setLineWrap(true);
                    textarea.setWrapStyleWord(true);
                    textarea.setRows(2);
                    return new JScrollPane(textarea);
                }
                return new JTextField();
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Date.class.equals(clazz)) {
                return new JTextField();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new JTextField();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return this.createTable(attributes, metawidget);
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new JTextField();
        }
        return null;
    }

    protected JComponent createTable(Map<String, String> attributes, SwingMetawidget metawidget) {
        Property property;
        String type;
        Map<String, Property> properties;
        String componentType = attributes.get("parameterized-type");
        String inspectedType = metawidget.inspect(null, componentType, null);
        ArrayList<String> columns = CollectionUtils.newArrayList();
        if (inspectedType != null) {
            Element root = XmlUtils.documentFromString(inspectedType).getDocumentElement();
            NodeList elements = root.getFirstChild().getChildNodes();
            int length = elements.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node node = elements.item(loop);
                columns.add(metawidget.getLabelString(XmlUtils.getAttributesAsMap(node)));
            }
        }
        Collection collection = null;
        if (metawidget.getToInspect() != null && this.mPropertyStyle != null && (properties = this.mPropertyStyle.getProperties(type = metawidget.getToInspect().getClass().getName())) != null && (property = properties.get(attributes.get("name"))) != null) {
            collection = (Collection)property.read(metawidget.getToInspect());
        }
        CollectionTableModel tableModel = new CollectionTableModel(collection, columns);
        return new JScrollPane(new JTable(tableModel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxRenderer
    extends BasicComboBoxRenderer {
        private Map<Object, String> mLookups;

        public LookupComboBoxRenderer(Map<Object, String> lookups) {
            if (lookups == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = lookups;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            String lookup = this.mLookups.get(value);
            if (lookup != null) {
                ((JLabel)component).setText(lookup);
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupComboBoxEditor
    extends BasicComboBoxEditor {
        private Map<Object, String> mLookups;

        public LookupComboBoxEditor(Map<Object, String> lookups) {
            if (lookups == null) {
                throw new NullPointerException("lookups");
            }
            this.mLookups = lookups;
        }

        @Override
        public void setItem(Object item) {
            super.setItem(this.mLookups.get(item));
        }
    }
}

