/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

import java.util.Comparator;

public final class StringUtils {
    public static final char SEPARATOR_FORWARD_SLASH_CHAR = '/';
    public static final String SEPARATOR_FORWARD_SLASH = String.valueOf('/');
    public static final char SEPARATOR_DOT_CHAR = '.';
    public static final String SEPARATOR_DOT = String.valueOf('.');
    public static final char SEPARATOR_COMMA_CHAR = ',';
    public static final String SEPARATOR_COMMA = String.valueOf(',');
    public static final char SEPARATOR_COLON_CHAR = ':';
    public static final String SEPARATOR_COLON = String.valueOf(':');
    public static final String RESOURCE_KEY_NOT_FOUND_PREFIX = "???";
    public static final String RESOURCE_KEY_NOT_FOUND_SUFFIX = "???";
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String lhs, String rhs) {
            int compareTo = lhs.compareToIgnoreCase(rhs);
            if (compareTo == 0) {
                compareTo = lhs.compareTo(rhs);
            }
            return compareTo;
        }
    };

    public static String decapitalize(String in) {
        if (in.length() == 0) {
            return in;
        }
        char firstChar = in.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return in;
        }
        if (in.length() > 1 && Character.isUpperCase(in.charAt(1))) {
            return in;
        }
        return Character.toLowerCase(firstChar) + in.substring(1);
    }

    public static String capitalize(String in) {
        if (in.length() == 0) {
            return in;
        }
        if (in.length() > 1 && Character.isUpperCase(in.charAt(1))) {
            return in;
        }
        return Character.toUpperCase(in.charAt(0)) + in.substring(1);
    }

    public static String uncamelCase(String camelCase) {
        return StringUtils.uncamelCase(camelCase, ' ');
    }

    public static String uncamelCase(String camelCase, char separator) {
        if (camelCase == null) {
            return null;
        }
        int length = camelCase.length();
        StringBuilder builder = new StringBuilder(length);
        boolean first = true;
        char lastChar = separator;
        char[] chars = camelCase.toCharArray();
        for (int loop = 0; loop < length; ++loop) {
            char c = chars[loop];
            if (first) {
                builder.append(Character.toUpperCase(c));
                first = false;
            } else if (Character.isUpperCase(c) && (!Character.isUpperCase(lastChar) || loop < chars.length - 1 && chars[loop + 1] != separator && !Character.isUpperCase(chars[loop + 1]))) {
                if (lastChar != separator) {
                    builder.append(separator);
                }
                builder.append(c);
            } else if (Character.isDigit(c) && Character.isLetter(lastChar) && lastChar != separator) {
                builder.append(separator);
                builder.append(c);
            } else {
                builder.append(c);
            }
            lastChar = c;
        }
        return builder.toString();
    }

    public static String camelCase(String text) {
        return StringUtils.camelCase(text, ' ');
    }

    public static String camelCase(String text, char separator) {
        StringBuilder builder = new StringBuilder(text.length());
        boolean lastWasSeparator = false;
        for (char c : StringUtils.decapitalize(text).toCharArray()) {
            if (c == separator) {
                lastWasSeparator = true;
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            if (lastWasSeparator) {
                builder.append(Character.toUpperCase(c));
                lastWasSeparator = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String quietValueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String substringBefore(String text, String before) {
        int indexOf = text.indexOf(before);
        if (indexOf == -1) {
            return text;
        }
        return text.substring(0, indexOf);
    }

    public static String substringAfter(String text, String after) {
        int indexOf = text.indexOf(after);
        if (indexOf == -1) {
            return text;
        }
        return text.substring(indexOf + after.length());
    }

    public static String substringAfterLast(String text, char after) {
        int indexOf = text.lastIndexOf(after);
        if (indexOf == -1) {
            return text;
        }
        return text.substring(indexOf + 1);
    }

    public static String substringAfterLast(String text, String after) {
        int indexOf = text.lastIndexOf(after);
        if (indexOf == -1) {
            return text;
        }
        return text.substring(indexOf + after.length());
    }

    private StringUtils() {
    }
}

