/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.faces;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.inspectionresultprocessor.faces.FacesInspectionResultProcessorConfig;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesInspectionResultProcessor
extends BaseInspectionResultProcessor<UIMetawidget> {
    private static final String UNDERSCORE_THIS_ATTRIBUTE = "_this";
    private PropertyStyle mInjectThis;
    private String[] mIgnoreAttributes;

    public FacesInspectionResultProcessor() {
        this(new FacesInspectionResultProcessorConfig());
    }

    public FacesInspectionResultProcessor(FacesInspectionResultProcessorConfig config) {
        this.mInjectThis = config.getInjectThis();
        this.mIgnoreAttributes = config.getIgnoreAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEntity(Map<String, String> attributes, UIMetawidget metawidget, Object toInspect, String type, String ... names) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw InspectionResultProcessorException.newException("FacesContext not available to FacesInspectionResultProcessor");
        }
        Map requestMap = null;
        try {
            if (this.mInjectThis != null) {
                requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(UNDERSCORE_THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, true, names).getValue());
            }
            super.processEntity(attributes, metawidget, toInspect, type, names);
        }
        finally {
            if (requestMap != null) {
                requestMap.remove(UNDERSCORE_THIS_ATTRIBUTE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processTraits(Element entity, UIMetawidget metawidget, Object toInspect, String type, String ... names) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw InspectionResultProcessorException.newException("FacesContext not available to FacesInspectionResultProcessor");
        }
        Map requestMap = null;
        try {
            if (this.mInjectThis != null) {
                requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(UNDERSCORE_THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, false, names).getValue());
            }
            super.processTraits(entity, metawidget, toInspect, type, names);
        }
        finally {
            if (requestMap != null) {
                requestMap.remove(UNDERSCORE_THIS_ATTRIBUTE);
            }
        }
    }

    @Override
    protected void processAttributes(Map<String, String> attributes, UIMetawidget metawidget) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (ArrayUtils.contains(this.mIgnoreAttributes, key)) {
                String unwrappedExpression;
                if (this.mInjectThis == null || !(unwrappedExpression = FacesUtils.unwrapExpression(value)).startsWith(UNDERSCORE_THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) continue;
                throw InspectionResultProcessorException.newException("Expression '" + value + "' (for '" + key + "') must not contain '" + UNDERSCORE_THIS_ATTRIBUTE + "' (see Metawidget Reference Guide)");
            }
            Matcher matcher = FacesUtils.matchExpression(value);
            int matchOffset = 0;
            while (matcher.find()) {
                String expression = matcher.group(0);
                if (this.mInjectThis == null && matcher.group(2).startsWith(UNDERSCORE_THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) {
                    throw InspectionResultProcessorException.newException("Expression for '" + value + "' contains '" + UNDERSCORE_THIS_ATTRIBUTE + "', but " + FacesInspectionResultProcessorConfig.class.getSimpleName() + ".setInjectThis is null");
                }
                try {
                    String valueObjectAsString;
                    FacesContext context = FacesContext.getCurrentInstance();
                    Object valueObject = context.getApplication().createValueBinding(expression).getValue(context);
                    if (valueObject == null) {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = null;
                            break;
                        }
                        valueObjectAsString = "";
                    } else {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            if (valueObject instanceof Collection) {
                                value = CollectionUtils.toString((Collection)valueObject);
                                break;
                            }
                            if (valueObject.getClass().isArray()) {
                                value = ArrayUtils.toString(valueObject);
                                break;
                            }
                            value = String.valueOf(valueObject);
                            break;
                        }
                        valueObjectAsString = String.valueOf(valueObject);
                    }
                    value = new StringBuilder(value).replace(matcher.start() + matchOffset, matcher.end() + matchOffset, valueObjectAsString).toString();
                    matchOffset += valueObjectAsString.length() - (matcher.end() - matcher.start());
                }
                catch (Exception e) {
                    throw InspectionResultProcessorException.newException("Unable to evaluate " + value, e);
                }
            }
            attributes.put(key, value);
        }
    }
}

