/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.reflection;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget> {
    @Override
    public void onStartBuild(SwingMetawidget metawidget) {
        metawidget.putClientProperty(ReflectionBindingProcessor.class, null);
    }

    @Override
    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        if (component instanceof SwingMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)component);
            return component;
        }
        if (!"action".equals(elementName)) {
            return component;
        }
        if (component instanceof Stub) {
            return component;
        }
        if (!(component instanceof AbstractButton)) {
            throw WidgetProcessorException.newException("ReflectionBindingProcessor only supports binding actions to AbstractButtons");
        }
        if (WidgetBuilderUtils.isReadOnly(attributes)) {
            return component;
        }
        AbstractButton button = (AbstractButton)component;
        BoundAction action = new BoundAction(button.getText(), metawidget.getToInspect(), metawidget.getPath(), attributes.get("name"));
        button.setAction(action);
        State state = this.getState(metawidget);
        if (state.actions == null) {
            state.actions = CollectionUtils.newHashSet();
        }
        state.actions.add(action);
        return button;
    }

    @Override
    public void onEndBuild(SwingMetawidget metawidget) {
    }

    public void rebind(Object toRebind, SwingMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.actions != null) {
            for (BoundAction action : state.actions) {
                action.rebind(toRebind);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, nestedMetawidget);
            }
        }
    }

    private State getState(SwingMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(ReflectionBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(ReflectionBindingProcessor.class, state);
        }
        return state;
    }

    static class BoundAction
    extends AbstractAction {
        private Object mBindTo;
        private String[] mNames;
        private Method mAction;

        public BoundAction(String actionName, Object bindTo, String path, String name) {
            super(actionName);
            this.mBindTo = bindTo;
            if (path == null) {
                return;
            }
            this.mNames = PathUtils.parsePath(path).getNamesAsArray();
            Object traverse = this.mBindTo;
            for (String subName : this.mNames) {
                if (traverse == null) {
                    return;
                }
                traverse = ClassUtils.getProperty(traverse, subName);
            }
            try {
                this.mAction = traverse.getClass().getMethod(name, null);
            }
            catch (NoSuchMethodException e1) {
                try {
                    this.mAction = traverse.getClass().getMethod(name, ActionEvent.class);
                }
                catch (NoSuchMethodException e2) {
                    throw WidgetProcessorException.newException(e2);
                }
            }
        }

        public void rebind(Object toRebind) {
            this.mBindTo = toRebind;
        }

        public void actionPerformed(ActionEvent event) {
            String actionName = (String)this.getValue("Name");
            Object traverse = this.mBindTo;
            for (String name : this.mNames) {
                if (traverse == null) {
                    return;
                }
                traverse = ClassUtils.getProperty(traverse, name);
            }
            try {
                if (this.mAction.getParameterTypes().length == 0) {
                    this.mAction.invoke(traverse, (Object[])null);
                } else {
                    this.mAction.invoke(traverse, new ActionEvent(this.mBindTo, 0, actionName));
                }
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException(e);
            }
        }
    }

    static class State {
        Set<BoundAction> actions;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

