/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Panel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.vaadin.ui.Facet;
import org.metawidget.vaadin.ui.Stub;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

public class VaadinMetawidget
extends CustomComponent
implements ComponentContainer {
    private Object mToInspect;
    private String mPath;
    private ResourceBundle mBundle;
    private boolean mNeedToBuildWidgets;
    private Element mLastInspection;
    private boolean mIgnoreAddRemove;
    private List<Component> mComponents = CollectionUtils.newArrayList();
    private List<AbstractComponent> mExistingComponents = CollectionUtils.newArrayList();
    private List<AbstractComponent> mExistingUnusedComponents;
    private Map<Object, Facet> mFacets = CollectionUtils.newHashMap();
    private Map<Object, Object> mClientProperties;
    Pipeline mPipeline = this.newPipeline();

    public void setToInspect(Object toInspect) {
        this.updateToInspectWithoutInvalidate(toInspect);
        this.invalidateInspection();
    }

    public <T> T getToInspect() {
        return (T)this.mToInspect;
    }

    public void setPath(String path) {
        this.mPath = path;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(String config) {
        this.mPipeline.setConfig(config);
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public String inspect(Object toInspect, String type, String ... names) {
        return this.mPipeline.inspect(toInspect, type, names);
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<VaadinMetawidget> inspectionResultProcessor) {
        this.mPipeline.addInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<VaadinMetawidget> inspectionResultProcessor) {
        this.mPipeline.removeInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateInspection();
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<VaadinMetawidget> ... inspectionResultProcessors) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessors);
        this.invalidateInspection();
    }

    public void setWidgetBuilder(WidgetBuilder<Component, VaadinMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public void addWidgetProcessor(WidgetProcessor<Component, VaadinMetawidget> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void removeWidgetProcessor(WidgetProcessor<Component, VaadinMetawidget> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<Component, VaadinMetawidget> ... widgetProcessors) {
        this.mPipeline.setWidgetProcessors(widgetProcessors);
        this.invalidateWidgets();
    }

    public <T> T getWidgetProcessor(Class<T> widgetProcessorClass) {
        this.buildWidgets();
        return this.mPipeline.getWidgetProcessor(widgetProcessorClass);
    }

    public void setLayout(Layout<Component, ComponentContainer, VaadinMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public ResourceBundle getBundle() {
        return this.mBundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.mBundle = bundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        String label = attributes.get("label");
        if (label != null) {
            if ("".equals(label)) {
                return null;
            }
            String localized = this.getLocalizedKey(StringUtils.camelCase(label));
            if (localized != null) {
                return localized.trim();
            }
            return label.trim();
        }
        String name = attributes.get("name");
        if (name != null) {
            String localized = this.getLocalizedKey(name);
            if (localized != null) {
                return localized.trim();
            }
            return StringUtils.uncamelCase(name);
        }
        return "";
    }

    public String getLocalizedKey(String key) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            return this.mBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        if (this.mPipeline.isReadOnly() == readOnly) {
            return;
        }
        this.mPipeline.setReadOnly(readOnly);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int maximumInspectionDepth) {
        this.mPipeline.setMaximumInspectionDepth(maximumInspectionDepth);
        this.invalidateWidgets();
    }

    public List<AbstractComponent> fetchExistingUnusedComponents() {
        return this.mExistingUnusedComponents;
    }

    public int getComponentCount() {
        this.buildWidgets();
        return this.mComponents.size();
    }

    public Iterator<Component> iterator() {
        this.buildWidgets();
        return this.mComponents.iterator();
    }

    public <T extends Component> T getComponent(String ... names) {
        if (names == null || names.length == 0) {
            return null;
        }
        VaadinMetawidget topComponent = this;
        int length = names.length;
        for (int loop = 0; loop < length; ++loop) {
            String name = names[loop];
            if (topComponent instanceof VaadinMetawidget) {
                topComponent.buildWidgets();
            }
            topComponent = topComponent instanceof HasComponents ? this.getComponent((HasComponents)topComponent, name) : null;
            if (loop == length - 1) {
                return (T)((Object)topComponent);
            }
            if (topComponent != null) continue;
            throw MetawidgetException.newException("No such component '" + name + "' of '" + ArrayUtils.toString(names, "', '") + "'");
        }
        return (T)((Object)topComponent);
    }

    public Facet getFacet(String name) {
        this.buildWidgets();
        return this.mFacets.get(name);
    }

    public <C extends Component> C getContent() {
        this.buildWidgets();
        if (this.mComponents.isEmpty()) {
            return null;
        }
        return (C)this.mComponents.get(0);
    }

    public void addComponent(Component component) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (component instanceof Facet) {
                this.mFacets.put(abstractComponent.getData(), (Facet)component);
                return;
            }
            this.mExistingComponents.add(abstractComponent);
        } else {
            this.mComponents.clear();
            this.mComponents.add(component);
            component.setParent((ClientConnector)this);
        }
    }

    public void removeComponent(Component component) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getData());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    public void putClientProperty(Object key, Object value) {
        if (this.mClientProperties == null) {
            this.mClientProperties = new HashMap<Object, Object>();
        }
        this.mClientProperties.put(key, value);
    }

    public <T> T getClientProperty(Object key) {
        if (this.mClientProperties == null) {
            return null;
        }
        return (T)this.mClientProperties.get(key);
    }

    public void removeComponentDetachListener(HasComponents.ComponentDetachListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addComponents(Component ... components) {
        for (Component component : components) {
            this.addComponent(component);
        }
    }

    public void removeAllComponents() {
        this.mComponents.clear();
    }

    @Deprecated
    public Iterator<Component> getComponentIterator() {
        return this.iterator();
    }

    @Deprecated
    public void addListener(HasComponents.ComponentAttachListener listener) {
        this.addComponentAttachListener(listener);
    }

    @Deprecated
    public void removeListener(HasComponents.ComponentAttachListener listener) {
        this.removeComponentAttachListener(listener);
    }

    @Deprecated
    public void addListener(HasComponents.ComponentDetachListener listener) {
        this.addComponentDetachListener(listener);
    }

    @Deprecated
    public void removeListener(HasComponents.ComponentDetachListener listener) {
        this.removeComponentDetachListener(listener);
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    protected String getDefaultConfiguration() {
        return ClassUtils.getPackagesAsFolderNames(VaadinMetawidget.class) + "/metawidget-vaadin-default.xml";
    }

    protected void invalidateInspection() {
        this.mLastInspection = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        this.mNeedToBuildWidgets = true;
        if (this.mClientProperties != null) {
            this.mClientProperties.clear();
        }
        this.markAsDirty();
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets) {
            return;
        }
        this.mPipeline.configureOnce();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspection == null) {
                this.mLastInspection = this.inspect();
            }
            if (this.mPath != null) {
                this.mPipeline.buildWidgets(this.mLastInspection);
            }
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        this.mExistingUnusedComponents = CollectionUtils.newArrayList(this.mExistingComponents);
    }

    protected void layoutWidget(Component component, String elementName, Map<String, String> attributes) {
        ((AbstractComponent)component).setData((Object)attributes.get("name"));
        this.removeComponent(component);
        Map<String, String> additionalAttributes = this.mPipeline.getAdditionalAttributes(component);
        if (additionalAttributes != null) {
            attributes.putAll(additionalAttributes);
        }
    }

    protected void endBuild() {
        if (this.mExistingUnusedComponents != null) {
            for (Component component : this.mExistingUnusedComponents) {
                if (component instanceof Facet) continue;
                HashMap<String, String> attributes = CollectionUtils.newHashMap();
                attributes.put("section", "");
                this.mPipeline.layoutWidget(component, "property", (Map<String, String>)attributes);
            }
        }
    }

    protected void initNestedMetawidget(VaadinMetawidget nestedMetawidget, Map<String, String> attributes) {
        this.mPipeline.initNestedPipeline(nestedMetawidget.mPipeline, attributes);
        nestedMetawidget.setPath(this.mPath + '/' + attributes.get("name"));
        nestedMetawidget.setBundle(this.mBundle);
        nestedMetawidget.setToInspect(this.mToInspect);
    }

    private void updateToInspectWithoutInvalidate(Object toInspect) {
        if (this.mToInspect == null) {
            if (this.mPath == null && toInspect != null) {
                this.mPath = toInspect.getClass().getName();
            }
        } else if (this.mToInspect.getClass().getName().equals(this.mPath)) {
            this.mPath = toInspect == null ? null : toInspect.getClass().getName();
        }
        this.mToInspect = toInspect;
    }

    private Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath);
        return (Element)this.mPipeline.inspectAsDom(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    private Component getComponent(HasComponents container, String name) {
        for (AbstractComponent childComponent : container) {
            if (!(childComponent.getData() == null && childComponent instanceof Panel ? (childComponent = (AbstractComponent)this.getComponent((HasComponents)((Panel)childComponent).getContent(), name)) != null : (childComponent.getData() == null && childComponent instanceof HasComponents ? (childComponent = (AbstractComponent)this.getComponent((HasComponents)childComponent, name)) != null : name.equals(childComponent.getData())))) continue;
            return childComponent;
        }
        return null;
    }

    public void addComponentAttachListener(HasComponents.ComponentAttachListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeComponentAttachListener(HasComponents.ComponentAttachListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addComponentDetachListener(HasComponents.ComponentDetachListener listener) {
        throw new UnsupportedOperationException();
    }

    public void replaceComponent(Component oldComponent, Component newComponent) {
        throw new UnsupportedOperationException();
    }

    public void moveComponentsFrom(ComponentContainer source) {
        throw new UnsupportedOperationException();
    }

    protected class Pipeline
    extends W3CPipeline<Component, ComponentContainer, VaadinMetawidget>
    implements Serializable {
        protected Pipeline() {
        }

        @Override
        protected VaadinMetawidget getPipelineOwner() {
            return VaadinMetawidget.this;
        }

        @Override
        protected String getDefaultConfiguration() {
            return VaadinMetawidget.this.getDefaultConfiguration();
        }

        @Override
        protected void startBuild() {
            VaadinMetawidget.this.startBuild();
            super.startBuild();
        }

        @Override
        protected void layoutWidget(Component component, String elementName, Map<String, String> attributes) {
            VaadinMetawidget.this.layoutWidget(component, elementName, attributes);
            super.layoutWidget(component, elementName, attributes);
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(Component component) {
            if (component instanceof Stub) {
                return ((Stub)component).getAttributes();
            }
            return null;
        }

        @Override
        public VaadinMetawidget buildNestedMetawidget(Map<String, String> attributes) throws Exception {
            if ("true".equals(attributes.get("hidden"))) {
                return null;
            }
            VaadinMetawidget nestedMetawidget = (VaadinMetawidget)((Object)((Object)((Object)VaadinMetawidget.this)).getClass().newInstance());
            VaadinMetawidget.this.initNestedMetawidget(nestedMetawidget, attributes);
            return nestedMetawidget;
        }

        @Override
        protected void endBuild() {
            VaadinMetawidget.this.endBuild();
            super.endBuild();
        }
    }
}

