/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import java.util.Map;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlInspector
implements DomInspector<Element> {
    protected LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    private Element mRoot;
    private final PropertyStyle mRestrictAgainstObject;
    private final boolean mInferInheritanceHierarchy;

    protected BaseXmlInspector(BaseXmlInspectorConfig config) {
        try {
            InputStream[] inputStreams = config.getInputStreams();
            if (inputStreams != null && inputStreams.length > 0) {
                this.mRoot = this.getDocumentElement(config.getResourceResolver(), config.getInputStreams());
            } else {
                Document[] documents = config.getDocuments();
                if (documents != null && documents.length > 0) {
                    this.mRoot = this.getDocumentElement(documents);
                }
            }
            if (this.mRoot == null) {
                throw InspectorException.newException("No XML input file specified");
            }
            if (this.mLog.isTraceEnabled()) {
                this.mLog.trace(XmlUtils.documentToString(this.mRoot.getOwnerDocument(), false), new Object[0]);
            }
            this.mRestrictAgainstObject = config.getRestrictAgainstObject();
            this.mInferInheritanceHierarchy = config.isInferInheritanceHierarchy();
            if (this.mRestrictAgainstObject != null && this.mInferInheritanceHierarchy) {
                throw InspectorException.newException("When using restrictAgainstObject, inferInheritanceHierarchy is implied");
            }
            PropertyStyle validateAgainstClasses = config.getValidateAgainstClasses();
            if (validateAgainstClasses != null) {
                String topLevelTypeAttribute = this.getTopLevelTypeAttribute();
                String extendsAttribute = this.getExtendsAttribute();
                String nameAttribute = this.getNameAttribute();
                String typeAttribute = this.getTypeAttribute();
                Element entity = XmlUtils.getChildWithAttribute(this.mRoot, topLevelTypeAttribute);
                while (entity != null) {
                    String topLevelType = entity.getAttribute(topLevelTypeAttribute);
                    Class<?> actualClass = ClassUtils.niceForName(topLevelType);
                    if (actualClass != null) {
                        String extendz = entity.getAttribute(extendsAttribute);
                        Class<?> actualSuperclass = actualClass.getSuperclass();
                        if (!"".equals(extendz) && !extendz.equals(actualSuperclass.getName())) {
                            throw InspectorException.newException(actualClass + " extends " + actualSuperclass + ", not '" + extendz + "'");
                        }
                        Map<String, Property> actualProperties = validateAgainstClasses.getProperties(topLevelType);
                        Element property = XmlUtils.getChildWithAttribute(entity, nameAttribute);
                        while (property != null) {
                            String propertyName = property.getAttribute(nameAttribute);
                            Property actualProperty = actualProperties.get(propertyName);
                            if (actualProperty == null) {
                                throw InspectorException.newException(actualClass + " does not define a property '" + propertyName + "'");
                            }
                            String propertyType = property.getAttribute(typeAttribute);
                            String actualType = actualProperty.getType();
                            if (!"".equals(propertyType) && !propertyType.equals(actualType)) {
                                throw InspectorException.newException(actualClass + " defines property '" + propertyName + "' to be " + actualType + ", not '" + propertyType + "'");
                            }
                            property = XmlUtils.getSiblingWithAttribute(property, nameAttribute);
                        }
                    }
                    entity = XmlUtils.getSiblingWithAttribute(entity, topLevelTypeAttribute);
                }
            }
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    @Override
    public final String inspect(Object toInspect, String type, String ... names) {
        Element element = this.inspectAsDom(toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element inspectAsDom(Object toInspect, String type, String ... names) {
        if (type == null) {
            return null;
        }
        try {
            Element entity;
            Document document;
            ValueAndDeclaredType valueAndDeclaredType;
            Map<String, String> parentAttributes = null;
            Element element = this.mRoot;
            synchronized (element) {
                Element propertyInParent;
                if (names != null && names.length > 0 && (propertyInParent = (Element)this.traverse(toInspect, type, true, names).getValue()) != null) {
                    parentAttributes = this.inspectProperty(propertyInParent);
                }
                if ((valueAndDeclaredType = this.traverse(toInspect, type, false, names)).getValue() == null) {
                    if (parentAttributes == null || parentAttributes.isEmpty()) {
                        return null;
                    }
                    document = XmlUtils.newDocument();
                    entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                } else {
                    document = XmlUtils.newDocument();
                    entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                    this.inspectTraits((Element)valueAndDeclaredType.getValue(), entity);
                    if (!entity.hasChildNodes() && entity.getAttributes().getLength() == 0 && parentAttributes == null) {
                        return null;
                    }
                }
            }
            Element root = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            root.setAttribute("version", "1.0");
            document.appendChild(root);
            root.appendChild(entity);
            XmlUtils.setMapAsAttributes(entity, parentAttributes);
            if (valueAndDeclaredType.getDeclaredType() != null) {
                entity.setAttribute("type", valueAndDeclaredType.getDeclaredType());
            }
            return root;
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    protected Element getDocumentElement(ResourceResolver resolver, InputStream ... files) throws Exception {
        int length = files.length;
        Document[] documents = new Document[length];
        for (int loop = 0; loop < length; ++loop) {
            documents[loop] = XmlUtils.parse(files[loop]);
        }
        return this.getDocumentElement(documents);
    }

    protected Element getDocumentElement(Document ... documents) throws Exception {
        Document documentMaster = null;
        for (Document document : documents) {
            if (!document.hasChildNodes()) continue;
            this.preprocessDocument(document);
            if (documentMaster == null || !documentMaster.hasChildNodes()) {
                documentMaster = document;
                continue;
            }
            XmlUtils.combineElements(documentMaster.getDocumentElement(), document.getDocumentElement(), this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
    }

    protected void inspectTraits(Element toInspect, Element toAddTo) {
        if (toInspect == null) {
            return;
        }
        Document document = toAddTo.getOwnerDocument();
        String extendsAttribute = this.getExtendsAttribute();
        if (extendsAttribute != null && toInspect.hasAttribute(extendsAttribute)) {
            this.inspectTraits((Element)this.traverse(null, toInspect.getAttribute(extendsAttribute), false, new String[0]).getValue(), toAddTo);
        }
        Element element = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        this.inspectTraitSiblings(element, XmlUtils.getFirstChildElement(toInspect));
        XmlUtils.combineElements(toAddTo, element, "name", "name");
    }

    protected void inspectTraitSiblings(Element toAddTo, Element toInspect) {
        Element toInspectToUse = toInspect;
        while (toInspectToUse != null) {
            Element inspectedTrait = this.inspectTrait(toAddTo.getOwnerDocument(), toInspectToUse);
            if (inspectedTrait != null) {
                toAddTo.appendChild(inspectedTrait);
            }
            toInspectToUse = XmlUtils.getNextSiblingElement(toInspectToUse);
        }
    }

    protected Element inspectTrait(Document toAddTo, Element toInspect) {
        Map<String, String> propertyAttributes = this.inspectProperty(toInspect);
        if (propertyAttributes != null && !propertyAttributes.isEmpty()) {
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "property");
            XmlUtils.setMapAsAttributes(child, propertyAttributes);
            return child;
        }
        Map<String, String> actionAttributes = this.inspectAction(toInspect);
        if (actionAttributes != null && !actionAttributes.isEmpty()) {
            if (propertyAttributes != null) {
                throw InspectorException.newException("Ambigious match: " + toInspect.getNodeName() + " matches as both a property and an action");
            }
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "action");
            XmlUtils.setMapAsAttributes(child, actionAttributes);
            return child;
        }
        return null;
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        return null;
    }

    protected Map<String, String> inspectAction(Element toInspect) {
        return null;
    }

    protected ValueAndDeclaredType traverse(Object toTraverse, String type, boolean onlyToParent, String ... names) {
        String topLevelTypeAttribute;
        Element topLevelElement;
        String typeToInspect = type;
        Object namesToInspect = names;
        Object traverseAgainstObject = null;
        String declaredType = null;
        if (toTraverse != null && this.mRestrictAgainstObject != null) {
            ValueAndDeclaredType valueAndDeclaredType = this.mRestrictAgainstObject.traverse(toTraverse, typeToInspect, onlyToParent, (String)namesToInspect);
            traverseAgainstObject = valueAndDeclaredType.getValue();
            if (valueAndDeclaredType.getDeclaredType() != null) {
                declaredType = valueAndDeclaredType.getDeclaredType();
            }
            if (traverseAgainstObject == null) {
                return new ValueAndDeclaredType(null, declaredType);
            }
            namesToInspect = onlyToParent ? new String[]{namesToInspect[((String[])namesToInspect).length - 1]} : null;
            typeToInspect = traverseAgainstObject.getClass().getName();
        }
        if (declaredType == null) {
            declaredType = typeToInspect;
        }
        if ((topLevelElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute = this.getTopLevelTypeAttribute(), typeToInspect)) == null) {
            Class<?> actualClass;
            if (traverseAgainstObject == null && !this.mInferInheritanceHierarchy) {
                return new ValueAndDeclaredType(null, declaredType);
            }
            if (traverseAgainstObject != null) {
                actualClass = traverseAgainstObject.getClass();
            } else {
                actualClass = ClassUtils.niceForName(typeToInspect);
                if (actualClass == null) {
                    return new ValueAndDeclaredType(null, typeToInspect);
                }
            }
            while (topLevelElement == null && (actualClass = actualClass.getSuperclass()) != null) {
                topLevelElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, actualClass.getName());
            }
            if (topLevelElement == null) {
                return new ValueAndDeclaredType(null, declaredType);
            }
        }
        Element elementWithNamedChildren = this.traverseFromTopLevelTypeToNamedChildren(topLevelElement);
        if (namesToInspect == null || elementWithNamedChildren == null) {
            return new ValueAndDeclaredType(elementWithNamedChildren, declaredType);
        }
        int length = ((String[])namesToInspect).length;
        if (length == 0) {
            return new ValueAndDeclaredType(elementWithNamedChildren, declaredType);
        }
        String extendsAttribute = this.getExtendsAttribute();
        String nameAttribute = this.getNameAttribute();
        String typeAttribute = this.getTypeAttribute();
        String referenceAttribute = this.getReferenceAttribute();
        for (int loop = 0; loop < length; ++loop) {
            String name = namesToInspect[loop];
            declaredType = null;
            Element property = XmlUtils.getChildWithAttributeValue(elementWithNamedChildren, nameAttribute, name);
            if (property == null && extendsAttribute != null) {
                String childExtends;
                while (elementWithNamedChildren.hasAttribute(extendsAttribute) && (elementWithNamedChildren = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, childExtends = elementWithNamedChildren.getAttribute(extendsAttribute))) != null && (property = XmlUtils.getChildWithAttributeValue(elementWithNamedChildren, nameAttribute, name)) == null) {
                }
            }
            if (property == null && referenceAttribute != null) {
                property = XmlUtils.getChildWithAttributeValue(elementWithNamedChildren, referenceAttribute, name);
                if (property == null) {
                    return new ValueAndDeclaredType(null, null);
                }
                declaredType = name;
            }
            if (property == null) {
                return new ValueAndDeclaredType(null, null);
            }
            if (onlyToParent && loop >= length - 1) {
                return new ValueAndDeclaredType(property, declaredType);
            }
            if (declaredType == null) {
                if (property.hasAttribute(typeAttribute)) {
                    declaredType = property.getAttribute(typeAttribute);
                }
                if (XmlUtils.getChildWithAttribute(elementWithNamedChildren = this.traverseFromTopLevelTypeToNamedChildren(property), nameAttribute) != null) continue;
                if (!property.hasAttribute(typeAttribute)) {
                    if (referenceAttribute != null && XmlUtils.getChildWithAttribute(elementWithNamedChildren, referenceAttribute) != null) continue;
                    throw InspectorException.newException("Property " + name + " in entity " + topLevelElement.getAttribute(typeAttribute) + " has no @" + typeAttribute + " attribute in the XML, so cannot navigate to " + type + ArrayUtils.toString(namesToInspect, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                }
            }
            if ((topLevelElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, declaredType)) == null) {
                return new ValueAndDeclaredType(null, declaredType);
            }
            if (topLevelElement.hasAttribute(typeAttribute)) {
                declaredType = topLevelElement.getAttribute(typeAttribute);
            }
            if ((elementWithNamedChildren = this.traverseFromTopLevelTypeToNamedChildren(topLevelElement)) != null) continue;
            return new ValueAndDeclaredType(null, declaredType);
        }
        return new ValueAndDeclaredType(elementWithNamedChildren, declaredType);
    }

    protected String getTopLevelTypeAttribute() {
        return "type";
    }

    protected String getNameAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "type";
    }

    protected String getExtendsAttribute() {
        return null;
    }

    protected String getReferenceAttribute() {
        return null;
    }

    protected Element traverseFromTopLevelTypeToNamedChildren(Element topLevel) {
        return topLevel;
    }
}

