/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetbuilder.primefaces;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.component.html.widgetbuilder.HtmlWidgetBuilder;
import org.metawidget.faces.component.html.widgetbuilder.primefaces.PrimeFacesWidgetBuilderConfig;
import org.metawidget.util.WidgetBuilderUtils;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.column.Column;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.inputtext.InputText;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.component.slider.Slider;
import org.primefaces.component.spinner.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeFacesWidgetBuilder
extends HtmlWidgetBuilder {
    private String mDataTableStyleClass;
    private String mDataTableRowStyleClass;
    private String mDataTableTableStyleClass;
    private int mMaximumColumnsInDataTable;

    public PrimeFacesWidgetBuilder() {
        this(new PrimeFacesWidgetBuilderConfig());
    }

    public PrimeFacesWidgetBuilder(PrimeFacesWidgetBuilderConfig config) {
        this.mDataTableStyleClass = config.getDataTableStyleClass();
        this.mDataTableRowStyleClass = config.getDataTableRowStyleClass();
        this.mDataTableTableStyleClass = config.getDataTableTableStyleClass();
        this.mMaximumColumnsInDataTable = config.getMaximumColumnsInDataTable();
    }

    @Override
    public UIComponent buildWidget(String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if ("action".equals(elementName)) {
            CommandButton button = (CommandButton)application.createComponent("org.primefaces.component.CommandButton");
            button.setValue((Object)metawidget.getLabelString(attributes));
            button.setAjax(false);
            return button;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        boolean readOnly = WidgetBuilderUtils.isReadOnly(attributes);
        if (!readOnly) {
            String facesLookup = attributes.get("faces-lookup");
            if (facesLookup != null && !"".equals(facesLookup)) {
                Object component = clazz != null && (List.class.isAssignableFrom(clazz) || clazz.isArray()) ? FacesUtils.createComponent("org.primefaces.component.SelectManyCheckbox", "org.primefaces.component.SelectManyCheckboxRenderer") : FacesUtils.createComponent("org.primefaces.component.SelectOneMenu", "org.primefaces.component.SelectOneMenuRenderer");
                this.initFacesSelect((UIComponent)component, facesLookup, attributes, metawidget);
                return component;
            }
            if (clazz != null) {
                if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
                    return application.createComponent("org.primefaces.component.SelectBooleanCheckbox");
                }
                String lookup = attributes.get("lookup");
                if (lookup != null && !"".equals(lookup)) {
                    Object component = List.class.isAssignableFrom(clazz) || clazz.isArray() ? FacesUtils.createComponent("org.primefaces.component.SelectManyCheckbox", "org.primefaces.component.SelectManyCheckboxRenderer") : FacesUtils.createComponent("org.primefaces.component.SelectOneMenu", "org.primefaces.component.SelectOneMenuRenderer");
                    this.initStaticSelect((UIComponent)component, lookup, clazz, attributes, metawidget);
                    return component;
                }
                if (Character.TYPE.equals(clazz) || Character.class.isAssignableFrom(clazz)) {
                    InputText inputText = (InputText)application.createComponent("org.primefaces.component.InputText");
                    inputText.setMaxlength(1);
                    return inputText;
                }
                if (Number.class.isAssignableFrom(clazz)) {
                    UIComponent ranged = this.createRanged(attributes);
                    if (ranged != null) {
                        return ranged;
                    }
                    InputText inputText = (InputText)application.createComponent("org.primefaces.component.InputText");
                    this.setMaximumLength((UIComponent)inputText, attributes);
                    return inputText;
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    Calendar calendar = (Calendar)FacesUtils.createComponent("org.primefaces.component.Calendar", "org.primefaces.component.CalendarRenderer");
                    if (attributes.containsKey("datetime-pattern")) {
                        calendar.setPattern(attributes.get("datetime-pattern"));
                    }
                    if (attributes.containsKey("locale")) {
                        calendar.setLocale((Object)new Locale(attributes.get("locale")));
                    }
                    if (attributes.containsKey("time-zone")) {
                        calendar.setTimeZone((Object)TimeZone.getTimeZone(attributes.get("time-zone")));
                    }
                    return calendar;
                }
                if (String.class.equals(clazz)) {
                    String facesSuggest = attributes.get("faces-suggest");
                    if (facesSuggest != null) {
                        AutoComplete autoComplete = (AutoComplete)FacesUtils.createComponent("org.primefaces.component.AutoComplete", "org.primefaces.component.autocomplete.AutoCompleteRenderer");
                        autoComplete.setCompleteMethod(application.getExpressionFactory().createMethodExpression(context.getELContext(), facesSuggest, Object.class, new Class[]{String.class}));
                        return autoComplete;
                    }
                    Object component = "true".equals(attributes.get("masked")) ? FacesUtils.createComponent("org.primefaces.component.Password", "org.primefaces.component.PasswordRenderer") : ("true".equals(attributes.get("large")) ? FacesUtils.createComponent("org.primefaces.component.InputTextarea", "org.primefaces.component.InputTextareaRenderer") : FacesUtils.createComponent("org.primefaces.component.InputText", "org.primefaces.component.InputTextRenderer"));
                    this.setMaximumLength((UIComponent)component, attributes);
                    return component;
                }
                if (List.class.isAssignableFrom(clazz) || DataModel.class.isAssignableFrom(clazz) || clazz.isArray()) {
                    return this.createDataTableComponent(elementName, attributes, metawidget);
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    return application.createComponent("org.metawidget.Stub");
                }
                if (clazz.isPrimitive()) {
                    UIComponent ranged = this.createRanged(attributes);
                    if (ranged != null) {
                        return ranged;
                    }
                    Spinner spinner = (Spinner)FacesUtils.createComponent("org.primefaces.component.Spinner", "org.primefaces.component.SpinnerRenderer");
                    String minimumValue = attributes.get("minimum-value");
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        spinner.setMin(Double.parseDouble(minimumValue));
                    } else if (Byte.TYPE.equals(clazz)) {
                        spinner.setMin(-128.0);
                    } else if (Short.TYPE.equals(clazz)) {
                        spinner.setMin(-32768.0);
                    } else if (Integer.TYPE.equals(clazz)) {
                        spinner.setMin(-2.147483648E9);
                    } else if (Long.TYPE.equals(clazz)) {
                        spinner.setMin(-9.223372036854776E18);
                    } else if (Float.TYPE.equals(clazz)) {
                        spinner.setMin(-3.4028234663852886E38);
                    } else if (Double.TYPE.equals(clazz)) {
                        spinner.setMin(-1.7976931348623157E308);
                    }
                    String maximumValue = attributes.get("maximum-value");
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        spinner.setMax(Double.parseDouble(maximumValue));
                    } else if (Byte.TYPE.equals(clazz)) {
                        spinner.setMax(127.0);
                    } else if (Short.TYPE.equals(clazz)) {
                        spinner.setMax(32767.0);
                    } else if (Integer.TYPE.equals(clazz)) {
                        spinner.setMax(2.147483647E9);
                    } else if (Long.TYPE.equals(clazz)) {
                        spinner.setMax(9.223372036854776E18);
                    } else if (Float.TYPE.equals(clazz)) {
                        spinner.setMax(3.4028234663852886E38);
                    } else if (Double.TYPE.equals(clazz)) {
                        spinner.setMax(Double.MAX_VALUE);
                    }
                    if (Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) {
                        spinner.setStepFactor(0.1);
                    }
                    return spinner;
                }
            }
        }
        return null;
    }

    @Override
    protected void setMaximumLength(UIComponent component, Map<String, String> attributes) {
        String maximumLength = attributes.get("maximum-length");
        if (maximumLength != null && !"".equals(maximumLength)) {
            if (component instanceof InputTextarea) {
                ((InputTextarea)component).setMaxlength(Integer.parseInt(maximumLength));
            } else {
                super.setMaximumLength(component, attributes);
            }
        }
    }

    @Override
    protected void configureDataTableComponent(UIData uiData) {
        DataTable dataTable = (DataTable)uiData;
        dataTable.setStyleClass(this.mDataTableStyleClass);
        dataTable.setRowStyleClass(this.mDataTableRowStyleClass);
        dataTable.setTableStyleClass(this.mDataTableTableStyleClass);
    }

    @Override
    protected UIColumn createColumnComponent() {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        return (Column)application.createComponent("org.primefaces.component.Column");
    }

    @Override
    protected UIData createDataTableComponent() {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        return (UIData)application.createComponent("org.primefaces.component.DataTable");
    }

    @Override
    protected HtmlCommandLink createCommandLinkComponent() {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        return (CommandLink)application.createComponent("org.primefaces.component.CommandLink");
    }

    @Override
    protected int getMaximumColumnsInDataTable() {
        return this.mMaximumColumnsInDataTable;
    }

    private UIComponent createRanged(Map<String, String> attributes) {
        String minimumValue = attributes.get("minimum-value");
        String maximumValue = attributes.get("maximum-value");
        if (minimumValue != null && !"".equals(minimumValue) && maximumValue != null && !"".equals(maximumValue)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application application = context.getApplication();
            UIStub stub = (UIStub)application.createComponent("org.metawidget.Stub");
            InputText inputText = (InputText)application.createComponent("org.primefaces.component.InputText");
            inputText.setId(FacesUtils.createUniqueId());
            stub.getChildren().add(inputText);
            Slider slider = (Slider)FacesUtils.createComponent("org.primefaces.component.Slider", "org.primefaces.component.SliderRenderer");
            slider.setMinValue(Integer.parseInt(minimumValue));
            slider.setMaxValue(Integer.parseInt(maximumValue));
            slider.setFor(inputText.getId());
            stub.getChildren().add(slider);
            return stub;
        }
        return null;
    }
}

