/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetbuilder;

import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.swing.widgetbuilder.LookupLabel;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<JComponent, SwingMetawidget>,
SwingValuePropertyProvider {
    @Override
    public String getValueProperty(Component component) {
        if (component instanceof JLabel) {
            return "text";
        }
        return null;
    }

    @Override
    public JComponent buildWidget(String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        if (!WidgetBuilderUtils.isReadOnly(attributes)) {
            return null;
        }
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(elementName)) {
            JButton button = new JButton(metawidget.getLabelString(attributes));
            button.setEnabled(false);
            return button;
        }
        if ("true".equals(attributes.get("masked"))) {
            return new JPanel();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            String lookupLabels = attributes.get("lookup-labels");
            if (lookupLabels != null && !"".equals(lookupLabels)) {
                return new LookupLabel(CollectionUtils.newHashMap(CollectionUtils.fromString(lookup), CollectionUtils.fromString(lookupLabels)));
            }
            return new JLabel();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return new JLabel();
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    JTextArea textarea = new JTextArea();
                    textarea.setLineWrap(true);
                    textarea.setWrapStyleWord(true);
                    textarea.setEditable(false);
                    textarea.setRows(2);
                    JScrollPane scrollPane = new JScrollPane(textarea);
                    scrollPane.setBorder(null);
                    return scrollPane;
                }
                return new JLabel();
            }
            if (Character.class.equals(clazz)) {
                return new JLabel();
            }
            if (Date.class.equals(clazz)) {
                return new JLabel();
            }
            if (Boolean.class.equals(clazz)) {
                return new JLabel();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new JLabel();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new JLabel();
        }
        return null;
    }
}

