/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javassist;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyleConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistPropertyStyle
extends JavaBeanPropertyStyle {
    public JavassistPropertyStyle() {
    }

    public JavassistPropertyStyle(JavaBeanPropertyStyleConfig javaBeanPropertyStyleConfig) {
        super(javaBeanPropertyStyleConfig);
    }

    protected Map<String, Property> inspectProperties(String string) {
        try {
            TreeMap treeMap = CollectionUtils.newTreeMap();
            ClassPool classPool = ClassPool.getDefault();
            CtClass ctClass = classPool.get(string);
            Map map = super.inspectProperties(string);
            for (Object object : map.values()) {
                JavaBeanPropertyStyle.FieldProperty fieldProperty;
                String string2 = object.getName();
                if (object instanceof JavaBeanPropertyStyle.JavaBeanProperty) {
                    fieldProperty = null;
                    JavaBeanPropertyStyle.JavaBeanProperty javaBeanProperty = (JavaBeanPropertyStyle.JavaBeanProperty)object;
                    Method method = javaBeanProperty.getReadMethod();
                    if (method != null) {
                        fieldProperty = this.getCtMethod(ctClass, method, new CtClass[0]);
                    } else {
                        method = javaBeanProperty.getWriteMethod();
                        fieldProperty = this.getCtMethod(ctClass, method, classPool.get(object.getType()));
                    }
                    MethodInfo methodInfo = fieldProperty.getMethodInfo();
                    int n = methodInfo.getLineNumber(0);
                    if (n == -1 && !ctClass.isInterface()) {
                        throw InspectorException.newException((String)("Line number information for " + string + " not available. Did you compile without debug info?"));
                    }
                    treeMap.put(new ClassAndLineNumberAndName(method.getDeclaringClass(), n, string2), object);
                    continue;
                }
                if (object instanceof JavaBeanPropertyStyle.FieldProperty) {
                    fieldProperty = (JavaBeanPropertyStyle.FieldProperty)object;
                    treeMap.put(new ClassAndLineNumberAndName(fieldProperty.getField().getDeclaringClass(), 0, string2), object);
                    continue;
                }
                throw InspectorException.newException((String)("Unknown property type " + object.getClass()));
            }
            LinkedHashMap linkedHashMap = CollectionUtils.newLinkedHashMap();
            for (String string2 : treeMap.values()) {
                linkedHashMap.put(string2.getName(), string2);
            }
            return linkedHashMap;
        }
        catch (Exception exception) {
            throw InspectorException.newException((Throwable)exception);
        }
    }

    private CtMethod getCtMethod(CtClass ctClass, Method method, CtClass ... ctClassArray) throws NotFoundException {
        CtClass ctClass2 = ctClass;
        while (true) {
            try {
                return ctClass2.getDeclaredMethod(method.getName(), ctClassArray);
            }
            catch (NotFoundException notFoundException) {
                ctClass2 = ctClass2.getSuperclass();
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassAndLineNumberAndName
    implements Comparable<ClassAndLineNumberAndName> {
        private Class<?> mClass;
        private int mLineNumber;
        private String mName;

        public ClassAndLineNumberAndName(Class<?> clazz, int n, String string) {
            this.mClass = clazz;
            this.mLineNumber = n;
            this.mName = string;
        }

        @Override
        public int compareTo(ClassAndLineNumberAndName classAndLineNumberAndName) {
            if (!this.mClass.equals(classAndLineNumberAndName.mClass)) {
                if (this.mClass.isAssignableFrom(classAndLineNumberAndName.mClass)) {
                    return -1;
                }
                return 1;
            }
            if (this.mLineNumber != classAndLineNumberAndName.mLineNumber) {
                return this.mLineNumber - classAndLineNumberAndName.mLineNumber;
            }
            return this.mName.compareTo(classAndLineNumberAndName.mName);
        }
    }
}

