/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jpa.JpaInspectorConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaInspector
extends BaseObjectInspector {
    private final boolean mHideIds;
    private final boolean mHideVersions;
    private final boolean mHideTransients;

    public JpaInspector() {
        this(new JpaInspectorConfig());
    }

    public JpaInspector(JpaInspectorConfig config) {
        super((BaseObjectInspectorConfig)config);
        this.mHideIds = config.isHideIds();
        this.mHideVersions = config.isHideVersions();
        this.mHideTransients = config.isHideTransients();
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        ManyToOne manyToOne;
        Column column;
        HashMap attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(Lob.class)) {
            attributes.put("large", "true");
        }
        if ((column = (Column)property.getAnnotation(Column.class)) != null) {
            if (!column.nullable()) {
                attributes.put("required", "true");
            }
            if (column.length() != 255) {
                attributes.put("maximum-length", String.valueOf(column.length()));
            }
        }
        if ((manyToOne = (ManyToOne)property.getAnnotation(ManyToOne.class)) != null && !manyToOne.optional()) {
            attributes.put("required", "true");
        }
        if (this.mHideIds && property.isAnnotationPresent(Id.class)) {
            attributes.put("hidden", "true");
        } else if (this.mHideVersions && property.isAnnotationPresent(Version.class)) {
            attributes.put("hidden", "true");
        } else if (this.mHideTransients && property.isAnnotationPresent(Transient.class)) {
            attributes.put("hidden", "true");
        }
        return attributes;
    }
}

