/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.MigLayoutConfig;
import org.metawidget.util.simple.Pair;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final boolean mSupportMnemonics;

    public MigLayout() {
        this(new MigLayoutConfig());
    }

    public MigLayout(MigLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
        this.mSupportMnemonics = config.isSupportMnemonics();
    }

    public void onStartBuild(SwingMetawidget metawidget) {
    }

    public void startContainerLayout(JComponent container, SwingMetawidget metawidget) {
        container.putClientProperty(MigLayout.class, null);
        State state = this.getState(container);
        LC layoutConstraints = new LC().insets("0");
        net.miginfocom.swing.MigLayout layoutManager = new net.miginfocom.swing.MigLayout(layoutConstraints);
        container.setLayout((LayoutManager)layoutManager);
        JTextField dummyTextField = new JTextField();
        dummyTextField.setLayout((LayoutManager)layoutManager);
        double dummyTextFieldHeight = dummyTextField.getPreferredSize().getHeight();
        JLabel dummyLabel = new JLabel("X");
        dummyLabel.setLayout((LayoutManager)layoutManager);
        double dummyLabelHeight = dummyLabel.getPreferredSize().getHeight();
        state.defaultLabelVerticalPadding = (int)Math.max(0.0, Math.floor((dummyTextFieldHeight - dummyLabelHeight) / 2.0));
    }

    public void layoutWidget(JComponent component, String elementName, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        boolean spanAllColumns;
        if (component instanceof Stub && ((Stub)component).getComponentCount() == 0) {
            return;
        }
        State state = this.getState(container);
        boolean bl = spanAllColumns = component instanceof JScrollPane || component instanceof SwingMetawidget || SimpleLayoutUtils.isSpanAllColumns(attributes);
        if (spanAllColumns && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String labelText = null;
        if (attributes != null) {
            labelText = metawidget.getLabelString(attributes);
        }
        this.layoutBeforeChild(component, labelText, elementName, attributes, container, metawidget);
        CC componentConstraints = new CC();
        if (labelText != null) {
            componentConstraints.cell(new int[]{state.currentColumn * 2 + 1, state.currentRow});
        } else {
            componentConstraints.cell(new int[]{state.currentColumn * 2, state.currentRow});
            componentConstraints.spanX(2);
        }
        componentConstraints.pushX(Float.valueOf(1.0f)).growX();
        if (spanAllColumns) {
            componentConstraints.spanX();
            state.currentColumn = this.mNumberOfColumns;
        }
        componentConstraints.alignY("top");
        if (this.willFillVertically(component, attributes)) {
            componentConstraints.pushY(Float.valueOf(1.0f)).growY();
        }
        container.add((Component)component, componentConstraints);
        ++state.currentColumn;
        if (state.currentColumn >= this.mNumberOfColumns) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    public void endContainerLayout(JComponent container, SwingMetawidget metawidget) {
    }

    public void onEndBuild(SwingMetawidget metawidget) {
        Facet buttonsFacet = metawidget.getFacet("buttons");
        if (buttonsFacet != null) {
            State state = this.getState((JComponent)metawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
            }
            metawidget.add((Component)buttonsFacet, (Object)new CC().cell(new int[]{0, ++state.currentRow}).spanX().growX());
        }
    }

    protected void layoutBeforeChild(Component component, String labelText, String elementName, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        State state = this.getState(container);
        if (SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName)) {
            JLabel label = new JLabel();
            label.setName(attributes.get("name") + LABEL_NAME_SUFFIX);
            Pair stripMnemonic = SimpleLayoutUtils.stripMnemonic((String)labelText);
            String labelTextToUse = (String)stripMnemonic.getLeft();
            if ("true".equals(attributes.get("required")) && !"true".equals(attributes.get("read-only")) && !metawidget.isReadOnly()) {
                label.setText(labelTextToUse + "*:");
            } else {
                label.setText(labelTextToUse + ":");
            }
            label.setLabelFor(component);
            int mnemonicIndex = (Integer)stripMnemonic.getRight();
            if (mnemonicIndex != -1 && this.mSupportMnemonics) {
                label.setDisplayedMnemonic(labelTextToUse.charAt(mnemonicIndex));
                label.setDisplayedMnemonicIndex(mnemonicIndex);
            }
            CC labelConstraints = new CC();
            labelConstraints.cell(new int[]{state.currentColumn * 2, state.currentRow});
            labelConstraints.growX();
            labelConstraints.alignY("top");
            labelConstraints.pad(state.defaultLabelVerticalPadding, 0, state.defaultLabelVerticalPadding, 0);
            container.add((Component)label, labelConstraints);
        }
    }

    protected boolean willFillVertically(JComponent component, Map<String, String> attributes) {
        if (attributes != null && "true".equals(attributes.get("large"))) {
            return true;
        }
        return component instanceof JScrollPane;
    }

    private State getState(JComponent container) {
        State state = (State)container.getClientProperty(MigLayout.class);
        if (state == null) {
            state = new State();
            container.putClientProperty(MigLayout.class, state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int currentRow;
        int defaultLabelVerticalPadding;

        State() {
        }
    }
}

