/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import java.util.Map;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swt.Facet;
import org.metawidget.swt.Stub;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.layout.MigLayoutConfig;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigLayout
implements AdvancedLayout<Control, Composite, SwtMetawidget> {
    private final int mNumberOfColumns;

    public MigLayout() {
        this(new MigLayoutConfig());
    }

    public MigLayout(MigLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
    }

    public void onStartBuild(SwtMetawidget metawidget) {
    }

    public void startContainerLayout(Composite container, SwtMetawidget metawidget) {
        container.setData(MigLayout.class.getName(), null);
        State state = this.getState(container);
        LC layoutConstraints = new LC().insets("0");
        net.miginfocom.swt.MigLayout layout = new net.miginfocom.swt.MigLayout(layoutConstraints);
        container.setLayout((Layout)layout);
        state.defaultLabelVerticalPadding = new GC((Drawable)container).getFontMetrics().getLeading();
    }

    public void layoutWidget(Control control, String elementName, Map<String, String> attributes, Composite container, SwtMetawidget metawidget) {
        boolean spanAllColumns;
        if (control instanceof Stub && ((Stub)control).getChildren().length == 0) {
            CC controlConstraints = new CC();
            controlConstraints.setHideMode(3);
            control.setLayoutData((Object)controlConstraints);
            control.setVisible(false);
            return;
        }
        State state = this.getState(container);
        boolean bl = spanAllColumns = control instanceof SwtMetawidget || SimpleLayoutUtils.isSpanAllColumns(attributes);
        if (spanAllColumns && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String labelText = null;
        if (attributes != null) {
            labelText = metawidget.getLabelString(attributes);
        }
        this.layoutBeforeChild(control, labelText, elementName, attributes, (Control)container, metawidget);
        CC controlConstraints = new CC();
        if (labelText != null) {
            controlConstraints.cell(new int[]{state.currentColumn * 2 + 1, state.currentRow});
        } else {
            controlConstraints.cell(new int[]{state.currentColumn * 2, state.currentRow});
            controlConstraints.spanX(2);
        }
        controlConstraints.pushX(Float.valueOf(1.0f)).growX();
        if (spanAllColumns) {
            controlConstraints.spanX();
            state.currentColumn = this.mNumberOfColumns;
        }
        controlConstraints.alignY("top");
        if (this.willFillVertically(control, attributes)) {
            controlConstraints.pushY(Float.valueOf(1.0f)).growY();
        }
        control.setLayoutData((Object)controlConstraints);
        ++state.currentColumn;
        if (state.currentColumn >= this.mNumberOfColumns) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    public void endContainerLayout(Composite container, SwtMetawidget metawidget) {
    }

    public void onEndBuild(SwtMetawidget metawidget) {
        Facet buttonsFacet = metawidget.getFacet("buttons");
        if (buttonsFacet != null) {
            State state = this.getState((Composite)metawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
            }
            buttonsFacet.setLayoutData((Object)new CC().cell(new int[]{0, ++state.currentRow}).spanX().growX());
            buttonsFacet.moveBelow(null);
        }
    }

    protected String layoutBeforeChild(Control control, String labelText, String elementName, Map<String, String> attributes, Control container, SwtMetawidget metawidget) {
        State state = this.getState((Composite)container);
        if (SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName)) {
            Label label = new Label((Composite)container, 0);
            if (attributes != null && "true".equals(attributes.get("required")) && !"true".equals(attributes.get("read-only")) && !metawidget.isReadOnly()) {
                label.setText(labelText + "*:");
            } else {
                label.setText(labelText + ":");
            }
            CC labelConstraints = new CC();
            labelConstraints.cell(new int[]{state.currentColumn * 2, state.currentRow});
            labelConstraints.growX();
            labelConstraints.alignY("top");
            labelConstraints.pad(state.defaultLabelVerticalPadding, 0, state.defaultLabelVerticalPadding, 0);
            label.setLayoutData((Object)labelConstraints);
            label.moveAbove(control);
        }
        return labelText;
    }

    protected boolean willFillVertically(Control control, Map<String, String> attributes) {
        return attributes != null && "true".equals(attributes.get("large"));
    }

    private State getState(Composite container) {
        State state = (State)container.getData(MigLayout.class.getName());
        if (state == null) {
            state = new State();
            container.setData(MigLayout.class.getName(), (Object)state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int currentRow;
        int defaultLabelVerticalPadding;

        State() {
        }
    }
}

