/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.seam;

import java.io.InputStream;
import java.util.ArrayList;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.jbpm.PageflowInspector;
import org.metawidget.inspector.seam.SeamInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeamInspector
implements Inspector {
    private static final String JBPM_ELEMENT = "jbpm";
    private static final String PAGEFLOW_DEFINITIONS_ELEMENT = "pageflow-definitions";
    private final PageflowInspector mPageflowInspector;

    public SeamInspector() {
        this(new SeamInspectorConfig());
    }

    public SeamInspector(SeamInspectorConfig seamInspectorConfig) {
        Element element;
        Document document;
        try {
            document = XmlUtils.parse((InputStream)seamInspectorConfig.getComponentsInputStream());
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw InspectorException.newException((Throwable)exception);
        }
        document = seamInspectorConfig.getResourceResolver();
        ArrayList arrayList = CollectionUtils.newArrayList();
        Element element2 = XmlUtils.getChildNamed((Element)element, (String[])new String[]{JBPM_ELEMENT, PAGEFLOW_DEFINITIONS_ELEMENT, "value"});
        while (element2 != null) {
            arrayList.add(document.openResource(element2.getTextContent()));
            element2 = XmlUtils.getSiblingNamed((Element)element2, (String)"value");
        }
        if (arrayList.isEmpty()) {
            this.mPageflowInspector = null;
        } else {
            BaseXmlInspectorConfig baseXmlInspectorConfig = new BaseXmlInspectorConfig();
            baseXmlInspectorConfig.setInputStreams(arrayList.toArray(new InputStream[arrayList.size()]));
            this.mPageflowInspector = new PageflowInspector(baseXmlInspectorConfig);
        }
    }

    public String inspect(Object object, String string, String ... stringArray) {
        if (this.mPageflowInspector != null) {
            return this.mPageflowInspector.inspect(object, string, stringArray);
        }
        return null;
    }
}

