/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swt.Facet;
import org.metawidget.swt.Stub;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.layout.GridLayoutConfig;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayout
implements AdvancedLayout<Control, Composite, SwtMetawidget> {
    private static final int LABEL_AND_CONTROL = 2;
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final int mLabelAlignment;
    private final Font mLabelFont;
    private final Color mLabelForeground;
    private final String mLabelSuffix;
    private final int mRequiredAlignment;
    private final String mRequiredText;

    public GridLayout() {
        this(new GridLayoutConfig());
    }

    public GridLayout(GridLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
        this.mLabelAlignment = config.getLabelAlignment();
        this.mLabelForeground = config.getLabelForeground();
        this.mLabelFont = config.getLabelFont();
        this.mLabelSuffix = config.getLabelSuffix();
        this.mRequiredAlignment = config.getRequiredAlignment();
        this.mRequiredText = config.getRequiredText();
    }

    public void onStartBuild(SwtMetawidget metawidget) {
    }

    public void startContainerLayout(Composite composite, SwtMetawidget metawidget) {
        org.eclipse.swt.layout.GridLayout layoutManager = new org.eclipse.swt.layout.GridLayout(this.mNumberOfColumns * 2, false);
        composite.setLayout((Layout)layoutManager);
        for (Control control : composite.getChildren()) {
            control.setLayoutData(null);
        }
    }

    public void layoutWidget(Control control, String elementName, Map<String, String> attributes, Composite composite, SwtMetawidget metawidget) {
        int totalHorizontalSpan;
        int numberColumnsRemainingOnRow;
        if (control instanceof Stub && ((Stub)control).getChildren().length == 0) {
            GridData stubData = new GridData();
            stubData.exclude = true;
            control.setLayoutData((Object)stubData);
            return;
        }
        boolean spanAllColumns = this.willFillHorizontally(control, attributes);
        if (spanAllColumns && (numberColumnsRemainingOnRow = (totalHorizontalSpan = this.getTotalHorizontalSpan(composite)) % (this.mNumberOfColumns * 2)) != 0) {
            Control lastControl = this.getLastNonExcludedControl(composite);
            ((GridData)lastControl.getLayoutData()).horizontalSpan = numberColumnsRemainingOnRow + 1;
        }
        String labelText = null;
        if (attributes != null) {
            labelText = metawidget.getLabelString(attributes);
        }
        this.layoutBeforeChild(control, labelText, elementName, attributes, composite, metawidget);
        GridData controlLayoutData = new GridData();
        controlLayoutData.grabExcessHorizontalSpace = true;
        if (!(control instanceof Button)) {
            controlLayoutData.horizontalAlignment = 4;
            controlLayoutData.verticalAlignment = 4;
        }
        if (spanAllColumns) {
            controlLayoutData.horizontalSpan = this.mNumberOfColumns * 2;
            if (SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName)) {
                --controlLayoutData.horizontalSpan;
            }
        } else if (!SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName)) {
            controlLayoutData.horizontalSpan = 2;
        }
        if (this.willFillVertically(control, attributes)) {
            controlLayoutData.grabExcessVerticalSpace = true;
        }
        control.setLayoutData((Object)controlLayoutData);
    }

    public void endContainerLayout(Composite composite, SwtMetawidget metawidget) {
    }

    public void onEndBuild(SwtMetawidget metawidget) {
        Facet buttonsFacet = metawidget.getFacet("buttons");
        if (buttonsFacet != null) {
            GridData buttonLayoutData = new GridData();
            buttonLayoutData.horizontalSpan = 2;
            buttonLayoutData.horizontalAlignment = 4;
            buttonLayoutData.grabExcessHorizontalSpace = true;
            buttonsFacet.setLayoutData(buttonLayoutData);
            buttonsFacet.moveBelow(null);
        }
    }

    protected String layoutBeforeChild(Control control, String labelText, String elementName, Map<String, String> attributes, Composite composite, SwtMetawidget metawidget) {
        if (SimpleLayoutUtils.needsLabel((String)labelText, (String)elementName)) {
            Label label = new Label(composite, 0);
            label.setData("name", (Object)(attributes.get("name") + LABEL_NAME_SUFFIX));
            if (this.mLabelFont != null) {
                label.setFont(this.mLabelFont);
            }
            if (this.mLabelForeground != null) {
                label.setForeground(this.mLabelForeground);
            }
            label.setAlignment(this.mLabelAlignment);
            String labelTextToUse = labelText;
            if (this.mRequiredText != null && "true".equals(attributes.get("required")) && !WidgetBuilderUtils.isReadOnly(attributes) && !metawidget.isReadOnly()) {
                if (this.mRequiredAlignment == 0x1000000) {
                    labelTextToUse = labelTextToUse + this.mRequiredText;
                } else if (this.mRequiredAlignment == 16384) {
                    labelTextToUse = this.mRequiredText + labelTextToUse;
                }
            }
            if (this.mLabelSuffix != null) {
                labelTextToUse = labelTextToUse + this.mLabelSuffix;
            }
            label.setText(labelTextToUse);
            GridData labelLayoutData = new GridData();
            labelLayoutData.horizontalAlignment = 4;
            labelLayoutData.verticalAlignment = 4;
            label.setLayoutData((Object)labelLayoutData);
            label.moveAbove(control);
        }
        return labelText;
    }

    protected boolean willFillHorizontally(Control control, Map<String, String> attributes) {
        if (control instanceof SwtMetawidget) {
            return true;
        }
        return SimpleLayoutUtils.isSpanAllColumns(attributes);
    }

    protected boolean willFillVertically(Control control, Map<String, String> attributes) {
        return attributes != null && "true".equals(attributes.get("large"));
    }

    private int getTotalHorizontalSpan(Composite composite) {
        Control[] children = composite.getChildren();
        int totalHorizontalSpan = 0;
        int length = children.length - 1;
        for (int loop = 0; loop < length; ++loop) {
            Control child = children[loop];
            GridData gridData = (GridData)child.getLayoutData();
            if (gridData == null || gridData.exclude) continue;
            totalHorizontalSpan += gridData.horizontalSpan;
        }
        return totalHorizontalSpan;
    }

    private Control getLastNonExcludedControl(Composite composite) {
        Control[] children = composite.getChildren();
        for (int loop = children.length - 2; loop > 0; --loop) {
            Control child = children[loop];
            GridData gridData = (GridData)child.getLayoutData();
            if (gridData == null || gridData.exclude) continue;
            return child;
        }
        return null;
    }
}

