/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.text.TextUtils;
import java.util.Arrays;

public class ConnectionResult {
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int NETWORK_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int INTERRUPTED = 15;
    public static final int API_UNAVAILABLE = 16;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    @Deprecated
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    private final int statusCode;
    private final PendingIntent pendingIntent;
    private final String message;

    public ConnectionResult(int statusCode) {
        this(statusCode, null);
    }

    public ConnectionResult(int statusCode, PendingIntent pendingIntent) {
        this(statusCode, pendingIntent, ConnectionResult.getStatusString(statusCode));
    }

    public ConnectionResult(int statusCode, PendingIntent pendingIntent, String message) {
        this.statusCode = statusCode;
        this.pendingIntent = pendingIntent;
        this.message = message;
    }

    static String getStatusString(int statusCode) {
        switch (statusCode) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 42: {
                return "UPDATE_ANDROID_WEAR";
            }
            case 99: {
                return "UNFINISHED";
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
        }
        return "UNKNOWN_ERROR_CODE(" + statusCode + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult r = (ConnectionResult)o;
        return this.statusCode == r.statusCode && this.pendingIntent == null ? r.pendingIntent == null : this.pendingIntent.equals((Object)r.pendingIntent) && TextUtils.equals((CharSequence)this.message, (CharSequence)r.message);
    }

    public int getErrorCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public PendingIntent getResolution() {
        return this.pendingIntent;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.statusCode, this.pendingIntent, this.message});
    }

    public boolean hasResolution() {
        return this.statusCode != 0 && this.pendingIntent != null;
    }

    public boolean isSuccess() {
        return this.statusCode == 0;
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (this.hasResolution()) {
            activity.startIntentSenderForResult(this.pendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
        }
    }
}

