/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import org.microg.safeparcel.AutoSafeParcelable;
import org.microg.safeparcel.SafeParceled;

public final class Status
extends AutoSafeParcelable
implements Result {
    public static final Status INTERNAL_ERROR = new Status(8);
    public static final Status CANCELED = new Status(16);
    public static final Status SUCCESS = new Status(0);
    @SafeParceled(value=1000)
    private int versionCode = 1;
    @SafeParceled(value=1)
    private final int statusCode;
    @SafeParceled(value=2)
    private final String statusMessage;
    @SafeParceled(value=3)
    private final PendingIntent resolution;
    public static final Parcelable.Creator<Status> CREATOR = new AutoSafeParcelable.AutoCreator(Status.class);

    private Status() {
        this.statusCode = 0;
        this.statusMessage = null;
        this.resolution = null;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent resolution) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.resolution = resolution;
    }

    public PendingIntent getResolution() {
        return this.resolution;
    }

    @Override
    public Status getStatus() {
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean hasResolution() {
        return this.resolution != null;
    }

    public boolean isCanceled() {
        return this.statusCode == 16;
    }

    public boolean isInterrupted() {
        return this.statusCode == 14;
    }

    public boolean isSuccess() {
        return this.statusCode <= 0;
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (this.hasResolution()) {
            activity.startIntentSenderForResult(this.resolution.getIntentSender(), requestCode, null, 0, 0, 0);
        }
    }
}

