/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.os.IBinder;
import androidx.annotation.Nullable;
import com.google.android.gms.dynamic.IObjectWrapper;
import java.lang.reflect.Field;

public class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    private final T t;

    public ObjectWrapper(T t) {
        this.t = t;
    }

    @Nullable
    public static Object unwrap(IObjectWrapper obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ObjectWrapper) {
            return ((ObjectWrapper)obj).t;
        }
        IBinder binder = obj.asBinder();
        Field[] fields = binder.getClass().getDeclaredFields();
        if (fields.length != 1) {
            throw new IllegalArgumentException();
        }
        Field field = fields[0];
        if (!field.isAccessible()) {
            field.setAccessible(true);
            try {
                return field.get(binder);
            }
            catch (NullPointerException localNullPointerException) {
                throw new IllegalArgumentException("Binder object is null.", localNullPointerException);
            }
            catch (IllegalArgumentException localIllegalArgumentException) {
                throw new IllegalArgumentException("remoteBinder is the wrong class.", localIllegalArgumentException);
            }
            catch (IllegalAccessException localIllegalAccessException) {
                throw new IllegalArgumentException("Could not access the field in remoteBinder.", localIllegalAccessException);
            }
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static <T> T unwrapTyped(IObjectWrapper obj, Class<T> clazz) {
        try {
            return clazz.cast(ObjectWrapper.unwrap(obj));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <T> ObjectWrapper<T> wrap(T t) {
        return new ObjectWrapper<T>(t);
    }
}

