/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.liberty;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.testcontainers.ApplicationContainer;
import org.microshed.testing.testcontainers.config.HollowTestcontainersConfiguration;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.microshed.testing.testcontainers.spi.ServerAdapter;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class LibertyAdapter
implements ServerAdapter {
    static final InternalLogger LOG = InternalLogger.get(LibertyAdapter.class);
    private static String BASE_DOCKER_IMAGE = "openliberty/open-liberty:full-java8-openj9-ubi";
    private static final String CONFIG_FILE_PROP = "MICROSHED_TEST_LIBERTY_CONFIG_FILE";

    public static String getBaseDockerImage() {
        return BASE_DOCKER_IMAGE;
    }

    public static void setBaseDockerImage(String imageName) {
        BASE_DOCKER_IMAGE = imageName;
    }

    public int getPriority() {
        return -50;
    }

    public int getDefaultHttpPort() {
        return 9080;
    }

    public int getDefaultHttpsPort() {
        return 9443;
    }

    public void setConfigProperties(Map<String, String> properties) {
        String MP_TEST_CONFIG_FILE = System.getProperty(CONFIG_FILE_PROP, System.getenv(CONFIG_FILE_PROP));
        Path configFile = null;
        if (MP_TEST_CONFIG_FILE == null) {
            String WLP_USR_DIR = System.getProperty("WLP_USR_DIR", System.getenv("WLP_USR_DIR"));
            if (WLP_USR_DIR == null) {
                WLP_USR_DIR = System.getProperty("wlp.user.dir");
            }
            if (WLP_USR_DIR == null) {
                throw new IllegalStateException("The 'wlp.user.dir', 'WLP_USR_DIR', or 'MICROSHED_TEST_LIBERTY_CONFIG_FILE' property must be set in order to dynamically set config properties");
            }
            Path usrDir = Paths.get(WLP_USR_DIR, new String[0]);
            configFile = usrDir.resolve("servers/defaultServer/configDropins/defaults/system-test-vars.xml");
        } else {
            configFile = Paths.get(MP_TEST_CONFIG_FILE, new String[0]);
        }
        configFile.getParent().toFile().mkdirs();
        if (properties.containsKey("mp_jwt_verify_publickey")) {
            properties.put("mp.jwt.verify.publickey", properties.remove("mp_jwt_verify_publickey"));
        }
        if (properties.containsKey("mp_jwt_verify_issuer")) {
            properties.put("mp.jwt.verify.issuer", properties.remove("mp_jwt_verify_issuer"));
        }
        ArrayList<String> lines = new ArrayList<String>(properties.size() + 2);
        lines.add("<server>");
        properties.forEach((k, v) -> lines.add("  <variable name=\"" + k + "\" value=\"" + v + "\"/>"));
        lines.add("</server>");
        try {
            Files.write(configFile, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Thread.sleep(500L);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write configuration to " + configFile, e);
        }
    }

    public ImageFromDockerfile getDefaultImage(File appFile) {
        String appName = appFile.getName();
        File configDir = new File("src/main/liberty/config");
        boolean configDirExists = configDir.exists() && configDir.canRead();
        ImageFromDockerfile image = (ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> {
            builder.from(LibertyAdapter.getBaseDockerImage());
            if (configDirExists) {
                builder.copy("/config", "/config");
            }
            builder.add("/config/dropins/" + appName, "/config/dropins/" + appName);
            builder.build();
        })).withFileFromFile("/config/dropins/" + appName, appFile);
        if (configDirExists) {
            image.withFileFromFile("/config", configDir);
        }
        return image;
    }

    public void configure(Set<GenericContainer<?>> containers) {
        this.configureKafka(containers);
    }

    private void configureKafka(Set<GenericContainer<?>> containers) {
        Class<?> KafkaContainer = LibertyAdapter.tryLoad("org.testcontainers.containers.KafkaContainer");
        if (KafkaContainer == null) {
            return;
        }
        Set kafkaContainers = containers.stream().filter(c -> KafkaContainer.isAssignableFrom(c.getClass())).collect(Collectors.toSet());
        if (kafkaContainers.size() != 1) {
            return;
        }
        GenericContainer kafka = (GenericContainer)kafkaContainers.iterator().next();
        String bootstrapProperty = "MP_MESSAGING_CONNECTOR_LIBERTY_KAFKA_BOOTSTRAP_SERVERS";
        String bootstrapServer = null;
        if (ApplicationEnvironment.Resolver.isSelected(TestcontainersConfiguration.class)) {
            if (kafka.getNetworkAliases().size() == 0) {
                throw new ExtensionConfigurationException("Unable to configure kafka bootstrap server because no network alias is defined");
            }
            bootstrapServer = (String)kafka.getNetworkAliases().get(kafka.getNetworkAliases().size() - 1) + ":9092";
        } else if (ApplicationEnvironment.Resolver.isSelected(HollowTestcontainersConfiguration.class)) {
            bootstrapServer = "localhost:9093";
        } else {
            return;
        }
        String finalBootstrapServers = bootstrapServer;
        LOG.info("Auto-configuring ApplicationContainer instances with " + bootstrapProperty + "=" + finalBootstrapServers);
        containers.stream().filter(c -> ApplicationContainer.class.isAssignableFrom(c.getClass())).filter(c -> c.getNetwork().equals(kafka.getNetwork())).filter(c -> !c.getEnvMap().containsKey(bootstrapProperty)).filter(c -> !c.getEnvMap().containsKey(bootstrapProperty.toLowerCase())).forEach(c -> c.withEnv(bootstrapProperty, finalBootstrapServers));
    }

    private static Class<?> tryLoad(String clazz) {
        try {
            return Class.forName(clazz, false, LibertyAdapter.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }
}

