/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers;

import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.ExposedPort;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.testcontainers.config.HollowTestcontainersConfiguration;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.microshed.testing.testcontainers.internal.ImageFromDockerfile;
import org.microshed.testing.testcontainers.spi.ServerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;

public class MicroProfileApplication
extends GenericContainer<MicroProfileApplication> {
    private static final String MP_HEALTH_READINESS_PATH = "/health/ready";
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroProfileApplication.class);
    private static final boolean mpHealth20Available;
    private static final boolean isHollow;
    private String appContextRoot;
    private ServerAdapter serverAdapter;
    private boolean readinessPathSet;
    private String lateBind_ipAddress;
    private int lateBind_port;
    private boolean lateBind_started;
    private static final Path dockerfile_root;
    private static final Path dockerfile_src_main;

    private static Optional<Path> autoDiscoverDockerfile() {
        if (Files.exists(dockerfile_root, new LinkOption[0])) {
            return Optional.of(dockerfile_root);
        }
        if (Files.exists(dockerfile_src_main, new LinkOption[0])) {
            return Optional.of(dockerfile_src_main);
        }
        return Optional.empty();
    }

    private static Future<String> resolveImage(Optional<Path> dockerfile) {
        if (isHollow) {
            return CompletableFuture.completedFuture("alpine:3.5");
        }
        if (dockerfile.isPresent()) {
            if (!Files.exists(dockerfile.get(), new LinkOption[0])) {
                throw new ExtensionConfigurationException("Dockerfile did not exist at: " + dockerfile.get());
            }
            ImageFromDockerfile image = new ImageFromDockerfile("testcontainers/mpapp-" + Base58.randomString((int)10).toLowerCase());
            image.withDockerfile(dockerfile.get());
            image.setBaseDirectory(Paths.get(".", new String[0]));
            return image;
        }
        return MicroProfileApplication.resolveAdatper().orElseThrow(() -> new ExtensionConfigurationException("Unable to resolve Docker image for application because:\n - unable to locate Dockerfile in " + dockerfile_root.toAbsolutePath() + "\n - unable to locate Dockerfile in " + dockerfile_src_main.toAbsolutePath() + "\n - did not find any ServerAdapter to provide a default Dockerfile")).getDefaultImage(MicroProfileApplication.findAppFile());
    }

    private static boolean isHollow() {
        ApplicationEnvironment current = ApplicationEnvironment.load();
        return !(current instanceof TestcontainersConfiguration) || current instanceof HollowTestcontainersConfiguration;
    }

    private static File findAppFile() {
        HashSet<File> matches = new HashSet<File>();
        matches.addAll(MicroProfileApplication.findAppFiles("build"));
        matches.addAll(MicroProfileApplication.findAppFiles("target"));
        if (matches.size() == 0) {
            throw new IllegalStateException("No .war or .ear files found in build/ or target/ output folders.");
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("Found multiple application files in build/ or target output folders: " + matches + " Expecting exactly 1 application file to be found.");
        }
        File appFile = (File)matches.iterator().next();
        LOGGER.info("Found application file at: " + appFile.getAbsolutePath());
        return appFile;
    }

    private static Set<File> findAppFiles(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            try {
                return Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".war")).map(p -> p.toFile()).collect(Collectors.toSet());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    private static Optional<ServerAdapter> resolveAdatper() {
        ArrayList<ServerAdapter> adapters = new ArrayList<ServerAdapter>(1);
        for (ServerAdapter adapter : ServiceLoader.load(ServerAdapter.class)) {
            adapters.add(adapter);
            LOGGER.info("Discovered ServerAdapter: " + adapter.getClass());
        }
        return adapters.stream().sorted((a1, a2) -> Integer.compare(a2.getPriority(), a1.getPriority())).findFirst();
    }

    public MicroProfileApplication() {
        this(MicroProfileApplication.autoDiscoverDockerfile());
    }

    private MicroProfileApplication(Optional<Path> dockerfilePath) {
        this(MicroProfileApplication.resolveImage(dockerfilePath));
    }

    public MicroProfileApplication(Path dockerfilePath) {
        this(Optional.of(dockerfilePath));
        LOGGER.info("Using Dockerfile at:" + dockerfilePath);
    }

    public MicroProfileApplication(Future<String> dockerImageName) {
        super(dockerImageName);
        this.commonInit();
    }

    public MicroProfileApplication(String dockerImageName) {
        super(dockerImageName);
        this.commonInit();
    }

    private void commonInit() {
        this.serverAdapter = MicroProfileApplication.resolveAdatper().orElseGet(() -> new DefaultServerAdapter());
        LOGGER.info("Using ServerAdapter: " + this.serverAdapter.getClass().getCanonicalName());
        this.addExposedPorts(new int[]{this.serverAdapter.getDefaultHttpPort()});
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.withAppContextRoot("/");
    }

    protected void configure() {
        super.configure();
        if (!this.readinessPathSet) {
            if (this.serverAdapter != null && this.serverAdapter.getReadinessPath().isPresent() && !this.serverAdapter.getReadinessPath().get().trim().isEmpty()) {
                this.withReadinessPath(this.serverAdapter.getReadinessPath().get());
            } else {
                this.withReadinessPath(mpHealth20Available ? MP_HEALTH_READINESS_PATH : this.appContextRoot);
            }
        }
    }

    public void setRunningURL(URL url) {
        this.lateBind_ipAddress = url.getHost();
        this.lateBind_port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
    }

    protected void doStart() {
        if (isHollow) {
            if (this.isRunning()) {
                return;
            }
            Map env = this.getEnvMap();
            if (env.size() > 0) {
                this.getServerAdapter().setConfigProperties(env);
            }
            this.lateBind_started = true;
            return;
        }
        super.doStart();
    }

    public boolean isCreated() {
        if (isHollow) {
            return true;
        }
        return super.isCreated();
    }

    public boolean isHealthy() {
        if (isHollow) {
            return true;
        }
        return super.isHealthy();
    }

    public boolean isRunning() {
        if (isHollow) {
            return this.lateBind_started;
        }
        return super.isRunning();
    }

    public String getContainerIpAddress() {
        if (isHollow) {
            return this.lateBind_ipAddress;
        }
        return super.getContainerIpAddress();
    }

    public Integer getFirstMappedPort() {
        if (isHollow) {
            return this.lateBind_port;
        }
        return super.getFirstMappedPort();
    }

    public MicroProfileApplication withAppContextRoot(String appContextRoot) {
        Objects.requireNonNull(appContextRoot);
        this.appContextRoot = appContextRoot = MicroProfileApplication.buildPath(appContextRoot, new String[0]);
        return this;
    }

    public MicroProfileApplication withReadinessPath(String readinessUrl) {
        this.withReadinessPath(readinessUrl, this.serverAdapter.getDefaultAppStartTimeout());
        return this;
    }

    public MicroProfileApplication withReadinessPath(String readinessUrl, int timeoutSeconds) {
        Objects.requireNonNull(readinessUrl);
        readinessUrl = MicroProfileApplication.buildPath(readinessUrl, new String[0]);
        this.waitingFor(Wait.forHttp((String)readinessUrl).withStartupTimeout(Duration.ofSeconds(timeoutSeconds)));
        return this;
    }

    public MicroProfileApplication waitingFor(WaitStrategy waitStrategy) {
        this.readinessPathSet = true;
        return (MicroProfileApplication)super.waitingFor(waitStrategy);
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.readinessPathSet = true;
        super.setWaitStrategy(waitStrategy);
    }

    public MicroProfileApplication withMpRestClient(Class<?> restClientClass, String hostUrl) {
        return this.withMpRestClient(restClientClass.getCanonicalName(), hostUrl);
    }

    public MicroProfileApplication withMpRestClient(String restClientClass, String hostUrl) {
        String envName = restClientClass.replaceAll("\\.", "_").replaceAll("\\$", "_") + "_mp_rest_url";
        return (MicroProfileApplication)this.withEnv(envName, hostUrl);
    }

    public String getApplicationURL() {
        return this.getBaseURL() + this.appContextRoot;
    }

    public String getBaseURL() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Container must be running to determine hostname and port");
        }
        return "http://" + this.getContainerIpAddress() + ':' + this.getFirstMappedPort();
    }

    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }

    private static String buildPath(String firstPart, String ... moreParts) {
        String result;
        String string = result = firstPart.startsWith("/") ? firstPart : '/' + firstPart;
        if (moreParts != null && moreParts.length > 0) {
            for (String part : moreParts) {
                result = result.endsWith("/") && part.startsWith("/") ? result + part.substring(1) : (result.endsWith("/") || part.startsWith("/") ? result + part : result + "/" + part);
            }
        }
        return result;
    }

    static {
        isHollow = MicroProfileApplication.isHollow();
        Class<?> readinessClass = null;
        try {
            readinessClass = Class.forName("org.eclipse.microprofile.health.Readiness");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        mpHealth20Available = readinessClass != null;
        dockerfile_root = Paths.get(".", "Dockerfile");
        dockerfile_src_main = Paths.get(".", "src", "main", "docker", "Dockerfile");
    }

    private class DefaultServerAdapter
    implements ServerAdapter {
        private final int defaultHttpPort;

        public DefaultServerAdapter() {
            if (isHollow) {
                this.defaultHttpPort = -1;
            } else {
                InspectImageResponse imageData = DockerClientFactory.instance().client().inspectImageCmd(MicroProfileApplication.this.getDockerImageName()).exec();
                LOGGER.info("Found exposed ports: " + Arrays.toString(imageData.getContainerConfig().getExposedPorts()));
                int bestChoice = -1;
                for (ExposedPort exposedPort : imageData.getContainerConfig().getExposedPorts()) {
                    int port = exposedPort.getPort();
                    if (Integer.toString(port).endsWith("80")) {
                        bestChoice = port;
                        break;
                    }
                    if (bestChoice != -1) continue;
                    bestChoice = port;
                }
                this.defaultHttpPort = bestChoice;
                LOGGER.info("Automatically selecting default HTTP port: " + this.defaultHttpPort);
            }
        }

        @Override
        public int getPriority() {
            return -100;
        }

        @Override
        public int getDefaultHttpPort() {
            return this.defaultHttpPort;
        }

        @Override
        public int getDefaultHttpsPort() {
            return -1;
        }

        @Override
        public Optional<String> getReadinessPath() {
            return Optional.empty();
        }
    }
}

