/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.config;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.ManuallyStartedConfiguration;
import org.microshed.testing.testcontainers.MicroProfileApplication;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class HollowTestcontainersConfiguration
extends TestcontainersConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HollowTestcontainersConfiguration.class);

    public static boolean available() {
        String host = HollowTestcontainersConfiguration.resolveProperty("microshed_hostname");
        String httpPort = HollowTestcontainersConfiguration.resolveProperty("microshed_http_port");
        String httpsPort = HollowTestcontainersConfiguration.resolveProperty("microshed_https_port");
        return !host.isEmpty() && (!httpPort.isEmpty() || !httpsPort.isEmpty());
    }

    private static String resolveProperty(String key) {
        String value = System.getProperty(key, System.getenv(key));
        return value == null ? "" : value;
    }

    @Override
    public boolean isAvailable() {
        return HollowTestcontainersConfiguration.available();
    }

    @Override
    public int getPriority() {
        return -20;
    }

    @Override
    public void applyConfiguration(Class<?> testClass) {
        URL appURL;
        super.applyConfiguration(testClass);
        Set networkAliases = this.allContainers().stream().filter(c -> !(c instanceof MicroProfileApplication)).flatMap(c -> c.getNetworkAliases().stream()).collect(Collectors.toSet());
        this.allContainers().stream().filter(c -> c instanceof MicroProfileApplication).map(c -> (MicroProfileApplication)((Object)c)).forEach(mpApp -> this.sanitizeEnvVar((MicroProfileApplication)((Object)mpApp), networkAliases));
        try {
            Method addFixedPort = GenericContainer.class.getDeclaredMethod("addFixedExposedPort", Integer.TYPE, Integer.TYPE);
            addFixedPort.setAccessible(true);
            HashMap<Integer, String> fixedExposedPorts = new HashMap<Integer, String>();
            for (GenericContainer<?> c2 : this.allContainers()) {
                for (Integer p : c2.getExposedPorts()) {
                    LOG.info("exposing port: " + p + " for container " + c2.getDockerImageName());
                    if (fixedExposedPorts.containsKey(p)) {
                        throw new ExtensionConfigurationException("Cannot expose port " + p + " for " + c2.getDockerImageName() + " because another container (" + (String)fixedExposedPorts.get(p) + ") is already using it.");
                    }
                    fixedExposedPorts.put(p, c2.getDockerImageName());
                    addFixedPort.invoke(c2, p, p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String runtimeURL = ManuallyStartedConfiguration.getRuntimeURL();
        try {
            appURL = new URL(runtimeURL);
        }
        catch (MalformedURLException e) {
            throw new ExtensionConfigurationException("The application URL '" + runtimeURL + "' was not a valid URL.", (Throwable)e);
        }
        this.allContainers().stream().filter(c -> c instanceof MicroProfileApplication).map(c -> (MicroProfileApplication)((Object)c)).forEach(c -> c.setRunningURL(appURL));
    }

    private void sanitizeEnvVar(MicroProfileApplication mpApp, Set<String> networkAliases) {
        mpApp.getEnvMap().forEach((k, v) -> {
            URL url = null;
            try {
                url = new URL((String)v);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            for (String network : networkAliases) {
                String newValue = null;
                if (network.equals(v)) {
                    newValue = "localhost";
                } else if (url != null && url.getHost().equals(network)) {
                    newValue = v.replaceFirst(url.getHost(), "localhost");
                }
                if (newValue == null) continue;
                LOG.info("translating env var " + k + "=" + v + "-->localhost");
                mpApp.withEnv((String)k, newValue);
            }
        });
    }
}

