/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.SharedContainerConfig;
import org.microshed.testing.SharedContainerConfiguration;
import org.microshed.testing.jwt.JwtBuilder;
import org.microshed.testing.jwt.JwtConfig;
import org.microshed.testing.testcontainers.MicroProfileApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.junit.jupiter.Container;

public class TestcontainersConfiguration
implements ApplicationEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private Class<?> testClass;
    private Class<? extends SharedContainerConfiguration> sharedConfigClass;
    final Set<GenericContainer<?>> unsharedContainers = new HashSet();
    final Set<GenericContainer<?>> sharedContainers = new HashSet();

    public int getPriority() {
        return -30;
    }

    public boolean isAvailable() {
        return true;
    }

    public void applyConfiguration(Class<?> testClass) {
        this.testClass = testClass;
        if (testClass.isAnnotationPresent(SharedContainerConfig.class)) {
            this.sharedConfigClass = testClass.getAnnotation(SharedContainerConfig.class).value();
            this.sharedContainers.addAll(this.discoverContainers(this.sharedConfigClass));
        }
        this.unsharedContainers.addAll(this.discoverContainers(testClass));
        boolean networksDefined = false;
        if (this.sharedConfigClass != null) {
            for (GenericContainer<?> c2 : this.sharedContainers) {
                networksDefined |= c2.getNetwork() != null;
            }
            if (!networksDefined) {
                LOG.debug("No networks explicitly defined. Using shared network for all containers in " + this.sharedConfigClass);
                this.sharedContainers.forEach(c -> c.setNetwork(Network.SHARED));
            }
        }
        networksDefined = false;
        for (GenericContainer<?> c2 : this.unsharedContainers) {
            networksDefined |= c2.getNetwork() != null;
        }
        if (!networksDefined) {
            LOG.debug("No networks explicitly defined. Using shared network for all containers in " + testClass);
            this.unsharedContainers.forEach(c -> c.setNetwork(Network.SHARED));
        }
        if (this.isJwtNeeded()) {
            Stream.concat(this.unsharedContainers.stream(), this.sharedContainers.stream()).filter(c -> MicroProfileApplication.class.isAssignableFrom(c.getClass())).filter(c -> !c.isRunning()).filter(c -> !c.getEnvMap().containsKey("mp_jwt_verify_publickey")).filter(c -> !c.getEnvMap().containsKey("mp_jwt_verify_issuer")).forEach(c -> {
                c.withEnv("mp_jwt_verify_publickey", JwtBuilder.getPublicKey());
                c.withEnv("mp_jwt_verify_issuer", "http://testissuer.com");
                LOG.debug("Using default generated JWT settings for " + c);
            });
        }
    }

    public void start() {
        ArrayList<Object> containersToStart = new ArrayList<Object>();
        if (this.sharedConfigClass != null) {
            try {
                SharedContainerConfiguration config = this.sharedConfigClass.newInstance();
                config.startContainers();
                LOG.debug("Shared contianer config for " + this.sharedConfigClass + " implemented a manual start procedure.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExtensionConfigurationException("Unable to instantiate " + this.sharedConfigClass, (Throwable)e);
            }
            catch (UnsupportedOperationException ignore) {
                containersToStart.addAll(this.sharedContainers);
            }
        }
        containersToStart.addAll(this.unsharedContainers);
        containersToStart.removeIf(c -> c.isRunning());
        if (containersToStart.size() == 0) {
            return;
        }
        LOG.info("Starting containers in parallel for " + this.testClass);
        for (GenericContainer genericContainer : containersToStart) {
            LOG.info("  " + genericContainer.getImage());
        }
        long start = System.currentTimeMillis();
        containersToStart.parallelStream().forEach(GenericContainer::start);
        LOG.info("All containers started in " + (System.currentTimeMillis() - start) + "ms");
    }

    public String getApplicationURL() {
        MicroProfileApplication mpApp = this.autoDiscoverMPApp(this.testClass, true);
        if (!mpApp.isCreated() || !mpApp.isRunning()) {
            throw new ExtensionConfigurationException("MicroProfileApplication " + mpApp.getDockerImageName() + " is not running yet. The contianer must be running in order to obtain its URL.");
        }
        return mpApp.getApplicationURL();
    }

    private boolean isJwtNeeded() {
        if (this.sharedConfigClass != null) {
            return true;
        }
        return AnnotationSupport.findAnnotatedFields(this.testClass, JwtConfig.class).size() > 0;
    }

    private MicroProfileApplication autoDiscoverMPApp(Class<?> clazz, boolean errorIfNone) {
        List mpApps = AnnotationSupport.findAnnotatedFields(clazz, Container.class, f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && MicroProfileApplication.class.isAssignableFrom(f.getType()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (mpApps.size() == 1) {
            try {
                return (MicroProfileApplication)((Object)((Field)mpApps.get(0)).get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (mpApps.size() > 1) {
            throw new ExtensionConfigurationException("Should be no more than 1 public static MicroProfileApplication field on " + clazz);
        }
        String sharedConfigMsg = "";
        if (this.sharedConfigClass != null) {
            MicroProfileApplication mpApp = this.autoDiscoverMPApp(this.sharedConfigClass, false);
            if (mpApp != null) {
                return mpApp;
            }
            sharedConfigMsg = " or " + this.sharedConfigClass;
        }
        if (errorIfNone) {
            throw new ExtensionConfigurationException("No public static MicroProfileApplication fields annotated with @Container were located on " + clazz + sharedConfigMsg + " to auto-connect with REST-client fields.");
        }
        return null;
    }

    protected Set<GenericContainer<?>> discoverContainers(Class<?> clazz) {
        HashSet discoveredContainers = new HashSet();
        for (Field containerField : AnnotationSupport.findAnnotatedFields(clazz, Container.class)) {
            if (!Modifier.isPublic(containerField.getModifiers())) {
                throw new ExtensionConfigurationException("@Container annotated fields must be public visibility");
            }
            if (!Modifier.isStatic(containerField.getModifiers())) {
                throw new ExtensionConfigurationException("@Container annotated fields must be static");
            }
            boolean isStartable = GenericContainer.class.isAssignableFrom(containerField.getType());
            if (!isStartable) {
                throw new ExtensionConfigurationException("@Container annotated fields must be a subclass of " + GenericContainer.class);
            }
            try {
                GenericContainer startableContainer = (GenericContainer)containerField.get(null);
                discoveredContainers.add(startableContainer);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOG.warn("Unable to access field " + containerField, (Throwable)e);
            }
        }
        return discoveredContainers;
    }

    protected Set<GenericContainer<?>> allContainers() {
        HashSet all = new HashSet(this.unsharedContainers);
        all.addAll(this.sharedContainers);
        return all;
    }
}

