/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.SharedContainerConfig;
import org.microshed.testing.SharedContainerConfiguration;
import org.microshed.testing.jwt.JwtBuilder;
import org.microshed.testing.jwt.JwtConfig;
import org.microshed.testing.testcontainers.ApplicationContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.junit.jupiter.Container;

public class TestcontainersConfiguration
implements ApplicationEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private static Class<?> currentTestClass;
    private static Class<? extends SharedContainerConfiguration> sharedConfigClass;
    private static final Set<GenericContainer<?>> unsharedContainers;
    private static final Set<GenericContainer<?>> sharedContainers;

    public int getPriority() {
        return -30;
    }

    public boolean isAvailable() {
        return true;
    }

    public void applyConfiguration(Class<?> testClass) {
        currentTestClass = testClass;
        if (testClass.isAnnotationPresent(SharedContainerConfig.class)) {
            sharedConfigClass = testClass.getAnnotation(SharedContainerConfig.class).value();
            sharedContainers.addAll(this.discoverContainers(sharedConfigClass));
        }
        unsharedContainers.addAll(this.discoverContainers(testClass));
        boolean networksDefined = false;
        if (sharedConfigClass != null) {
            for (GenericContainer<?> c2 : sharedContainers) {
                networksDefined |= c2.getNetwork() != null;
            }
            if (!networksDefined) {
                LOG.debug("No networks explicitly defined. Using shared network for all containers in " + sharedConfigClass);
                sharedContainers.forEach(c -> c.setNetwork(Network.SHARED));
            }
        }
        networksDefined = false;
        for (GenericContainer<?> c2 : unsharedContainers) {
            networksDefined |= c2.getNetwork() != null;
        }
        if (!networksDefined) {
            LOG.debug("No networks explicitly defined. Using shared network for all containers in " + testClass);
            unsharedContainers.forEach(c -> c.setNetwork(Network.SHARED));
        }
        if (this.isJwtNeeded()) {
            Stream.concat(unsharedContainers.stream(), sharedContainers.stream()).filter(c -> ApplicationContainer.class.isAssignableFrom(c.getClass())).filter(c -> !c.isRunning()).filter(c -> !c.getEnvMap().containsKey("mp_jwt_verify_publickey")).filter(c -> !c.getEnvMap().containsKey("mp_jwt_verify_issuer")).forEach(c -> {
                c.withEnv("mp_jwt_verify_publickey", JwtBuilder.getPublicKey());
                c.withEnv("mp_jwt_verify_issuer", "http://testissuer.com");
                LOG.debug("Using default generated JWT settings for " + c);
            });
        }
    }

    public void start() {
        ArrayList<Object> containersToStart = new ArrayList<Object>();
        if (sharedConfigClass != null) {
            try {
                SharedContainerConfiguration config = sharedConfigClass.newInstance();
                config.startContainers();
                LOG.debug("Shared contianer config for " + sharedConfigClass + " implemented a manual start procedure.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExtensionConfigurationException("Unable to instantiate " + sharedConfigClass, (Throwable)e);
            }
            catch (UnsupportedOperationException ignore) {
                containersToStart.addAll(sharedContainers);
            }
        }
        containersToStart.addAll(unsharedContainers);
        containersToStart.removeIf(c -> c.isRunning());
        if (containersToStart.size() == 0) {
            return;
        }
        LOG.info("Starting containers in parallel for " + currentTestClass);
        for (GenericContainer genericContainer : containersToStart) {
            LOG.info("  " + genericContainer.getImage());
        }
        long start = System.currentTimeMillis();
        containersToStart.parallelStream().forEach(GenericContainer::start);
        LOG.info("All containers started in " + (System.currentTimeMillis() - start) + "ms");
    }

    public String getApplicationURL() {
        ApplicationContainer mpApp = this.autoDiscoverMPApp(currentTestClass, true);
        if (!mpApp.isCreated() || !mpApp.isRunning()) {
            throw new ExtensionConfigurationException("ApplicationContainer " + mpApp.getDockerImageName() + " is not running yet. The contianer must be running in order to obtain its URL.");
        }
        return mpApp.getApplicationURL();
    }

    private boolean isJwtNeeded() {
        if (sharedConfigClass != null) {
            return true;
        }
        return AnnotationSupport.findAnnotatedFields(currentTestClass, JwtConfig.class).size() > 0;
    }

    private ApplicationContainer autoDiscoverMPApp(Class<?> clazz, boolean errorIfNone) {
        List mpApps = AnnotationSupport.findAnnotatedFields(clazz, Container.class, f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && ApplicationContainer.class.isAssignableFrom(f.getType()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        if (mpApps.size() == 1) {
            try {
                return (ApplicationContainer)((Object)((Field)mpApps.get(0)).get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (mpApps.size() > 1) {
            throw new ExtensionConfigurationException("Should be no more than 1 public static ApplicationContainer field on " + clazz);
        }
        String sharedConfigMsg = "";
        if (sharedConfigClass != null) {
            ApplicationContainer mpApp = this.autoDiscoverMPApp(sharedConfigClass, false);
            if (mpApp != null) {
                return mpApp;
            }
            sharedConfigMsg = " or " + sharedConfigClass;
        }
        if (errorIfNone) {
            throw new ExtensionConfigurationException("No public static ApplicationContainer fields annotated with @Container were located on " + clazz + sharedConfigMsg + " to auto-connect with REST-client fields.");
        }
        return null;
    }

    protected Set<GenericContainer<?>> discoverContainers(Class<?> clazz) {
        HashSet discoveredContainers = new HashSet();
        for (Field containerField : AnnotationSupport.findAnnotatedFields(clazz, Container.class)) {
            if (!Modifier.isPublic(containerField.getModifiers())) {
                throw new ExtensionConfigurationException("@Container annotated fields must be public visibility");
            }
            if (!Modifier.isStatic(containerField.getModifiers())) {
                throw new ExtensionConfigurationException("@Container annotated fields must be static");
            }
            boolean isStartable = GenericContainer.class.isAssignableFrom(containerField.getType());
            if (!isStartable) {
                throw new ExtensionConfigurationException("@Container annotated fields must be a subclass of " + GenericContainer.class);
            }
            try {
                GenericContainer startableContainer = (GenericContainer)containerField.get(null);
                discoveredContainers.add(startableContainer);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOG.warn("Unable to access field " + containerField, (Throwable)e);
            }
        }
        return discoveredContainers;
    }

    protected Set<GenericContainer<?>> allContainers() {
        HashSet all = new HashSet(unsharedContainers);
        all.addAll(sharedContainers);
        return all;
    }

    static {
        unsharedContainers = new HashSet();
        sharedContainers = new HashSet();
    }
}

