/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.config;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.testcontainers.ApplicationContainer;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.testcontainers.containers.GenericContainer;

public class HollowTestcontainersConfiguration
extends TestcontainersConfiguration {
    private static final InternalLogger LOG = InternalLogger.get(HollowTestcontainersConfiguration.class);

    public static boolean available() {
        String host = HollowTestcontainersConfiguration.resolveProperty("microshed_hostname");
        String httpPort = HollowTestcontainersConfiguration.resolveProperty("microshed_http_port");
        String httpsPort = HollowTestcontainersConfiguration.resolveProperty("microshed_https_port");
        return !host.isEmpty() && (!httpPort.isEmpty() || !httpsPort.isEmpty());
    }

    private static String resolveProperty(String key) {
        String value = System.getProperty(key, System.getenv(key));
        return value == null ? "" : value;
    }

    @Override
    public boolean isAvailable() {
        return HollowTestcontainersConfiguration.available();
    }

    @Override
    public int getPriority() {
        return -20;
    }

    @Override
    void configureContainerNetworks(Set<GenericContainer<?>> containers, Class<?> clazz) {
        HashSet copy = new HashSet(containers);
        copy.removeIf(c -> c instanceof ApplicationContainer);
        if (copy.size() <= 1) {
            LOG.debug("NOT putting contaienrs in shared network for class " + clazz);
            return;
        }
        super.configureContainerNetworks(containers, clazz);
    }

    @Override
    public void preConfigure(Class<?> testClass) {
        super.preConfigure(testClass);
        Set<String> networkAliases = this.containers.allContainers.stream().filter(c -> !(c instanceof ApplicationContainer)).flatMap(c -> c.getNetworkAliases().stream()).collect(Collectors.toSet());
        this.sanitizeEnvVar(this.containers.app, networkAliases);
        try {
            Method addFixedPort = GenericContainer.class.getDeclaredMethod("addFixedExposedPort", Integer.TYPE, Integer.TYPE);
            addFixedPort.setAccessible(true);
            HashMap<Integer, String> fixedExposedPorts = new HashMap<Integer, String>();
            for (GenericContainer<?> c2 : this.containers.allContainers) {
                for (Integer p : c2.getExposedPorts()) {
                    if (fixedExposedPorts.containsKey(p) && !(c2 instanceof ApplicationContainer)) {
                        throw new ExtensionConfigurationException("Cannot expose port " + p + " for " + c2.getDockerImageName() + " because another container (" + (String)fixedExposedPorts.get(p) + ") is already using it.");
                    }
                    if (c2.isShouldBeReused() && !HollowTestcontainersConfiguration.isPortAvailable(p)) {
                        LOG.debug("Not exposing fixed port " + p + " for container " + c2.getDockerImageName());
                        continue;
                    }
                    LOG.info("Exposing fixed port " + p + " for container " + c2.getDockerImageName());
                    fixedExposedPorts.put(p, c2.getDockerImageName());
                    addFixedPort.invoke(c2, p, p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sanitizeEnvVar(ApplicationContainer mpApp, Set<String> networkAliases) {
        mpApp.getEnvMap().forEach((k, v) -> {
            URL url = null;
            try {
                url = new URL((String)v);
            }
            catch (MalformedURLException e1) {
                try {
                    url = new URL("http://" + v);
                }
                catch (MalformedURLException e2) {
                    return;
                }
            }
            for (String networkAlias : networkAliases) {
                if (!url.getHost().equals(networkAlias)) continue;
                String newValue = v.replaceFirst(networkAlias, "localhost");
                LOG.info("Translating env var key=" + k + " from " + v + " to " + newValue);
                mpApp.withEnv((String)k, newValue);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortAvailable(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

