/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.SharedContainerConfiguration;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.jwt.JwtBuilder;
import org.microshed.testing.jwt.JwtConfig;
import org.microshed.testing.testcontainers.ApplicationContainer;
import org.microshed.testing.testcontainers.internal.ContainerGroup;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startables;

public class TestcontainersConfiguration
implements ApplicationEnvironment {
    private static final InternalLogger LOG = InternalLogger.get(TestcontainersConfiguration.class);
    protected final Map<Class<?>, ContainerGroup> discoveredContainers = new HashMap();
    protected ContainerGroup containers;

    public int getPriority() {
        return -30;
    }

    public boolean isAvailable() {
        return true;
    }

    void configureContainerNetworks(Set<GenericContainer<?>> containers, Class<?> clazz) {
        boolean networksDefined = false;
        for (GenericContainer<?> c2 : containers) {
            networksDefined |= c2.getNetwork() != null;
        }
        if (!networksDefined) {
            LOG.debug("No networks explicitly defined. Using shared network for all containers in " + clazz);
            containers.forEach(c -> c.setNetwork(Network.SHARED));
        }
    }

    public void preConfigure(Class<?> testClass) {
        this.containers = this.discoveredContainers.computeIfAbsent(testClass, clazz -> new ContainerGroup((Class<?>)clazz));
        if (this.containers.hasSharedConfig()) {
            this.configureContainerNetworks(this.containers.sharedContainers, this.containers.sharedConfigClass);
        }
        this.configureContainerNetworks(this.containers.unsharedContainers, testClass);
        ApplicationContainer app = this.containers.app;
        if (app != null) {
            app.getServerAdapter().configure(this.containers.allContainers);
            if (this.isJwtNeeded() && !app.isRunning() && !app.getEnvMap().containsKey("mp_jwt_verify_publickey") && !app.getEnvMap().containsKey("mp_jwt_verify_issuer")) {
                app.withEnv("mp_jwt_verify_publickey", JwtBuilder.getPublicKey());
                app.withEnv("mp_jwt_verify_issuer", "http://testissuer.com");
                LOG.debug("Using default generated JWT settings for " + (Object)((Object)app));
            }
        }
    }

    public void start() {
        ArrayList<Object> containersToStart = new ArrayList<Object>();
        long start = System.currentTimeMillis();
        if (this.containers.hasSharedConfig()) {
            try {
                SharedContainerConfiguration config = this.containers.sharedConfigClass.newInstance();
                config.startContainers();
                LOG.debug("Shared contianer config for " + this.containers.sharedConfigClass + " implemented a manual start procedure.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExtensionConfigurationException("Unable to instantiate " + this.containers.sharedConfigClass, (Throwable)e);
            }
            catch (UnsupportedOperationException ignore) {
                containersToStart.addAll(this.containers.sharedContainers);
            }
        }
        containersToStart.addAll(this.containers.unsharedContainers);
        containersToStart.removeIf(c -> c.isRunning());
        if (containersToStart.size() > 0) {
            LOG.info("Starting " + containersToStart.size() + " container(s) in parallel for " + this.containers.testClass);
            for (GenericContainer genericContainer : containersToStart) {
                LOG.info("  " + genericContainer.getDockerImageName());
            }
            Startables.deepStart(containersToStart).join();
        }
        LOG.info("All containers started in " + (System.currentTimeMillis() - start) + "ms");
        this.configureKafka();
    }

    void configureKafka() {
        Class<?> KafkaContainer = TestcontainersConfiguration.tryLoad("org.testcontainers.containers.KafkaContainer");
        if (KafkaContainer == null) {
            return;
        }
        Set kafkaContainers = this.containers.allContainers.stream().filter(c -> KafkaContainer.isAssignableFrom(c.getClass())).collect(Collectors.toSet());
        if (kafkaContainers.size() == 1) {
            try {
                GenericContainer kafka = (GenericContainer)kafkaContainers.iterator().next();
                String bootstrapServers = (String)KafkaContainer.getMethod("getBootstrapServers", new Class[0]).invoke((Object)kafka, new Object[0]);
                System.setProperty("org.microshed.kafka.bootstrap.servers", bootstrapServers);
                LOG.debug("Discovered KafkaContainer with bootstrap.servers=" + bootstrapServers);
            }
            catch (Exception e) {
                LOG.warn("Unable to set kafka boostrap server", (Throwable)e);
            }
        } else if (kafkaContainers.size() > 1) {
            LOG.info("Located multiple KafkaContainer instances. Unable to auto configure kafka clients");
        } else {
            LOG.debug("No KafkaContainer instances found in configuration");
        }
    }

    public String getApplicationURL() {
        ApplicationContainer mpApp = this.containers.app;
        if (mpApp == null) {
            String sharedConfigMsg = this.containers.hasSharedConfig() ? " or " + this.containers.sharedConfigClass : "";
            throw new ExtensionConfigurationException("No public static ApplicationContainer fields annotated with @Container were located on " + this.containers.testClass + sharedConfigMsg + ".");
        }
        return mpApp.getApplicationURL();
    }

    private boolean isJwtNeeded() {
        if (this.containers.hasSharedConfig()) {
            return true;
        }
        return AnnotationSupport.findAnnotatedFields(this.containers.testClass, JwtConfig.class).size() > 0;
    }

    private static Class<?> tryLoad(String clazz) {
        try {
            return Class.forName(clazz, false, TestcontainersConfiguration.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }
}

