/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.ExposedPort;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.ManuallyStartedConfiguration;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.testcontainers.SystemOutLogConsumer;
import org.microshed.testing.testcontainers.config.HollowTestcontainersConfiguration;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.microshed.testing.testcontainers.internal.HollowContainerInspection;
import org.microshed.testing.testcontainers.internal.ImageFromDockerfile;
import org.microshed.testing.testcontainers.spi.ServerAdapter;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;

public class ApplicationContainer
extends GenericContainer<ApplicationContainer> {
    public static final String MP_HEALTH_READINESS_PATH = "/health/ready";
    private static final InternalLogger LOG = InternalLogger.get(ApplicationContainer.class);
    private static final boolean isHollow = ApplicationContainer.isHollow();
    private String appContextRoot;
    private ServerAdapter serverAdapter;
    private boolean waitStrategySet;
    private boolean readinessPathSet;
    private Integer primaryPort;
    private String lateBind_ipAddress;
    private boolean lateBind_started;
    private static final Path dockerfile_root = Paths.get(".", "Dockerfile");
    private static final Path dockerfile_src_main = Paths.get(".", "src", "main", "docker", "Dockerfile");

    private static Optional<Path> autoDiscoverDockerfile() {
        if (Files.exists(dockerfile_root, new LinkOption[0])) {
            return Optional.of(dockerfile_root);
        }
        if (Files.exists(dockerfile_src_main, new LinkOption[0])) {
            return Optional.of(dockerfile_src_main);
        }
        return Optional.empty();
    }

    private static Future<String> resolveImage(Optional<Path> dockerfile) {
        if (isHollow) {
            return CompletableFuture.completedFuture("alpine:3.5");
        }
        if (dockerfile.isPresent()) {
            if (!Files.exists(dockerfile.get(), new LinkOption[0])) {
                throw new ExtensionConfigurationException("Dockerfile did not exist at: " + dockerfile.get());
            }
            ImageFromDockerfile image = new ImageFromDockerfile("testcontainers/mpapp-" + Base58.randomString((int)10).toLowerCase());
            image.withDockerfile(dockerfile.get());
            image.setBaseDirectory(Paths.get(".", new String[0]));
            return image;
        }
        return ApplicationContainer.resolveAdatper().orElseThrow(() -> new ExtensionConfigurationException("Unable to resolve Docker image for application because:\n - unable to locate Dockerfile in " + dockerfile_root.toAbsolutePath() + "\n - unable to locate Dockerfile in " + dockerfile_src_main.toAbsolutePath() + "\n - did not find any ServerAdapter to provide a default Dockerfile")).getDefaultImage(ApplicationContainer.findAppFile());
    }

    private static boolean isHollow() {
        return ApplicationEnvironment.Resolver.isSelected(HollowTestcontainersConfiguration.class) || ApplicationEnvironment.Resolver.isSelected(ManuallyStartedConfiguration.class);
    }

    private static File findAppFile() {
        HashSet<File> matches = new HashSet<File>();
        matches.addAll(ApplicationContainer.findAppFiles("build"));
        matches.addAll(ApplicationContainer.findAppFiles("target"));
        if (matches.size() == 0) {
            throw new IllegalStateException("No .war or .ear files found in build/ or target/ output folders.");
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("Found multiple application files in build/ or target output folders: " + matches + " Expecting exactly 1 application file to be found.");
        }
        File appFile = (File)matches.iterator().next();
        LOG.info("Found application file at: " + appFile.getAbsolutePath());
        return appFile;
    }

    private static Set<File> findAppFiles(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            try {
                return Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".war")).map(p -> p.toFile()).collect(Collectors.toSet());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    private static Optional<ServerAdapter> resolveAdatper() {
        ArrayList<ServerAdapter> adapters = new ArrayList<ServerAdapter>(1);
        for (ServerAdapter adapter : ServiceLoader.load(ServerAdapter.class)) {
            adapters.add(adapter);
            LOG.debug("Discovered ServerAdapter: " + adapter.getClass());
        }
        return adapters.stream().sorted((a1, a2) -> Integer.compare(a2.getPriority(), a1.getPriority())).findFirst();
    }

    public ApplicationContainer() {
        this(ApplicationContainer.autoDiscoverDockerfile());
    }

    private ApplicationContainer(Optional<Path> dockerfilePath) {
        this(ApplicationContainer.resolveImage(dockerfilePath));
    }

    public ApplicationContainer(Path dockerfilePath) {
        this(Optional.of(dockerfilePath));
        LOG.info("Using Dockerfile at: " + dockerfilePath);
    }

    public ApplicationContainer(Future<String> dockerImageName) {
        super(dockerImageName);
        this.commonInit();
    }

    public ApplicationContainer(String dockerImageName) {
        super(dockerImageName);
        this.commonInit();
    }

    private void commonInit() {
        this.serverAdapter = ApplicationContainer.resolveAdatper().orElseGet(() -> new DefaultServerAdapter());
        LOG.info("Using ServerAdapter: " + this.serverAdapter.getClass().getCanonicalName());
        if (ApplicationContainer.LOG.LOG_ENABLED) {
            this.withLogConsumer((Consumer)new Slf4jLogConsumer(ApplicationContainer.LOG.log));
        } else {
            this.withLogConsumer(new SystemOutLogConsumer("[ApplicationContainer]"));
        }
        if (isHollow) {
            this.setContainerIpAddress(ManuallyStartedConfiguration.getHostname());
            this.withAppContextRoot(ManuallyStartedConfiguration.getBasePath());
        } else {
            this.withAppContextRoot("/");
        }
    }

    protected void configure() {
        super.configure();
        if (this.getExposedPorts().size() == 0) {
            this.addExposedPort(this.serverAdapter.getDefaultHttpPort());
        }
        if (!this.waitStrategySet) {
            if (this.serverAdapter != null && this.serverAdapter.getReadinessPath().isPresent()) {
                this.withReadinessPath(this.serverAdapter.getReadinessPath().get());
            } else {
                this.withReadinessPath(this.appContextRoot);
            }
        }
        if (this.readinessPathSet && this.primaryPort != null && this.waitStrategy instanceof HttpWaitStrategy) {
            HttpWaitStrategy wait = (HttpWaitStrategy)this.waitStrategy;
            wait.forPort(this.primaryPort.intValue());
        }
    }

    public void setContainerIpAddress(String ipAddress) {
        if (!isHollow) {
            throw new IllegalStateException("Can only set contaienr IP address in hollow mode");
        }
        this.lateBind_ipAddress = ipAddress;
    }

    public void setFirstMappedPort(int port) {
        if (!isHollow) {
            throw new IllegalStateException("Can only set first mapped port in hollow mode");
        }
        this.primaryPort = port;
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        List exposedPorts = this.getExposedPorts();
        if (exposedPorts.size() == 0) {
            LOG.info(this.toStringSimple() + " has no exposed ports.");
        } else {
            LOG.info(this.toStringSimple() + " has exposed ports:");
            exposedPorts.forEach(p -> LOG.info("  " + p + " --> " + this.getMappedPort((int)p)));
        }
    }

    protected void doStart() {
        if (isHollow) {
            if (this.isRunning()) {
                return;
            }
            Map env = this.getEnvMap();
            if (env.size() > 0) {
                this.getServerAdapter().setConfigProperties(env);
            }
            this.configure();
            this.waitUntilContainerStarted();
            this.lateBind_started = true;
            return;
        }
        super.doStart();
    }

    public boolean isCreated() {
        if (isHollow) {
            return true;
        }
        return super.isCreated();
    }

    public boolean isHealthy() {
        if (isHollow) {
            return true;
        }
        return super.isHealthy();
    }

    public boolean isRunning() {
        if (isHollow) {
            return this.lateBind_started;
        }
        return super.isRunning();
    }

    public String getContainerIpAddress() {
        if (isHollow) {
            return this.lateBind_ipAddress;
        }
        return super.getContainerIpAddress();
    }

    public Integer getMappedPort(int originalPort) {
        if (isHollow) {
            return originalPort;
        }
        return super.getMappedPort(originalPort);
    }

    public void setExposedPorts(List<Integer> exposedPorts) {
        ArrayList<Integer> copy = new ArrayList<Integer>(exposedPorts);
        if (this.primaryPort != null) {
            copy.removeIf(p -> p.equals(this.primaryPort));
            copy.add(0, this.primaryPort);
        }
        super.setExposedPorts(copy);
    }

    public ApplicationContainer withHttpPort(int httpPort) {
        this.primaryPort = httpPort;
        ArrayList<Integer> ports = new ArrayList<Integer>(this.getExposedPorts());
        ports.add(0, this.primaryPort);
        this.setExposedPorts(ports);
        return this;
    }

    public ApplicationContainer withAppContextRoot(String appContextRoot) {
        Objects.requireNonNull(appContextRoot);
        this.appContextRoot = appContextRoot = ApplicationContainer.buildPath(appContextRoot, new String[0]);
        return this;
    }

    public ApplicationContainer withReadinessPath(String readinessUrl) {
        this.withReadinessPath(readinessUrl, this.serverAdapter.getDefaultAppStartTimeout());
        return this;
    }

    public ApplicationContainer withReadinessPath(String readinessUrl, int timeoutSeconds) {
        this.withReadinessPath(readinessUrl, timeoutSeconds, this.primaryPort);
        return this;
    }

    public ApplicationContainer withReadinessPath(String readinessUrl, int timeoutSeconds, Integer port) {
        this.readinessPathSet = true;
        Objects.requireNonNull(readinessUrl);
        readinessUrl = ApplicationContainer.buildPath(readinessUrl, new String[0]);
        HttpWaitStrategy strat = Wait.forHttp((String)readinessUrl);
        if (port != null) {
            strat.forPort(port.intValue());
        }
        strat.withStartupTimeout(Duration.ofSeconds(timeoutSeconds));
        this.waitingFor((WaitStrategy)strat);
        return this;
    }

    public ApplicationContainer waitingFor(WaitStrategy waitStrategy) {
        this.waitStrategySet = true;
        return (ApplicationContainer)super.waitingFor(waitStrategy);
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategySet = true;
        super.setWaitStrategy(waitStrategy);
    }

    public ApplicationContainer withMpRestClient(Class<?> restClientClass, String hostUri) {
        Objects.requireNonNull(restClientClass, "restClientClass must be non-null");
        Objects.requireNonNull(hostUri, "hostUri must be non-null");
        if (!restClientClass.isInterface()) {
            throw new IllegalArgumentException("Provided restClientClass " + restClientClass.getCanonicalName() + " must be an interface");
        }
        URI.create(hostUri);
        String configToken = this.readMpRestClientConfigKey(restClientClass);
        if (configToken == null || configToken.isEmpty()) {
            configToken = restClientClass.getCanonicalName();
        }
        return this.withMpRestClient(configToken, hostUri);
    }

    private String readMpRestClientConfigKey(Class<?> restClientClass) {
        Class<?> RegisterRestClient = null;
        try {
            RegisterRestClient = Class.forName("org.eclipse.microprofile.rest.client.inject.RegisterRestClient", false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError notFound) {
            throw new ExtensionConfigurationException("Unable to load @RegisterRestClient", notFound);
        }
        Method getConfigKey = null;
        try {
            getConfigKey = RegisterRestClient.getMethod("configKey", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
        Optional foundAnno = AnnotationSupport.findAnnotation(restClientClass, RegisterRestClient);
        if (!foundAnno.isPresent()) {
            throw new IllegalArgumentException("Provided restClientClass " + restClientClass + " must be annotated with " + RegisterRestClient.getSimpleName());
        }
        Annotation anno = (Annotation)foundAnno.get();
        try {
            return (String)getConfigKey.invoke((Object)anno, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to obtain configKey from " + anno + " found on " + restClientClass.getCanonicalName());
        }
    }

    public ApplicationContainer withMpRestClient(String restClientClass, String hostUri) {
        restClientClass = ApplicationEnvironment.Resolver.isSelected(TestcontainersConfiguration.class) ? restClientClass.replaceAll("[^a-zA-Z0-9_]", "_") + "_mp_rest_url" : restClientClass + "/mp-rest/url";
        URI.create(hostUri);
        return (ApplicationContainer)this.withEnv(restClientClass, hostUri);
    }

    public ApplicationContainer withReuse(boolean reusable) {
        if (reusable) {
            throw new UnsupportedOperationException("Container reuse is not supported for ApplicationContainer. Instead, see HollowTestContainersConfiguration documentation: https://microshed.org/microshed-testing/features/ApplicationEnvironment.html");
        }
        super.withReuse(reusable);
        return this;
    }

    public String getApplicationURL() {
        return this.getBaseURL() + this.appContextRoot;
    }

    public String getBaseURL() {
        if (!isHollow && !this.isRunning()) {
            throw new IllegalStateException("Container must be running to determine hostname and port");
        }
        return "http://" + this.getContainerIpAddress() + ':' + this.getFirstMappedPort();
    }

    public InspectContainerResponse getContainerInfo() {
        if (isHollow) {
            return new HollowContainerInspection(this);
        }
        return super.getContainerInfo();
    }

    public String getDockerImageName() {
        if (isHollow) {
            return "HollowApplicationContainer";
        }
        return super.getDockerImageName();
    }

    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }

    private static String buildPath(String firstPart, String ... moreParts) {
        String result;
        String string = result = firstPart.startsWith("/") ? firstPart : '/' + firstPart;
        if (moreParts != null && moreParts.length > 0) {
            for (String part : moreParts) {
                result = result.endsWith("/") && part.startsWith("/") ? result + part.substring(1) : (result.endsWith("/") || part.startsWith("/") ? result + part : result + "/" + part);
            }
        }
        return result;
    }

    public String toStringSimple() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getDockerImageName() + "]";
    }

    private class DefaultServerAdapter
    implements ServerAdapter {
        private final int defaultHttpPort;

        public DefaultServerAdapter() {
            if (isHollow) {
                this.defaultHttpPort = -1;
            } else {
                InspectImageResponse imageData = DockerClientFactory.instance().client().inspectImageCmd(ApplicationContainer.this.getDockerImageName()).exec();
                LOG.info("Found exposed ports: " + Arrays.toString(imageData.getContainerConfig().getExposedPorts()));
                int bestChoice = -1;
                for (ExposedPort exposedPort : imageData.getContainerConfig().getExposedPorts()) {
                    int port = exposedPort.getPort();
                    if (Integer.toString(port).endsWith("80")) {
                        bestChoice = port;
                        break;
                    }
                    if (bestChoice != -1) continue;
                    bestChoice = port;
                }
                this.defaultHttpPort = bestChoice;
                LOG.info("Automatically selecting default HTTP port: " + this.defaultHttpPort);
            }
        }

        @Override
        public int getPriority() {
            return -100;
        }

        @Override
        public int getDefaultHttpPort() {
            return this.defaultHttpPort;
        }

        @Override
        public int getDefaultHttpsPort() {
            return -1;
        }

        @Override
        public Optional<String> getReadinessPath() {
            return Optional.empty();
        }
    }
}

