/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.testcontainers.spi;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;

public interface ServerAdapter {
    public static final int PRIORITY_USER_DEFAULT = 50;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_RUNTIME_MODULE = -50;

    default public int getPriority() {
        return 0;
    }

    public int getDefaultHttpPort();

    public int getDefaultHttpsPort();

    default public int getDefaultAppStartTimeout() {
        return "true".equalsIgnoreCase(System.getenv("CI")) ? 90 : 30;
    }

    default public void setConfigProperties(Map<String, String> properties) {
        throw new UnsupportedOperationException("Dynamically setting config properties is not supported for the default (generic) ServerAdapter. Try enabling the appropriate runtime-specific module documented here: https://microshed.org/microshed-testing/features/SupportedRuntimes.html");
    }

    default public ImageFromDockerfile getDefaultImage(File appFile) {
        throw new UnsupportedOperationException("Dynamically building image is not supported for the default (generic) ServerAdapter. Try enabling the appropriate runtime-specific module documented here: https://microshed.org/microshed-testing/features/SupportedRuntimes.html");
    }

    default public Optional<String> getReadinessPath() {
        return Optional.empty();
    }

    default public void configure(Set<GenericContainer<?>> allContainers) {
    }
}

