/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataEncoder;
import org.milyn.javabean.decoders.LocaleAwareDecoder;

public abstract class NumberDecoder
extends LocaleAwareDecoder
implements DataEncoder {
    public static final String FORMAT = "format";
    private NumberFormat numberFormat;
    private boolean isPercentage;

    public void setConfiguration(Properties config) throws SmooksConfigurationException {
        super.setConfiguration(config);
        String pattern = config.getProperty(FORMAT);
        Locale locale = this.getLocale();
        if (locale == null && pattern == null) {
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (pattern != null && pattern.indexOf(37) != -1) {
            this.numberFormat = NumberFormat.getPercentInstance(locale);
            this.isPercentage = true;
        } else {
            this.numberFormat = NumberFormat.getInstance(locale);
            this.numberFormat.setGroupingUsed(false);
        }
        if (pattern != null && this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).applyPattern(pattern);
        }
    }

    public NumberFormat getNumberFormat() {
        if (this.numberFormat != null) {
            return (NumberFormat)this.numberFormat.clone();
        }
        return null;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public String encode(Object object) throws DataDecodeException {
        if (this.numberFormat != null) {
            return this.getNumberFormat().format(object);
        }
        return object.toString();
    }
}

