/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model.internal;

import org.milyn.assertion.AssertArgument;

public class Description {
    private String name;
    private String version;

    public String getName() {
        return this.name;
    }

    public Description setName(String name) {
        AssertArgument.isNotNull((Object)name, (String)"name");
        this.name = name.trim();
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Description setVersion(String version) {
        AssertArgument.isNotNull((Object)version, (String)"version");
        this.version = version.trim();
        return this;
    }

    public boolean equals(Object obj) {
        this.assertInitialized();
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Description) {
            Description description = (Description)obj;
            return description.name.equals(this.name) && description.version.equals(this.version);
        }
        if (obj instanceof String) {
            return obj.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        this.assertInitialized();
        return (this.name + "#" + this.version).hashCode();
    }

    private void assertInitialized() {
        if (this.name == null || this.version == null) {
            throw new IllegalStateException("Description 'name' and/or 'version' properties are not initialized.");
        }
    }
}

