/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers.r41;

import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.ControlBlockHandlerFactory;
import org.milyn.edisax.unedifact.handlers.GenericHandler;
import org.milyn.edisax.unedifact.handlers.UNAHandler;
import org.milyn.edisax.unedifact.handlers.r41.UNBHandler;
import org.milyn.edisax.unedifact.handlers.r41.UNGHandler;
import org.milyn.edisax.unedifact.handlers.r41.UNHHandler;
import org.milyn.xml.hierarchy.HierarchyChangeListener;
import org.xml.sax.SAXException;

public class UNEdifact41ControlBlockHandlerFactory
implements ControlBlockHandlerFactory {
    private HierarchyChangeListener hierarchyChangeListener;

    public UNEdifact41ControlBlockHandlerFactory(HierarchyChangeListener hierarchyChangeListener) {
        this.hierarchyChangeListener = hierarchyChangeListener;
    }

    public ControlBlockHandler getControlBlockHandler(String segCode) throws SAXException {
        if (segCode.equals("UNH")) {
            return new UNHHandler(this.hierarchyChangeListener);
        }
        if (segCode.equals("UNG")) {
            return new UNGHandler();
        }
        if (segCode.equals("UNA")) {
            return new UNAHandler();
        }
        if (segCode.equals("UNB")) {
            return new UNBHandler();
        }
        if (segCode.charAt(0) == 'U') {
            return new GenericHandler();
        }
        throw new SAXException("Unknown/Unexpected UN/EDIFACT control block segment code '" + segCode + "'.");
    }
}

