/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.javabean.BeanInstanceCreator;
import org.milyn.javabean.BeanInstancePopulator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BindingAppender;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.ext.SelectorPropertyResolver;
import org.milyn.javabean.factory.Factory;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean
extends BindingAppender {
    BeanInstanceCreator beanInstanceCreator;
    private Class<?> beanClass;
    private String createOnElement;
    private String targetNamespace;
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<Bean> wirings = new ArrayList<Bean>();
    private boolean processed = false;

    public Bean(Class<?> beanClass, String beanId) {
        this(beanClass, beanId, (Factory)null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, Factory<? extends T> factory) {
        this(beanClass, beanId, "$document", null, factory);
    }

    public Bean(Class<?> beanClass, String beanId, String createOnElement) {
        this(beanClass, beanId, createOnElement, (String)null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, String createOnElement, Factory<? extends T> factory) {
        this(beanClass, beanId, createOnElement, null, factory);
    }

    public Bean(Class<?> beanClass, String beanId, String createOnElement, String createOnElementNS) {
        this(beanClass, beanId, createOnElement, createOnElementNS, null);
    }

    public <T> Bean(Class<T> beanClass, String beanId, String createOnElement, String createOnElementNS, Factory<? extends T> factory) {
        super(beanId);
        AssertArgument.isNotNull(beanClass, "beanClass");
        AssertArgument.isNotNull(createOnElement, "createOnElement");
        this.beanClass = beanClass;
        this.createOnElement = createOnElement;
        this.targetNamespace = createOnElementNS;
        this.beanInstanceCreator = new BeanInstanceCreator(beanId, beanClass, factory);
    }

    public static Bean newBean(Class<?> beanClass, String beanId, String createOnElement, String createOnElementNS) {
        return new Bean(beanClass, beanId, createOnElement, createOnElementNS);
    }

    public static <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, String createOnElementNS, Factory<T> factory) {
        return new Bean(beanClass, beanId, createOnElement, createOnElementNS, factory);
    }

    public Bean newBean(Class<?> beanClass, String createOnElement) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement);
    }

    public <T> Bean newBean(Class<T> beanClass, String createOnElement, Factory<T> factory) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement, factory);
    }

    public Bean newBean(Class<?> beanClass, String beanId, String createOnElement) {
        return new Bean(beanClass, beanId, createOnElement);
    }

    public <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, Factory<T> factory) {
        return new Bean(beanClass, beanId, createOnElement, factory);
    }

    public Bean bindTo(String bindingMember, String dataSelector) {
        return this.bindTo(bindingMember, dataSelector, null);
    }

    public Bean bindTo(String bindingMember, String dataSelector, DataDecoder dataDecoder) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bindingMember, "bindingMember");
        AssertArgument.isNotNull(dataSelector, "dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        beanInstancePopulator.setValueAttributePrefix(populatorConfig.getStringParameter("valueAttributePrefix"));
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (dataDecoder == null) {
                Class<?> dataType = bindingMethod.getParameterTypes()[0];
                dataDecoder = DataDecoder.Factory.create(dataType);
            }
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        beanInstancePopulator.setDecoder(dataDecoder);
        this.bindings.add(new Binding(populatorConfig.getSelector(), beanInstancePopulator, false));
        return this;
    }

    public Bean bindTo(String bindingMember, Bean bean) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bindingMember, "bindingMember");
        AssertArgument.isNotNull(bean, "bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, false));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(Bean bean) throws IllegalArgumentException {
        this.assertNotProcessed();
        AssertArgument.isNotNull(bean, "bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, true));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(String dataSelector) {
        return this.bindTo(dataSelector, (DataDecoder)null);
    }

    public Bean bindTo(String dataSelector, DataDecoder dataDecoder) {
        this.assertNotProcessed();
        AssertArgument.isNotNull(dataSelector, "dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        beanInstancePopulator.setValueAttributePrefix(populatorConfig.getStringParameter("valueAttributePrefix"));
        beanInstancePopulator.setDecoder(dataDecoder);
        this.bindings.add(new Binding(populatorConfig.getSelector(), beanInstancePopulator, true));
        return this;
    }

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.processed) {
            return;
        }
        this.processed = true;
        SmooksResourceConfiguration creatorConfig = visitorMap.addVisitor(this.beanInstanceCreator, this.createOnElement, this.targetNamespace, true);
        creatorConfig.setParameter("beanId", this.getBeanId());
        creatorConfig.setParameter("beanClass", this.beanClass.getName());
        for (Bean bean : this.wirings) {
            bean.addVisitors(visitorMap);
        }
        for (Binding binding : this.bindings) {
            SmooksResourceConfiguration populatorConfig = visitorMap.addVisitor(binding.beanInstancePopulator, binding.selector, this.targetNamespace, true);
            populatorConfig.setParameter("beanId", this.getBeanId());
            if (!binding.assertTargetIsCollection) continue;
            this.assertBeanClassIsCollection();
        }
    }

    public static Method getBindingMethod(String bindingMember, Class<?> beanClass) {
        Method[] methods;
        for (Method method : methods = beanClass.getMethods()) {
            if (!method.getName().equals(bindingMember) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        String asPropertySetterMethod = ClassUtil.toSetterName(bindingMember);
        for (Method method : methods) {
            if (!method.getName().equals(asPropertySetterMethod) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    private void assertBeanClassIsCollection() {
        BeanRuntimeInfo beanRuntimeInfo = this.beanInstanceCreator.getBeanRuntimeInfo();
        if (beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.COLLECTION_COLLECTION && beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new IllegalArgumentException("Invalid call to a Collection/array Bean.bindTo method for a non Collection/Array target.  Binding target type '" + beanRuntimeInfo.getPopulateType().getName() + "' (beanId '" + this.getBeanId() + "').  Use one of the Bean.bindTo methods that specify a 'bindingMember' argument.");
        }
    }

    private void assertNotProcessed() {
        if (this.processed) {
            throw new IllegalStateException("Unexpected attempt to bindTo Bean instance after the Bean instance has been added to a Smooks instance.");
        }
    }

    private static class Binding {
        private String selector;
        private BeanInstancePopulator beanInstancePopulator;
        private boolean assertTargetIsCollection;

        private Binding(String selector, BeanInstancePopulator beanInstancePopulator, boolean assertTargetIsCollection) {
            this.selector = selector;
            this.beanInstancePopulator = beanInstancePopulator;
            this.assertTargetIsCollection = assertTargetIsCollection;
        }
    }
}

