/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import java.util.EmptyStackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.cdr.extension.ResourceConfigUtil;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

public class MapToResourceConfigFromText
implements DOMVisitBefore {
    private static Log logger = LogFactory.getLog(MapToResourceConfigFromText.class);
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String mapTo;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String mapToSpecifier;
    @ConfigParam(defaultVal="##NULL")
    private String defaultValue;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration config;
        String value = DomUtils.getAllText(element, false);
        String mapToPropertyName = this.mapTo;
        if (mapToPropertyName == null) {
            if (this.mapToSpecifier == null) {
                throw new SmooksException("One of attributes 'mapTo' or 'mapToSpecifier' must be specified.");
            }
            mapToPropertyName = DomUtils.getAttributeValue(element, this.mapToSpecifier);
        }
        try {
            config = ExtensionContext.getExtensionContext(executionContext).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No SmooksResourceConfiguration available in ExtensionContext stack.  Unable to set SmooksResourceConfiguration property '" + mapToPropertyName + "' with element text value.");
        }
        if (value == null) {
            value = this.defaultValue;
        }
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not setting property '" + mapToPropertyName + "' on resource configuration.  Element '" + DomUtils.getName(element) + "' text value is null.  You may need to set a default value in the binding configuration."));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting property '" + mapToPropertyName + "' on resource configuration to a value of '" + value + "'."));
        }
        ResourceConfigUtil.setProperty(config, mapToPropertyName, value, element, executionContext);
    }
}

