/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.serialize.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.milyn.util.ClassUtil;
import org.milyn.xml.XmlUtil;

public class WriteAttribsDirective
implements TemplateDirectiveModel {
    public void execute(Environment environment, Map params, TemplateModel[] templateModels, TemplateDirectiveBody templateDirectiveBody) throws TemplateException, IOException {
        Object bean;
        StringModel beanModel;
        Object beanParam = params.get("bean");
        if (beanParam == null) {
            if (params.containsKey("bean")) {
                throw new TemplateException("<@writeAttribs> directive parameter 'bean' is defined, but the bean is not visible in the model.  Should be a valid model object reference (no quotes) e.g. <@writeAttribs bean=customer.address ... />.", environment);
            }
            beanModel = (BeanModel)environment.getDataModel().get("bean");
            bean = beanModel.getWrappedObject();
        } else {
            if (!(beanParam instanceof StringModel)) {
                throw new TemplateException("<@writeAttribs> directive parameter 'bean' not defined properly.  Should be a valid model object reference (no quotes) e.g. <@writeAttribs bean=customer.address ... />.", environment);
            }
            beanModel = (StringModel)beanParam;
            bean = beanModel.getWrappedObject();
        }
        SimpleScalar attribsScalar = (SimpleScalar)params.get("attribs");
        if (attribsScalar == null) {
            if (params.containsKey("attribs")) {
                throw new TemplateException("Mandatory <@writeAttribs> directive parameter 'attribs' not defined properly.  Should be a simple String literal value (comma separated, within quotes) e.g. <@writeAttribs attribs='a,b' ... />.", environment);
            }
            throw new TemplateException("Mandatory <@writeAttribs> directive parameter 'attribs' not defined.  Should be a simple String literal value (comma separated, within quotes) e.g. <@writeAttribs attribs='a,b' ... />.", environment);
        }
        String attribsParamVal = attribsScalar.getAsString().trim();
        String[] attribs = attribsParamVal.split(",");
        for (int i = 0; i < attribs.length; ++i) {
            String attributeName;
            String propertyName;
            String[] attribTokens = attribs[i].split("@");
            if (attribTokens.length == 2) {
                propertyName = attribTokens[0];
                attributeName = attribTokens[1];
            } else {
                propertyName = attribTokens[0];
                attributeName = attribTokens[0];
            }
            Method getterMethod = ClassUtil.getGetterMethodByProperty(propertyName, bean.getClass(), null);
            if (getterMethod == null) {
                throw new TemplateException("<@writeAttribs> directive unable to locate getter method for attribute property '" + propertyName + "' on bean class type '" + bean.getClass().getName() + "'.", environment);
            }
            try {
                Object attribVal = getterMethod.invoke(bean, new Object[0]);
                if (attribVal == null) continue;
                char[] attribStringVal = attribVal.toString().toCharArray();
                if (i > 0) {
                    environment.getOut().write(32);
                }
                environment.getOut().write(attributeName);
                environment.getOut().write("=\"");
                XmlUtil.encodeAttributeValue(attribStringVal, 0, attribStringVal.length, environment.getOut());
                environment.getOut().write("\"");
                continue;
            }
            catch (IllegalAccessException e) {
                throw new TemplateException("<@writeAttribs> directive getter method '" + getterMethod + "' for attribute property '" + propertyName + "' failed.", (Exception)e, environment);
            }
            catch (InvocationTargetException e) {
                throw new TemplateException("<@writeAttribs> directive getter method '" + getterMethod + "' for attribute property '" + propertyName + "' failed.", (Exception)e, environment);
            }
        }
    }
}

