/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.persistence.NonUniqueResultException;
import org.apache.commons.lang.StringUtils;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.repository.BeanId;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.NoLookupResultException;
import org.milyn.persistence.OnNoResult;
import org.milyn.persistence.ParameterListType;
import org.milyn.persistence.parameter.NamedParameterContainer;
import org.milyn.persistence.parameter.Parameter;
import org.milyn.persistence.parameter.ParameterContainer;
import org.milyn.persistence.parameter.ParameterIndex;
import org.milyn.persistence.parameter.ParameterManager;
import org.milyn.persistence.parameter.PositionalParameterContainer;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeReport(summary="Initializing parameter container to hold the parameters needed for the lookup.", detailTemplate="reporting/EntityLocator_before.html")
@VisitAfterReport(summary="Looking up entity to put under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityLocator_after.html")
public class EntityLocator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    @ConfigParam
    private int id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(name="lookup", use=ConfigParam.Use.OPTIONAL)
    private String lookupName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String query;
    @ConfigParam(defaultVal="NULLIFY", decoder=OnNoResult.DataDecoder.class)
    private OnNoResult onNoResult;
    @ConfigParam(defaultVal="false")
    private boolean uniqueResult;
    @ConfigParam(defaultVal="NAMED", decoder=ParameterListType.DataDecoder.class)
    private ParameterListType parameterListType;
    @AppContext
    private ApplicationContext appContext;
    private ApplicationContextObjectStore objectStore;
    private ParameterIndex<?, ?> parameterIndex;
    private BeanId beanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        if (StringUtils.isEmpty((String)this.lookupName) && StringUtils.isEmpty((String)this.query)) {
            throw new SmooksConfigurationException("A lookup name or  a query  needs to be set to be able to lookup anything");
        }
        if (StringUtils.isNotEmpty((String)this.lookupName) && StringUtils.isNotEmpty((String)this.query)) {
            throw new SmooksConfigurationException("Both the lookup name and the query can't be set at the same time");
        }
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        this.parameterIndex = ParameterManager.initializeParameterIndex(this.id, this.parameterListType, this.appContext);
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    @Override
    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet(this.beanIdName);
    }

    @Override
    public boolean consumes(Object object) {
        return this.parameterIndex.containsParameter(object);
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.initParameterContainer(executionContext);
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.initParameterContainer(executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.lookup(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.lookup(executionContext, new Fragment(element));
    }

    public void initParameterContainer(ExecutionContext executionContext) {
        ParameterManager.initializeParameterContainer(this.id, this.parameterListType, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lookup(ExecutionContext executionContext, Fragment source) {
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            dao = this.daoName == null ? (Object)emr.getDefaultDao() : (Object)emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO '" + this.daoName + "'");
            }
            Object result = this.lookup(dao, executionContext);
            if (result != null && this.uniqueResult) {
                if (!(result instanceof Collection)) throw new SmooksConfigurationException("The returned result doesn't implement the '" + Collection.class.getName() + "' interface " + "and there for the unique result check can't be done.");
                Collection resultCollection = (Collection)result;
                if (resultCollection.size() == 0) {
                    result = null;
                } else if (resultCollection.size() == 1) {
                    for (Object value : resultCollection) {
                        result = value;
                    }
                } else {
                    String exception = this.daoName == null ? "The " + this.getDaoNameFromAdapter(dao) + " DAO" : "The DAO '" + this.daoName + "'";
                    exception = exception + " returned multiple results for the ";
                    exception = this.lookupName != null ? exception + "lookup '" + this.lookupName + "'" : exception + "query '" + this.query + "'";
                    throw new NonUniqueResultException(exception);
                }
            }
            if (result == null && this.onNoResult == OnNoResult.EXCEPTION) {
                String exception = this.daoName == null ? "The " + this.getDaoNameFromAdapter(dao) + " DAO" : "The DAO '" + this.daoName + "'";
                exception = exception + " returned no results for lookup ";
                exception = this.lookupName != null ? exception + "lookup '" + this.query + "'" : exception + "query '" + this.query + "'";
                throw new NoLookupResultException(exception);
            }
            BeanContext beanContext = executionContext.getBeanContext();
            if (result == null) {
                beanContext.removeBean(this.beanId, source);
                return;
            } else {
                beanContext.addBean(this.beanId, result, source);
            }
            return;
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }

    public Object lookup(Object dao, ExecutionContext executionContext) {
        ParameterContainer<Parameter<?>> container = ParameterManager.getParameterContainer(this.id, executionContext);
        DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, this.objectStore);
        if (this.query == null) {
            if (this.parameterListType == ParameterListType.NAMED) {
                return daoInvoker.lookup(this.lookupName, ((NamedParameterContainer)container).getParameterMap());
            }
            return daoInvoker.lookup(this.lookupName, ((PositionalParameterContainer)container).getValues());
        }
        if (this.parameterListType == ParameterListType.NAMED) {
            return daoInvoker.lookupByQuery(this.query, ((NamedParameterContainer)container).getParameterMap());
        }
        return daoInvoker.lookupByQuery(this.query, ((PositionalParameterContainer)container).getValues());
    }

    private String getDaoNameFromAdapter(Object dao) {
        String className = dao.getClass().getSimpleName();
        className = className.replace("Dao", "");
        return className.replace("Adapter", "");
    }
}

