/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationFactory;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.db.AbstractDataSource;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.repository.BeanId;
import org.milyn.routing.db.ResultSetScope;
import org.milyn.routing.db.StatementExec;
import org.milyn.routing.db.StatementType;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('executeBefore') && parameters.executeBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('executeBefore') || parameters.executeBefore.value != 'true'")
@VisitBeforeReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
@VisitAfterReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
public class SQLExecutor
implements SmooksResourceConfigurationFactory,
SAXVisitBefore,
SAXVisitAfter,
DOMElementVisitor,
Producer,
Consumer {
    @ConfigParam
    private String datasource;
    @ConfigParam
    private String statement;
    private StatementExec statementExec;
    private String rsAppContextKey;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String resultSetName;
    @ConfigParam(defaultVal="EXECUTION", choice={"EXECUTION", "APPLICATION"}, decoder=ResultSetScopeDecoder.class)
    private ResultSetScope resultSetScope = ResultSetScope.EXECUTION;
    @ConfigParam(defaultVal="900000")
    private long resultSetTTL = 900000L;
    private boolean executeBefore = false;
    @AppContext
    private ApplicationContext appContext;
    private BeanId resultSetBeanId;

    public SQLExecutor setDatasource(AbstractDataSource datasource) {
        AssertArgument.isNotNull(datasource, "datasource");
        this.datasource = datasource.getName();
        return this;
    }

    public SQLExecutor setStatement(String statement) {
        AssertArgument.isNotNullAndNotEmpty(statement, "statement");
        this.statement = statement;
        return this;
    }

    public SQLExecutor setResultSetName(String resultSetName) {
        AssertArgument.isNotNullAndNotEmpty(resultSetName, "resultSetName");
        this.resultSetName = resultSetName;
        return this;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }

    public SQLExecutor setResultSetScope(ResultSetScope resultSetScope) {
        AssertArgument.isNotNull((Object)resultSetScope, "resultSetScope");
        this.resultSetScope = resultSetScope;
        return this;
    }

    public SQLExecutor setResultSetTTL(long resultSetTTL) {
        this.resultSetTTL = resultSetTTL;
        return this;
    }

    public SQLExecutor setExecuteBefore(boolean executeBefore) {
        this.executeBefore = executeBefore;
        return this;
    }

    @Override
    public SmooksResourceConfiguration createConfiguration() {
        SmooksResourceConfiguration config = new SmooksResourceConfiguration();
        config.setParameter("executeBefore", Boolean.toString(this.executeBefore));
        return config;
    }

    @Initialize
    public void intitialize() throws SmooksConfigurationException {
        this.statementExec = new StatementExec(this.statement);
        if (this.statementExec.getStatementType() == StatementType.QUERY && this.resultSetName == null) {
            throw new SmooksConfigurationException("Sorry, query statements must be accompanied by a 'resultSetName' property, under whose value the query results are bound.");
        }
        if (this.resultSetName != null) {
            this.resultSetBeanId = this.appContext.getBeanIdStore().register(this.resultSetName);
        }
        this.rsAppContextKey = this.datasource + ":" + this.statement;
    }

    @Override
    public Set<? extends Object> getProducts() {
        if (this.statementExec.getStatementType() == StatementType.QUERY) {
            return CollectionsUtil.toSet(this.resultSetName);
        }
        return CollectionsUtil.toSet(new Object[0]);
    }

    @Override
    public boolean consumes(Object object) {
        return this.statement.indexOf(object.toString()) != -1;
    }

    @Override
    public void visitBefore(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.executeSQL(executionContext, new Fragment(saxElement));
    }

    @Override
    public void visitAfter(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.executeSQL(executionContext, new Fragment(saxElement));
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext, new Fragment(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(ExecutionContext executionContext, Fragment source) throws SmooksException {
        block15: {
            Connection connection = AbstractDataSource.getConnection(this.datasource, executionContext);
            BeanContext beanContext = executionContext.getBeanContext();
            Map<String, Object> beanMap = beanContext.getBeanMap();
            try {
                if (!this.statementExec.isJoin()) {
                    if (this.statementExec.getStatementType() == StatementType.QUERY) {
                        if (this.resultSetScope == ResultSetScope.EXECUTION) {
                            beanContext.addBean(this.resultSetBeanId, this.statementExec.executeUnjoinedQuery(connection, new Object[0]), source);
                            break block15;
                        }
                        ApplicationContext appContext = executionContext.getContext();
                        ResultSetContextObject rsContextObj = ResultSetContextObject.getInstance(this.rsAppContextKey, appContext);
                        if (rsContextObj.hasExpired()) {
                            ResultSetContextObject resultSetContextObject = rsContextObj;
                            synchronized (resultSetContextObject) {
                                if (rsContextObj.hasExpired()) {
                                    rsContextObj.resultSet = this.statementExec.executeUnjoinedQuery(connection, new Object[0]);
                                    rsContextObj.expiresAt = System.currentTimeMillis() + this.resultSetTTL;
                                }
                            }
                        }
                        List resultMap = rsContextObj.resultSet;
                        beanContext.addBean(this.resultSetBeanId, (Object)resultMap, source);
                        break block15;
                    }
                    this.statementExec.executeUnjoinedUpdate(connection, new Object[0]);
                    break block15;
                }
                if (this.statementExec.getStatementType() == StatementType.QUERY) {
                    ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
                    this.statementExec.executeJoinedQuery(connection, beanMap, resultMap);
                    beanContext.addBean(this.resultSetBeanId, resultMap, source);
                    break block15;
                }
                if (this.resultSetBeanId == null) {
                    this.statementExec.executeJoinedUpdate(connection, beanMap);
                    break block15;
                }
                Object resultSetObj = beanContext.getBean(this.resultSetBeanId);
                if (resultSetObj != null) {
                    try {
                        List resultSet = (List)resultSetObj;
                        this.statementExec.executeJoinedStatement(connection, resultSet);
                        break block15;
                    }
                    catch (ClassCastException e) {
                        throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  Must be of type 'List<Map<String, Object>>'.  Is of type '" + resultSetObj.getClass().getName() + "'.");
                    }
                }
                throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  ResultSet not found in ExecutionContext.");
            }
            catch (SQLException e) {
                throw new SmooksException("Error executing SQL Statement '" + this.statement + "'.", e);
            }
        }
    }

    private static class ResultSetContextObject {
        private List<Map<String, Object>> resultSet;
        private long expiresAt = 0L;

        private ResultSetContextObject() {
        }

        private boolean hasExpired() {
            return this.expiresAt <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ResultSetContextObject getInstance(String rsAppContextKey, ApplicationContext appContext) {
            ResultSetContextObject rsContextObj = (ResultSetContextObject)appContext.getAttribute(rsAppContextKey);
            if (rsContextObj == null) {
                ApplicationContext applicationContext = appContext;
                synchronized (applicationContext) {
                    rsContextObj = (ResultSetContextObject)appContext.getAttribute(rsAppContextKey);
                    if (rsContextObj == null) {
                        rsContextObj = new ResultSetContextObject();
                        appContext.setAttribute(rsAppContextKey, rsContextObj);
                    }
                }
            }
            return rsContextObj;
        }
    }

    public static class ResultSetScopeDecoder
    implements DataDecoder {
        @Override
        public Object decode(String data) throws DataDecodeException {
            ResultSetScope scope;
            data = data.trim();
            try {
                scope = ResultSetScope.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                throw new DataDecodeException("Failed to decode ResultSetScope value '" + data + "'.  Allowed values are " + Arrays.asList(ResultSetScope.values()) + ".");
            }
            return scope;
        }
    }
}

