/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.csv.CSVBindingType;
import org.milyn.csv.CSVHeaderValidationException;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.function.StringFunctionExecutor;
import org.milyn.javabean.Bean;
import org.milyn.javabean.context.BeanContext;
import org.milyn.xml.SmooksXMLReader;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class CSVReader
implements SmooksXMLReader,
VisitorAppender {
    private static Log logger = LogFactory.getLog(CSVReader.class);
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static final String IGNORE_FIELD = "$ignore$";
    private static char[] INDENT_LF = new char[]{'\n'};
    private static char[] INDENT_1 = new char[]{'\t'};
    private static char[] INDENT_2 = new char[]{'\t', '\t'};
    private static String RECORD_NUMBER_ATTR = "number";
    private static String RECORD_TRUNCATED_ATTR = "truncated";
    private ContentHandler contentHandler;
    private ExecutionContext execContext;
    @ConfigParam(name="fields")
    private String[] csvFields;
    private Field[] fields;
    @ConfigParam(defaultVal=",")
    private char separator;
    @ConfigParam(name="quote-char", defaultVal="\"")
    private char quoteChar;
    @ConfigParam(name="escape-char", defaultVal="\\")
    private char escapeChar;
    @ConfigParam(name="skip-line-count", defaultVal="0")
    private int skipLines;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    @ConfigParam(defaultVal="csv-set")
    private String rootElementName;
    @ConfigParam(defaultVal="csv-record")
    private String recordElementName;
    @ConfigParam(defaultVal="false")
    private boolean indent;
    @ConfigParam(defaultVal="true")
    private boolean strict;
    @ConfigParam(defaultVal="false")
    private boolean validateHeader;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindBeanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Class<?> bindBeanClass;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private CSVBindingType bindingType;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindMapKeyField;
    private static final String RECORD_BEAN = "csvRecordBean";

    @Initialize
    public void initialize() {
        this.buildFields();
    }

    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.bindBeanId != null && this.bindBeanClass != null) {
            if (this.bindingType == CSVBindingType.LIST) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId, "$document");
                Bean bean = listBean.newBean(this.bindBeanClass, this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                listBean.addVisitors(visitorMap);
            } else if (this.bindingType == CSVBindingType.MAP) {
                if (this.bindMapKeyField == null) {
                    throw new SmooksConfigurationException("CSV 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.assertValidFieldName(this.bindMapKeyField);
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId, "$document");
                Bean recordBean = new Bean(this.bindBeanClass, RECORD_BEAN, this.recordElementName);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField, this.bindBeanId);
                this.addFieldBindings(recordBean);
                mapBean.addVisitors(visitorMap);
                recordBean.addVisitors(visitorMap);
                visitorMap.addVisitor((Visitor)wiringVisitor, this.recordElementName, null, false);
            } else {
                Bean bean = new Bean(this.bindBeanClass, this.bindBeanId, this.recordElementName);
                this.addFieldBindings(bean);
                bean.addVisitors(visitorMap);
            }
        }
    }

    private void addFieldBindings(Bean bean) {
        for (Field field : this.fields) {
            if (field.ignore()) continue;
            bean.bindTo(field.getName(), this.recordElementName + "/" + field.getName());
        }
    }

    private void buildFields() {
        Field[] fields = new Field[this.csvFields.length];
        for (int i = 0; i < this.csvFields.length; ++i) {
            String fieldInfos;
            String fieldName = fieldInfos = this.csvFields[i].trim();
            StringFunctionExecutor stringFunctionExecutor = null;
            if (fieldInfos.indexOf(63) >= 0) {
                fieldName = fieldInfos.substring(0, fieldInfos.indexOf(63));
                String functionDefinition = fieldInfos.substring(fieldInfos.indexOf(63) + 1);
                if (functionDefinition.length() != 0) {
                    stringFunctionExecutor = StringFunctionExecutor.getInstance((String)functionDefinition);
                }
            }
            fields[i] = new Field(fieldName, stringFunctionExecutor);
        }
        this.fields = fields;
    }

    public void setExecutionContext(ExecutionContext request) {
        this.execContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource csvInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse CSV stream.");
        }
        if (this.execContext == null) {
            throw new IllegalStateException("'execContext' not set.  Cannot parse CSV stream.");
        }
        try {
            String[] csvRecord;
            Reader csvStreamReader = csvInputSource.getCharacterStream();
            if (csvStreamReader == null) {
                csvStreamReader = new InputStreamReader(csvInputSource.getByteStream(), this.encoding);
            }
            au.com.bytecode.opencsv.CSVReader csvLineReader = new au.com.bytecode.opencsv.CSVReader(csvStreamReader, this.separator, this.quoteChar, this.escapeChar, this.skipLines);
            if (this.validateHeader) {
                this.validateHeader(csvLineReader);
            }
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
            int lineNumber = 0;
            int expectedCount = this.getExpectedColumnsCount();
            while ((csvRecord = csvLineReader.readNext()) != null) {
                ++lineNumber;
                if (csvRecord.length < expectedCount && this.strict) {
                    logger.debug((Object)("[CORRUPT-CSV] CSV line #" + lineNumber + " invalid [" + Arrays.asList(csvRecord) + "].  The line should contain number of items at least as in CSV config file " + this.csvFields.length + " fields [" + this.csvFields + "], but contains " + csvRecord.length + " fields.  Ignoring!!"));
                    continue;
                }
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", RECORD_NUMBER_ATTR, RECORD_NUMBER_ATTR, "xs:int", Integer.toString(lineNumber));
                if (csvRecord.length < expectedCount) {
                    attrs.addAttribute("", RECORD_TRUNCATED_ATTR, RECORD_TRUNCATED_ATTR, "xs:boolean", Boolean.TRUE.toString());
                }
                this.contentHandler.startElement("", this.recordElementName, "", attrs);
                int recordIt = 0;
                for (Field field : this.fields) {
                    String fieldName = field.getName();
                    if (field.ignore()) {
                        int toSkip = this.parseIgnoreFieldDirective(fieldName);
                        if (toSkip == Integer.MAX_VALUE) break;
                        recordIt += toSkip;
                        continue;
                    }
                    if (this.indent) {
                        this.contentHandler.characters(INDENT_LF, 0, 1);
                        this.contentHandler.characters(INDENT_2, 0, 2);
                    }
                    if (recordIt < csvRecord.length) {
                        String value = csvRecord[recordIt];
                        this.contentHandler.startElement("", fieldName, "", EMPTY_ATTRIBS);
                        StringFunctionExecutor stringFunctionExecutor = field.getStringFunctionExecutor();
                        if (stringFunctionExecutor != null) {
                            value = stringFunctionExecutor.execute(value);
                        }
                        this.contentHandler.characters(value.toCharArray(), 0, value.length());
                        this.contentHandler.endElement("", fieldName, "");
                    }
                    if (this.indent) {
                        // empty if block
                    }
                    ++recordIt;
                }
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                    this.contentHandler.characters(INDENT_1, 0, 1);
                }
                this.contentHandler.endElement(null, this.recordElementName, "");
            }
            if (this.indent) {
                this.contentHandler.characters(INDENT_LF, 0, 1);
            }
            this.contentHandler.endElement("", this.rootElementName, "");
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
            this.execContext = null;
        }
    }

    private void validateHeader(au.com.bytecode.opencsv.CSVReader reader) throws IOException {
        String[] headers = reader.readNext();
        if (headers == null) {
            throw new CSVHeaderValidationException(Arrays.asList(this.getFieldNames(this.fields)));
        }
        if (this.validateHeader(this.fields, headers)) {
            return;
        }
        throw new CSVHeaderValidationException(Arrays.asList(this.getFieldNames(this.fields)), Arrays.asList(headers));
    }

    private String[] getFieldNames(Field[] fields) {
        if (fields == null) {
            return new String[0];
        }
        String[] names = new String[fields.length];
        int n = 0;
        for (Field field : fields) {
            if (!field.ignore()) {
                names[n] = field.getName();
            }
            ++n;
        }
        return names;
    }

    private boolean validateHeader(Field[] fields, String[] headers) {
        if (fields.length != headers.length) {
            return false;
        }
        int n = 0;
        for (Field field : fields) {
            if (!field.ignore()) {
                String name;
                if (headers.length <= n) {
                    return false;
                }
                String header = headers[n];
                if (header == null) {
                    header = "";
                }
                if ((name = field.getName()) == null) {
                    name = "";
                }
                if (!name.equals(header)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private int parseIgnoreFieldDirective(String field) {
        String op = field.substring(IGNORE_FIELD.length());
        int toSkip = 0;
        toSkip = op.length() == 0 ? 1 : ("+".equals(op) ? Integer.MAX_VALUE : Integer.parseInt(op));
        return toSkip;
    }

    private int getExpectedColumnsCount() {
        int count = 0;
        for (Field field : this.fields) {
            if (field.ignore()) continue;
            ++count;
        }
        return count;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private void assertValidFieldName(String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return;
        }
        String fieldNames = "";
        for (Field field : this.fields) {
            if (field.ignore()) continue;
            if (fieldNames.length() > 0) {
                fieldNames = fieldNames + ", ";
            }
            fieldNames = fieldNames + field.getName();
        }
        throw new SmooksConfigurationException("Invalid field name '" + fieldName + "'.  Valid names: [" + fieldNames + "].");
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private class MapBindingWiringVisitor
    implements DOMVisitAfter,
    SAXVisitAfter,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("csvRecordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue((Object)beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(CSVReader.RECORD_BEAN);
            map.put(key, record);
        }

        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }

    private class Field {
        private final String name;
        private final boolean ignore;
        private final StringFunctionExecutor stringFunctionExecutor;

        public Field(String name, StringFunctionExecutor stringFunctionExecutor) {
            this.name = name;
            this.stringFunctionExecutor = stringFunctionExecutor;
            this.ignore = name.startsWith(CSVReader.IGNORE_FIELD);
        }

        public String getName() {
            return this.name;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public StringFunctionExecutor getStringFunctionExecutor() {
            return this.stringFunctionExecutor;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("name", (Object)this.name).append("stringFunctionExecutor", (Object)this.stringFunctionExecutor);
            return builder.toString();
        }
    }
}

