/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.milyn.archive.Archive;
import org.milyn.assertion.AssertArgument;
import org.milyn.ect.EdiSpecificationReader;
import org.milyn.ect.formats.unedifact.UnEdifactSpecificationReader;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdiConvertionTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromUnEdifactSpec(ZipInputStream specification, ZipOutputStream modelSetOutStream, String urn) throws IOException {
        try {
            EdiConvertionTool.fromSpec((EdiSpecificationReader)new UnEdifactSpecificationReader(specification, true), modelSetOutStream, urn);
        }
        finally {
            specification.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromSpec(EdiSpecificationReader ediSpecificationReader, ZipOutputStream modelSetOutStream, String urn) throws IOException {
        AssertArgument.isNotNull((Object)ediSpecificationReader, (String)"ediSpecificationReader");
        AssertArgument.isNotNull((Object)modelSetOutStream, (String)"modelSetOutStream");
        try {
            Archive archive = EdiConvertionTool.createArchive(ediSpecificationReader, urn);
            archive.toOutputStream(modelSetOutStream);
        }
        finally {
            modelSetOutStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromUnEdifactSpec(ZipInputStream specification, File modelSetOutFolder, String urn) throws IOException {
        try {
            EdiConvertionTool.fromSpec((EdiSpecificationReader)new UnEdifactSpecificationReader(specification, true), modelSetOutFolder, urn);
        }
        finally {
            specification.close();
        }
    }

    public static void fromSpec(EdiSpecificationReader ediSpecificationReader, File modelSetOutFolder, String urn) throws IOException {
        AssertArgument.isNotNull((Object)ediSpecificationReader, (String)"ediSpecificationReader");
        AssertArgument.isNotNull((Object)modelSetOutFolder, (String)"modelSetOutFolder");
        Archive archive = EdiConvertionTool.createArchive(ediSpecificationReader, urn);
        archive.toFileSystem(modelSetOutFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Archive createArchive(EdiSpecificationReader ediSpecificationReader, String urn) throws IOException {
        Archive archive = new Archive();
        StringBuilder modelListBuilder = new StringBuilder();
        Set<String> messages = ediSpecificationReader.getMessageNames();
        StringWriter messageEntryWriter = new StringWriter();
        String pathPrefix = urn.replace(".", "_").replace(":", "/");
        for (String message : messages) {
            Edimap model = ediSpecificationReader.getMappingModel(message);
            String messageEntryPath = pathPrefix + "/" + message + ".xml";
            EdiConvertionTool.removeDuplicateSegments(model.getSegments());
            messageEntryWriter.getBuffer().setLength(0);
            model.write((Writer)messageEntryWriter);
            archive.addEntry(messageEntryPath, messageEntryWriter.toString());
            modelListBuilder.append("/" + messageEntryPath);
            modelListBuilder.append("!" + model.getDescription().getName());
            modelListBuilder.append("!" + model.getDescription().getVersion());
            modelListBuilder.append("\n");
        }
        archive.addEntry("META-INF/services/org/smooks/edi/mapping-model.lst", modelListBuilder.toString());
        archive.addEntry("META-INF/services/org/smooks/edi/urn", urn);
        Properties interchangeProperties = ediSpecificationReader.getInterchangeProperties();
        ByteArrayOutputStream propertiesOutStream = new ByteArrayOutputStream();
        try {
            interchangeProperties.store(propertiesOutStream, "UN/EDIFACT Interchange Properties");
            propertiesOutStream.flush();
            archive.addEntry("META-INF/services/org/smooks/edi/interchange.properties", propertiesOutStream.toByteArray());
        }
        finally {
            propertiesOutStream.close();
        }
        return archive;
    }

    private static void removeDuplicateSegments(SegmentGroup segmentGroup) {
        List segments;
        if (segmentGroup instanceof Segment) {
            EdiConvertionTool.removeDuplicateFields(((Segment)segmentGroup).getFields());
        }
        if ((segments = segmentGroup.getSegments()) != null) {
            EdiConvertionTool.removeDuplicateMappingNodes(segments);
            for (SegmentGroup childSegmentGroup : segments) {
                EdiConvertionTool.removeDuplicateSegments(childSegmentGroup);
            }
        }
    }

    private static void removeDuplicateFields(List<Field> fields) {
        if (fields != null && !fields.isEmpty()) {
            EdiConvertionTool.removeDuplicateMappingNodes(fields);
            for (Field field : fields) {
                EdiConvertionTool.removeDuplicateComponents(field.getComponents());
            }
        }
    }

    private static void removeDuplicateComponents(List<Component> components) {
        if (components != null && !components.isEmpty()) {
            EdiConvertionTool.removeDuplicateMappingNodes(components);
            for (Component component : components) {
                EdiConvertionTool.removeDuplicateMappingNodes(component.getSubComponents());
            }
        }
    }

    private static void removeDuplicateMappingNodes(List mappingNodes) {
        if (mappingNodes == null || mappingNodes.isEmpty()) {
            return;
        }
        Set<String> nodeNames = EdiConvertionTool.getMappingNodeNames(mappingNodes);
        if (nodeNames.size() < mappingNodes.size()) {
            for (String nodeName : nodeNames) {
                int nodeCount = EdiConvertionTool.getMappingNodeCount(mappingNodes, nodeName);
                if (nodeCount <= 1) continue;
                EdiConvertionTool.removeDuplicateMappingNodes(mappingNodes, nodeName);
            }
        }
    }

    private static void removeDuplicateMappingNodes(List mappingNodes, String nodeName) {
        int tagIndex = 1;
        for (Object mappingNodeObj : mappingNodes) {
            MappingNode mappingNode = (MappingNode)mappingNodeObj;
            String xmlTag = mappingNode.getXmltag();
            if (xmlTag == null || !xmlTag.equals(nodeName)) continue;
            mappingNode.setXmltag(xmlTag + "_-_-" + tagIndex);
            ++tagIndex;
        }
    }

    private static Set<String> getMappingNodeNames(List mappingNodes) {
        LinkedHashSet<String> nodeNames = new LinkedHashSet<String>();
        for (Object mappingNode : mappingNodes) {
            String xmlTag = ((MappingNode)mappingNode).getXmltag();
            if (xmlTag == null) continue;
            nodeNames.add(xmlTag);
        }
        return nodeNames;
    }

    private static int getMappingNodeCount(List mappingNodes, String nodeName) {
        int nodeCount = 0;
        for (Object mappingNode : mappingNodes) {
            String xmlTag = ((MappingNode)mappingNode).getXmltag();
            if (xmlTag == null || !xmlTag.equals(nodeName)) continue;
            ++nodeCount;
        }
        return nodeCount;
    }
}

